import { elementsCreateConference, elementsConference } from "./basicView.js";

// create conference

const weekDays = [
  "Sunday",
  "Monday",
  "Thuesday",
  "Wednesday",
  "Thursday",
  "Friday",
  "Saturday"
];

export function getCreateFormInput() {
  return {
    name: elementsCreateConference.inputConferenceName.value,
    startDate: elementsCreateConference.inputConferenceStart.value,
    finishDate: elementsCreateConference.inputConferenceFinish.value
  };
}

export function control(param) {
  if (param.startDate > param.finishDate) {
    return false;
  }
  return true;
}

export function setConferenceTitle(title) {
  elementsCreateConference.conferenceTitle.textContent = title;
}

//conference

export function renderDay(date) {
  const html = `
        <div class="schedule-day" data-day="${date.getTime()}">
          <div class="schedule-date">
            <p>${date.getDate()}-${date.getMonth() +
    1}-${date.getFullYear()}</p>
            <p>${weekDays[date.getDay()]}</p>
          </div>
          <div class="schedule-rooms-container">
          <div class="schedule-rooms-container-inner">
            <div class="schedule-room-container">
              <div class="schedule-room">
                <div class="schedule-double-container">
                  <div class="schedule-room-name">
                    <input type="text" class="input-room" placeholder="Room" />
                    <button class="delete-room">
                      X
                    </button>
                  </div>
                  <div class="schedule-double-header-container">
                    <div class="schedule-double-header">
                      <div class="schedule-section">
                        <input type="text" placeholder="Section" />
                      </div>
                      <div class="schedule-chair">
                        <p>Chair</p>
                      </div>
                    </div>
                  </div>
                  <div class="schedule-double-item">
                    <div class="schedule-time">
                      <input type="time" value="08:00" step="300" />
                    </div>
                    <div class="schedule-topic unfilled">
                      <p>Event</p>
                    </div>
                  </div>
                </div>
              </div>
              <div class="schedule-room-footer">
                <div class="schedule-time">
                  <input type="time" value="16:00" step="300" />
                </div>
                <div class="schedule-footer-buttons">
                  <button class="btn-plus">+</button>
                  <button class="btn-new-section">New Section</button>
                </div>
              </div>
            </div>
            </div>
            <button class="new-room-btn" title="Add room">
              <i class="fas fa-indent"></i>
            </button>
          </div>
        </div>
    `;
  elementsConference.schedule.insertAdjacentHTML("beforeend", html);
}

export function renderRoom(element) {
  const html = `
            <div class="schedule-room-container">
              <div class="schedule-room">
                <div class="schedule-double-container">
                  <div class="schedule-room-name">
                    <input type="text" class="input-room" placeholder="Room" />
                    <button class="delete-room">
                      X
                    </button>
                  </div>
                  <div class="schedule-double-header-container">
                    <div class="schedule-double-header">
                      <div class="schedule-section">
                        <input type="text" placeholder="Section" />
                      </div>
                      <div class="schedule-chair">
                        <p>Chair</p>
                      </div>
                    </div>
                  </div>
                  <div class="schedule-double-item">
                    <div class="schedule-time">
                      <input type="time" value="08:00" step="300" />
                    </div>
                    <div class="schedule-topic unfilled">
                      <p>Event</p>
                    </div>
                  </div>
                </div>
              </div>
              <div class="schedule-room-footer">
                <div class="schedule-time">
                  <input type="time" value="16:00" step="300" />
                </div>
                <div class="schedule-footer-buttons">
                  <button class="btn-plus">+</button>
                  <button class="btn-new-section">New Section</button>
                </div>
              </div>
            </div>
    `;
  element
    .querySelector(".schedule-rooms-container-inner")
    .insertAdjacentHTML("beforeend", html);
}

export function renderCell(element) {
  const html = `
                  <div class="schedule-double-item">
                    <div class="schedule-time">
                      <input type="time" value="08:00" step="300" />
                    </div>
                    <div class="schedule-topic unfilled">
                      <p>Event</p>
                    </div>
                  </div>`;
  element
    .querySelector(".schedule-double-container")
    .insertAdjacentHTML("beforeend", html);
}

export function renderSection(element) {
  const html = `
                <div class="schedule-double-header">
                  <div class="schedule-section">
                    <input type="text" placeholder="Section" />
                  </div>
                  <div class="schedule-chair">
                    <p>Chair</p>
                  </div>
                </div>
  `;
  element
    .querySelector(".schedule-double-header-container")
    .insertAdjacentHTML("beforeend", html);
}

export function lengthControl(targetElement, draggedElement) {
  if (draggedElement.firstElementChild.textContent.length > 22) {
    targetElement.setAttribute("style", "font-size: 0.65rem");
  } else {
    targetElement.setAttribute("style", "font-size: 0.85rem");
  }
}

export function setAttribute(element, attribute) {
  element.setAttribute("style", attribute);
}

export function dragStart(element) {
  element.style.border = "2px solid var(--primaryColor)";
  element.style.margin = "-2px";
}

export function dragEnd(element) {
  element.style.border = "none";
  element.style.margin = "0.3rem 0";
}

export function correctDrop(targetElement, draggedElement) {
  targetElement.textContent = draggedElement.textContent;
  targetElement.classList.remove("unfilled");
  targetElement.parentElement.classList.remove("unfilled");
}
