import { elementsContribution } from "./basicView.js";

export function getInput() {
  return {
    title: elementsContribution.inputTitle.value,
    author: elementsContribution.inputAuthor.value,
    abstract: elementsContribution.inputAbstract.value,
    powerpoint: elementsContribution.inputPowerpoint.value
  };
}

export function setInput(item) {
  elementsContribution.inputTitle.value = item.title;
  elementsContribution.inputAuthor.value = item.author;
  elementsContribution.inputAbstract.value = item.abstract;
  elementsContribution.inputPowerpoint.value = item.powerpoint;
}

export function clearInput() {
  elementsContribution.inputTitle.value = "";
  elementsContribution.inputAuthor.value = "";
  elementsContribution.inputAbstract.value = "";
  elementsContribution.inputPowerpoint.value = "";
}

export function renderItem(item) {
  const html = `
            <article class="enrollment-item" data-id="${item.id}">
            <div class="enrollment-info">
              <h2 class = "item-title">${item.title}</h2>
              <div class="contribution-data">
                <div class="contribution-icons">
                  <i class="far fa-list-alt abstract-icon" title="abstract"></i>
                  <i
                    class="far fa-file-powerpoint powerpoint-icon"
                    title="power-point"
                  ></i>
                </div>
                <p class = "item-author">${item.author}</p>
              </div>
            </div>
            <div class="enrollment-icons">
              <button class="edit-icon">
                <i class="fas fa-edit"></i>
              </button>
              <button class="delete-icon">
                X
              </button>
            </div>
          </article>
  `;
  elementsContribution.enrollmentItems.insertAdjacentHTML("beforeend", html);
}

export function deleteItem(id) {
  const item = document.querySelector(`[data-id="${id}"]`);
  if (item) {
    item.parentElement.removeChild(item);
  }
}

export function updateItem(item) {
  const element = document.querySelector(`[data-id="${item.id}"]`);
  const titleElement = element.querySelector(".item-title");
  titleElement.textContent = item.title;
  const authorElement = element.querySelector(".item-author");
  authorElement.textContent = item.author;
}

export function toEditIcon() {
  elementsContribution.addEditIcon.innerHTML = `<i class="fas fa-exchange-alt"></i>`;
  elementsContribution.addEditIcon.title = "Edit chosen contribution";
}

export function toAddIcon() {
  elementsContribution.addEditIcon.innerHTML = `<i class="fas fa-plus-square"></i>`;
  elementsContribution.addEditIcon.title = "Add new contribution";
}
