import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.control.*;
import javafx.scene.control.MenuBar;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import java.io.File;
import java.util.Optional;


public class AppMenuBar extends MenuBar {

    Menu fileMenu;
    Menu settingsMenu;
    Menu helpMenu;
    Menu velkost;
    MenuItem novy;
    MenuItem ulozit;
    MenuItem ulozitAko;
    MenuItem nacitat;
    MenuItem spustit;
    MenuItem ukoncit;
    MenuItem zoznam;
    MenuItem pomoc;
    MenuItem velkost12;
    MenuItem velkost16;
    MenuItem velkost20;
    MenuItem velkost28;
    MenuItem velkost36;
    MenuItem velkost50;
    CheckMenuItem cislovanie;
    CheckMenuItem navrhovanie;
    FileChooser fileChooser;
    File actualFile;

    public AppMenuBar(Stage stage){
        fileMenu = new Menu("Súbor");
        settingsMenu = new Menu("Nastavenia");
        helpMenu = new Menu("Pomocník");

        novy = new MenuItem("Nový         Ctrl+N");
        fileMenu.getItems().add(novy);

        spustit = new MenuItem("Spustiť      F5");
        fileMenu.getItems().add(spustit);

        ulozit = new MenuItem("Uložiť       Ctrl+S");
        fileMenu.getItems().add(ulozit);

        ulozitAko = new MenuItem("Uložiť ako");
        fileMenu.getItems().add(ulozitAko);

        nacitat = new MenuItem("Načítať      Ctrl+O");
        fileMenu.getItems().add(nacitat);

        ukoncit = new MenuItem("Ukončiť      Alt+F4");
        fileMenu.getItems().add(ukoncit);


        velkost = new Menu("Veľkosť písma");
        velkost12 = new MenuItem("12");
        velkost16 = new MenuItem("16");
        velkost20 = new MenuItem("20");
        velkost28 = new MenuItem("28");
        velkost36 = new MenuItem("36");
        velkost50 = new MenuItem("50");
        velkost.getItems().addAll(velkost12, velkost16, velkost20, velkost28, velkost36, velkost50);
        settingsMenu.getItems().add(velkost);

        cislovanie = new CheckMenuItem("Číslovanie riadkov");
        settingsMenu.getItems().add(cislovanie);

        navrhovanie = new CheckMenuItem("Navrhovanie príkazov");
        settingsMenu.getItems().add(navrhovanie);

        zoznam = new MenuItem("Zoznam zvukov");
        helpMenu.getItems().add(zoznam);

        pomoc = new MenuItem("Pomoc");
        helpMenu.getItems().add(pomoc);

        fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("TXT files (*.txt)", "*.txt");
        fileChooser.getExtensionFilters().add(extFilter);
        actualFile = null;

        ukoncit.setOnAction(e -> {
            Platform.exit();
            System.exit(0);
        });

        spustit.setOnAction(e -> {
            try {
                GUI.run();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        });

        ulozitAko.setOnAction(e -> {
            fileChooser.setTitle("Uložiť ako");
            File file = fileChooser.showSaveDialog(stage);
            if(file != null){
                GUI.saveFile(file);
            }
            actualFile = file;
        });

        ulozit.setOnAction(e -> {
            if(GUI.saved){
                GUI.saveFile(actualFile);
            }
            else {
                fileChooser.setTitle("Uložiť ako");
                File file = fileChooser.showSaveDialog(stage);
                if(file != null){
                    GUI.saveFile(file);
                }
            }
        });

        nacitat.setOnAction(e -> {
            fileChooser.setTitle("Načítať");
            File file = fileChooser.showOpenDialog(stage);
            if(file != null){
                GUI.loadFile(file);
            }
            actualFile = file;
        });

        novy.setOnAction(e -> {
            if(GUI.saved && GUI.changed){
                Dialog dialog = new Dialog();
                dialog.setTitle("Chcete uložiť zmeny?");
                dialog.initStyle(StageStyle.UTILITY);
                ButtonType btnYes = new ButtonType("Áno");
                ButtonType btnNo = new ButtonType("Nie");
                dialog.getDialogPane().getButtonTypes().addAll(btnYes, btnNo);
                dialog.setResultConverter(dialogButton -> {
                    if(dialogButton == btnYes){
                        GUI.saveFile(actualFile);
                        GUI.clearEditingWindow();
                    }
                    else{
                        GUI.clearEditingWindow();
                    }
                    actualFile = null;
                    return 0;
                });
                Optional<Boolean> result = dialog.showAndWait();

            }
            else if(!GUI.saved && GUI.changed){
                //chcete ulozit zmeny v subore, ak kliknem ano tak sa otvori ukladaci dialog
                Dialog dialog = new Dialog();
                dialog.setTitle("Chcete uložiť súbor?");
                dialog.initStyle(StageStyle.UTILITY);
                ButtonType btnYes = new ButtonType("Áno");
                ButtonType btnNo = new ButtonType("Nie");
                dialog.getDialogPane().getButtonTypes().addAll(btnYes, btnNo);
                dialog.setResultConverter(dialogButton -> {
                    if(dialogButton == btnYes){
                        fileChooser.setTitle("Uložiť ako");
                        File file = fileChooser.showSaveDialog(stage);
                        if(file != null){
                            GUI.saveFile(file);
                            GUI.clearEditingWindow();
                        }
                    }
                    else{
                        GUI.clearEditingWindow();
                    }
                    actualFile = null;
                    return 0;
                });
                Optional<Boolean> result = dialog.showAndWait();
            }
            else{
                GUI.clearEditingWindow();
                GUI.changed = false;
                GUI.saved = false;
                actualFile = null;
            }
        });

        velkost12.setOnAction(e -> {
            GUI.editingWindow.setStyle("-fx-font-size: 12;");
            GUI.output.setStyle("-fx-font-size: 12;");
            GUI.textSize = 12;
        });
        velkost16.setOnAction(e -> {
            GUI.editingWindow.setStyle("-fx-font-size: 16;");
            GUI.output.setStyle("-fx-font-size: 16;");
            GUI.textSize = 16;
        });
        velkost20.setOnAction(e -> {
            GUI.editingWindow.setStyle("-fx-font-size: 20;");
            GUI.output.setStyle("-fx-font-size: 20;");
            GUI.textSize = 20;
        });
        velkost28.setOnAction(e -> {
            GUI.editingWindow.setStyle("-fx-font-size: 28;");
            GUI.output.setStyle("-fx-font-size: 28;");
            GUI.textSize = 28;
        });
        velkost36.setOnAction(e -> {
            GUI.editingWindow.setStyle("-fx-font-size: 36;");
            GUI.output.setStyle("-fx-font-size: 36;");
            GUI.textSize = 36;
        });
        velkost50.setOnAction(e -> {
            GUI.editingWindow.setStyle("-fx-font-size: 50;");
            GUI.output.setStyle("-fx-font-size: 50;");
            GUI.textSize = 50;
        });


        cislovanie.setOnAction(e -> {
            if(cislovanie.isSelected()){
                GUI.turnOnNumbering();
            }
            else{
                GUI.turnOffNumbering();
            }
            GUI.contextMenu.hide();
        });



    }




}
