import javafx.animation.PauseTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.*;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.*;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.application.Application;
import javafx.util.Duration;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

import javax.sound.sampled.*;
import javax.swing.text.html.parser.Parser;
import java.awt.*;
import java.io.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;


public class GUI extends Application implements EventHandler<ActionEvent> {
    Button btnPlaySound;
    static Button btnSayText;
    static TextArea editingWindow;
    static Label output;
    static int currentLine;
    static int textSize;
    static MediaPlayer mediaPlayer;
    static Media sound;
    static AppMenuBar menuBar;
    static EditingWindowContextMenu contextMenu;
    Scene scene;
    ScrollPane scrollPane;
    static Boolean changed;
    static Boolean saved;
    static String actualWord;
    static LexicalAnalyzer lexicalAnalyzer;
    static String text;
    static Output outputSequence;
    static HashMap<String, Integer> soundsTime;


    @Override
    public void start(Stage stage) throws Exception {
        stage.setTitle("");

        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
        changed = false;
        saved = false;
        currentLine = 0;
        textSize = 16;
        soundsTime = new HashMap<>();
        loadSounds();
        menuBar = new AppMenuBar(stage);
        menuBar.getMenus().add(menuBar.fileMenu);
        menuBar.getMenus().add(menuBar.settingsMenu);
        menuBar.getMenus().add(menuBar.helpMenu);
        contextMenu = new EditingWindowContextMenu(stage);
        contextMenu.getItems().addAll(contextMenu.povedz, contextMenu.zahraj);
        lexicalAnalyzer = new LexicalAnalyzer();

        btnPlaySound = new Button();
        btnPlaySound.setText("Zahraj zvuk");
        btnPlaySound.setOnAction(this);

        btnSayText = new Button() ;
//            public void executeAccessibleAction(AccessibleAction action, Object... parameters) {
//                switch (action) {
//                    case FIRE:
////                        synthesizedText.setText(output.getText());
//                        synthesizedText.setText(synthesizedOutput.getText());
//                        break;
//                    default:
//                        super.executeAccessibleAction(action, parameters);
//                }
//            }
//        };
        btnSayText.setText("");
        btnSayText.setAccessibleRole(AccessibleRole.BUTTON);
        btnSayText.setOnAction(this);

        editingWindow = new TextArea("");
        editingWindow.setStyle("-fx-font-size: 16;");
        editingWindow.setAccessibleRole(AccessibleRole.TEXT_AREA);
        editingWindow.positionCaret(13);
        editingWindow.setContextMenu(contextMenu);

        output = new Label("");
        output.setPrefHeight(300);
        output.setPrefWidth(screenBounds.getWidth());
        output.setPadding(new Insets(10,10,10,30));
        output.setAlignment(Pos.TOP_LEFT);
        output.setAccessibleRole(AccessibleRole.TEXT);
        output.setStyle("-fx-font-size: 16;");


        scrollPane = new ScrollPane();
        scrollPane.setContent(output);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        VBox layout = new VBox();
        HBox editingLayout = new HBox();
        Label empty = new Label("");
        editingLayout.getChildren().addAll(empty, editingWindow);
        editingLayout.prefHeightProperty().bind(stage.heightProperty().multiply(0.7));
        editingWindow.prefWidthProperty().bind(stage.widthProperty().multiply(0.9));
        empty.prefWidthProperty().bind(stage.widthProperty().multiply(0.1));
        output.prefHeightProperty().bind(stage.heightProperty().multiply(0.3));
        layout.getChildren().addAll(menuBar, editingLayout, scrollPane);

        editingWindow.setOnKeyPressed(new EventHandler<KeyEvent>() {
            @Override
            public void handle(KeyEvent keyEvent) {
                if(keyEvent.getCode() == KeyCode.ENTER)
                {
                    if(menuBar.cislovanie.isSelected()){
                        String toCount = editingWindow.getText();
                        String[] lineArray = toCount.split("\n");
                        int num = lineArray.length;
                        int odsadenie = 12;
                        for (int i = 1; i <= Integer.toString(num+1).length(); i++){
                            odsadenie -= 2;
                        }
                        editingWindow.appendText( Integer.toString(num  + 1) );
                        for (int i = 1; i <= odsadenie; i++){
                            editingWindow.appendText(" ");
                        }
                    }
                    else{
//                        editingWindow.insertText(editingWindow.getCaretPosition(), "            ");
                    }
                }

            }
        });

        editingWindow.textProperty().addListener(new ChangeListener<String>() {
            @Override
            public void changed(ObservableValue<? extends String> observableValue, String s, String t1) {
                changed = true;
                if(menuBar.navrhovanie.isSelected()){
                    contextMenu.hide();
                    actualWord = getActualWord();;
                    List<String> prefixes = contextMenu.isPrefixOf(actualWord);
                    if(prefixes.size() > 0 && actualWord != "") {
                        contextMenu = new EditingWindowContextMenu(stage);
                        fillContextMenu(prefixes, contextMenu);
                        contextMenu.show(editingWindow, Side.LEFT, -50, 0);
                        contextMenu.requestFocus();
                    }
//                    try {
//                        Robot r = new Robot();
//                        r.keyPress(java.awt.event.KeyEvent.VK_UP);
//                        r.keyRelease(java.awt.event.KeyEvent.VK_UP);
//                    } catch (AWTException e) {
//                    }
                }

            }
        });

        editingWindow.caretPositionProperty().addListener(new ChangeListener<Number>() {
            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number t1) {
                int pos = editingWindow.getCaretPosition();
                int n = 0;
                int r = 0;
                String[] rows = editingWindow.getText().split("\n");
                for (int i = 0; i < rows.length; i++){
                    if(n + rows[i].length() > pos){
                        r = i+1;
                        break;
                    }
                    else{
                        n += rows[i].length() + 1;
                    }
                }
                if(pos-n == -1) currentLine = r-1;
                else currentLine = r;
                if (menuBar.cislovanie.isSelected()){
                    int l = Integer.toString(r).length();
                    if((pos-n) <= 12-l && (pos-n)!= -1){
                        editingWindow.positionCaret(editingWindow.getCaretPosition() + 12 - l - (pos-n));
                    }
                }
                else{
//                    if((pos-n) <= 12 && (pos-n)!= -1){
//                        editingWindow.positionCaret(editingWindow.getCaretPosition() + 12 - (pos-n));
//                    }
                }
            }
        });

        scene = new Scene(layout, 800, 600);

        scene.setOnKeyPressed(new EventHandler<KeyEvent>() {
            @Override
            public void handle(KeyEvent keyEvent) {
                if(keyEvent.getCode() == KeyCode.F6){
//                    int actual = 0;
//                    ArrayList<Node> children = new ArrayList<>(layout.getChildren());
//                    for (int i = 0; i < children.size() - 1; i++)
//                    {
//                        if (children.get(i).isFocused())
//                        {
//                            actual = i;
//                        }
//                    }
//                    if (actual == children.size()-2){
//                        children.get(0).requestFocus();
//                    }
//                    else{
//                        children.get(actual+1).requestFocus();
//                    }
                    if(editingWindow.isFocused()){
                        output.requestFocus();
                    }
                    else if(output.isFocused()){
                        menuBar.requestFocus();
                    }
                    else if(menuBar.isFocused()){
                        editingWindow.requestFocus();
                    }
                }
                if(keyEvent.isControlDown() && keyEvent.getCode() == KeyCode.N){
                    menuBar.novy.fire();
                }
                if(keyEvent.getCode() == KeyCode.F4 && keyEvent.getCode() == KeyCode.ALT){
                    menuBar.ukoncit.fire();
                }
                if(keyEvent.getCode() == KeyCode.F5){
                    menuBar.spustit.fire();
                }
                if(keyEvent.isControlDown() && keyEvent.getCode() == KeyCode.S){
                    menuBar.ulozit.fire();
                }
                if(keyEvent.isControlDown() && keyEvent.getCode() == KeyCode.O){
                    menuBar.nacitat.fire();
                }
            }
        });


        stage.setMaximized(true);
        stage.setScene(scene);
        stage.show();
    }


    @Override
    public void handle(ActionEvent actionEvent) {
        if (actionEvent.getSource()==btnSayText) {
            output.setText(text);
            output.requestFocus();
        }
        else if (actionEvent.getSource()==btnPlaySound){
            try {
                playSound("sounds\\dog.mp3");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    static void playSound(String file){
        String musicFile = file;
        Media media = new Media(new File(musicFile).toURI().toString());
        mediaPlayer = new MediaPlayer(media);
        mediaPlayer.play();
    }


    static void saveFile(File file) {
        try {
            boolean cislovanie = false;
            if (menuBar.cislovanie.isSelected()){
                cislovanie = true;
                turnOffNumbering();
            }

            FileWriter fileWriter;
            fileWriter = new FileWriter(file);
            fileWriter.write(editingWindow.getText());
            fileWriter.close();
            saved = true;
            changed = false;

            if(cislovanie){
                turnOnNumbering();
            }
        } catch (IOException ex) {
            System.out.println("Nepodarilo sa ulozit");
        }
    }

    static void loadFile(File file) {
        try {
            editingWindow.setText("");
            Scanner s = new Scanner(file).useDelimiter("\n");
            while (s.hasNext()) {
                if (s.hasNextInt()) {
                    editingWindow.appendText(s.nextInt() + "\n");
                } else {
                    editingWindow.appendText(s.next() + "\n");
                }
            }
            saved = true;
            changed = false;

            if(menuBar.cislovanie.isSelected()){
                turnOnNumbering();
            }
        } catch (FileNotFoundException ex) {
            System.out.println("Nepodarilo sa nacitat");
        }
    }

    static void clearEditingWindow(){
        editingWindow.setText("");
        if (menuBar.cislovanie.isSelected()){
            editingWindow.appendText("1          ");
        }
    }

    static void turnOnNumbering(){
        String oldText = editingWindow.getText();
        String[] rows = oldText.split("\n");
        int n = 1;
        editingWindow.setText("");
        for (int i = 0; i < rows.length; i++){
            int l = Integer.toString(n).length()*2;
            editingWindow.appendText(Integer.toString(n));
            for (int j = 1; j <= 12-l; j++){
                editingWindow.appendText(" ");
            }
//            editingWindow.appendText(rows[i].substring(12));
            editingWindow.appendText(rows[i]);
            if(i < rows.length-1){
                editingWindow.appendText("\n");
            }
            n++;
        }
        editingWindow.positionCaret(editingWindow.getCaretPosition());
    }

    static void turnOffNumbering(){
        String oldText = editingWindow.getText();
        String[] rows = oldText.split("\n");
        editingWindow.setText("");
        int n = 1;
        for (int i = 0; i < rows.length; i++){
            int l = Integer.toString(n).length();
//            for (int j = 1; j <= 12; j++){
//                editingWindow.appendText(" ");
//            }
            editingWindow.appendText(rows[i].substring(12-l) );
            if(i < rows.length-1){
                editingWindow.appendText("\n");
            }
            n++;
        }
        editingWindow.positionCaret(editingWindow.getCaretPosition());
        
    }

    static String getActualWord(){
        int pos = editingWindow.getCaretPosition();
        String text = editingWindow.getText();
        StringBuilder word = new StringBuilder();
        if(pos < text.length()-1 && (text.charAt(pos+1) != ' ' || text.charAt(pos+1) != '\n')) return "";
        while(true){
            if(pos == -1 || pos > text.length()-1 || text.charAt(pos) == ' ' || text.charAt(pos) == '\n') break;
            word.insert(0, text.charAt(pos));
            pos -= 1;
        }
        return word.toString();
    }

    void fillContextMenu(List<String> items, EditingWindowContextMenu contextMenu){
        for (String item : items) {
            if(item == "povedz") contextMenu.getItems().add(contextMenu.povedz);
            else if (item == "zahraj") contextMenu.getItems().add(contextMenu.zahraj);
            else if (item == "ticho") contextMenu.getItems().add(contextMenu.ticho);
            else if (item == "opakuj") contextMenu.getItems().add(contextMenu.opakuj);
            else if (item == "kym") contextMenu.getItems().add(contextMenu.kym);
            else if (item == "krat") contextMenu.getItems().add(contextMenu.krat);
            else if (item == "koniec") contextMenu.getItems().add(contextMenu.koniec);
            else if (item == "rob") contextMenu.getItems().add(contextMenu.rob);
            else if (item == "otazka") contextMenu.getItems().add(contextMenu.otazka);
            else if (item == "ak") contextMenu.getItems().add(contextMenu.ak);
            else if (item == "inak") contextMenu.getItems().add(contextMenu.inak);
            else if (item == "urob") contextMenu.getItems().add(contextMenu.urob);
            else if (item == "nahodne") contextMenu.getItems().add(contextMenu.nahodne);
            else if (item == "cislo") contextMenu.getItems().add(contextMenu.cislo);
            else if (item == "zadajCislo") contextMenu.getItems().add(contextMenu.zadajCislo);
            else if (item == "pripocitaj") contextMenu.getItems().add(contextMenu.pripocitaj);
            else if (item == "text") contextMenu.getItems().add(contextMenu.text);
            else if (item == "zadajText") contextMenu.getItems().add(contextMenu.zadajText);
            else if (item == "zvuk") contextMenu.getItems().add(contextMenu.zvuk);
            else if (item == "zadajZvuk") contextMenu.getItems().add(contextMenu.zadajZvuk);
            else if (item == "postupnost") contextMenu.getItems().add(contextMenu.postupnost);
            else if (item == "nulty") contextMenu.getItems().add(contextMenu.nulty);
            else if (item == "posledny") contextMenu.getItems().add(contextMenu.posledny);
            else if (item == "nasledujuci") contextMenu.getItems().add(contextMenu.nasledujuci);
            else if (item == "predchadzajuci") contextMenu.getItems().add(contextMenu.predchadzajuci);
            else if (item == "prvok") contextMenu.getItems().add(contextMenu.prvok);
            else if (item == "dlzka") contextMenu.getItems().add(contextMenu.dlzka);
        }
    }

    public static void run() throws Exception {
        lexicalAnalyzer.initialize(editingWindow.getText());
//        lexicalAnalyzer.interpreter();
        outputSequence = new Output();
        lexicalAnalyzer.makeSyntacticTree().execute();
        outputSequence.play();

    }

    static void povedz(String s){
        text = s;
        btnSayText.fire();
    }

    static void spustiDvaKratPovedz(){
        povedz("mama");
        int dlzka = text.length();
        int cas = text.length()*130+500;
        for (int i=0; i < dlzka; i+=10){
            cas -= 500;
        }
        PauseTransition pause1 = new PauseTransition(Duration.millis(cas));
        pause1.setOnFinished(e ->{
            editingWindow.requestFocus();
        });
        PauseTransition pause2 = new PauseTransition(Duration.millis(cas+100));
        pause2.setOnFinished(e ->{
            povedz("ahoj");
        });
        pause1.play();
        pause2.play();
    }

    void loadSounds(){
        soundsTime.put("pes", 1056);
    }

}
