import java.util.HashMap;

public class LexicalAnalyzer {
    enum Type {
        NOTHING,
        NUMBER,
        WORD,
        SYMBOL
    }

    static String input;
    static int index;
    static char look;
    static String token;
    static Type kind;
    static int position;
    static HashMap<String, Integer> numVars;

    public LexicalAnalyzer(){
        input = "";
        index = 0;
        look = (char)0;
        token = "";
        kind = null;
        position = index - 1;
        numVars = new HashMap<>();
    }

    static public void next(){
        if(index >= input.length()){
            look = (char)0;
        }
        else{
            look = input.charAt(index);
            index++;
        }
    }

    static public void scan(){
        while(look == ' ' || look == '\n' || look == '\t') next();
        token = "";
        position = index - 1;
        if(Character.isDigit(look)){
            while(Character.isDigit(look)){
                token += look;
                next();
            }
            kind = Type.NUMBER;
        }
        else if(Character.isAlphabetic(look)){
            while(Character.isAlphabetic(look)){
                token += look;
                next();
            }
            kind = Type.WORD;
        }
        else if (look != (char) 0){
            token = Character.toString(look);
            next();
            kind = Type.SYMBOL;
            if(look == '='){
                token += look;
                next();
            }
        }
        else{
            kind = Type.NOTHING;
        }
    }

    public void scanString(){
        token = "";
        position = index - 1;
        if(Character.isDigit(look) || Character.isAlphabetic(look) || look != (char) 0){
            while((Character.isDigit(look) || Character.isAlphabetic(look) || look != (char) 0) && look != '\"'){
                token += look;
                next();
            }
        }
        else kind = Type.NOTHING;
    }

    public void interpreter() throws Exception {
        while(kind == Type.WORD || kind == Type.NUMBER || kind == Type.SYMBOL){
            if(token.equals("povedz")){
                scan();
                if (token.equals("\"")){
                    scan();
                    System.out.println(token);
                    scan();
                    if (token.equals("\"")) scan();
                    else throw new Exception("Nespravny zapis programovej konstrukcie.");
                }
                else throw new Exception("Nespravny zapis programovej konstrukcie.");
            }
            else if(token.equals("zahraj")){
                scan();
                System.out.println(token);
                scan();
            }
            else if(token.equals("opakuj")){
                scan();
                int count = Integer.parseInt(token);
                scan();
                if(token.equals("krat")){
                    scan();
                    int start = position;
                    while(count > 0){
                        index = start;
                        next();
                        scan();
                        interpreter();
                        count--;
                    }
                }
                else throw new Exception("Nespravny zapis programovej konstrukcie, chyba prikaz krat");
            }
            else if(token.equals("koniec")){
                scan();
                break;
            }
            else throw new Exception("Prikaz" + token + "neexistuje");
        }
    }

    public void initialize(String text){
        input = text;
        index = 0;
        next();
        scan();
    }

    public Block makeSyntacticTree() throws Exception {
        Block result = new Block();
        while(kind == Type.WORD){
            if(token.equals("zahraj")){
                scan();
                result.add(new Zahraj(new StrConst(token)));
                scan();
            }
            else if(token.equals("povedz")){
                scan();
                if(!token.equals("\"")) throw new Exception("Nespravny zapis programovej konstrukcie, chybaju uvodzovky");
                scanString();     // preskocime uvodzovky
                result.add(new Povedz(new StrConst(token)));
                scan();     // preskocime uvodzovky
                if(!token.equals("\"")) throw new Exception("Nespravny zapis programovej konstrukcie, chybaju uvodzovky");
                scan();
            }
            else if(token.equals("ticho")){
                scan();
                if(kind != Type.NUMBER) throw new Exception("Nespravny zapis programovej konstrukcie, treba zadat dlzku ticha");
                result.add(new Ticho(new NumConst(Integer.parseInt(token))));
                scan();
            }
            else if(token.equals("opakuj")){
                scan();
                if(kind == Type.NUMBER){
                    int n = Integer.parseInt(token); // zapametame si pocet opakovani
                    scan();                          // dalsia lexema za poctom opakovani
                    if(!token.equals("krat"))throw new Exception("Nespravny zapis programovej konstrukcie, chyba krat");
                    scan();                          // preskocime krat
                    result.add(new Repeat(new NumConst(n), makeSyntacticTree())); // skonstruujeme vrchol pre cyklus
                    if(!token.equals("koniec"))throw new Exception("Nespravny zapis programovej konstrukcie, chyba koniec cyklu");
                    scan();
                }
                else{
                    String name = token;
                    scan();
                    if(!token.equals("krat"))throw new Exception("Nespravny zapis programovej konstrukcie, chyba krat");
                    scan();
                    if(!numVars.containsKey(name)) throw new Exception("nedefinovana premenna");
                    result.add(new Repeat(new Variable(name), makeSyntacticTree())); // skonstruujeme vrchol pre cyklus
                    if(!token.equals("koniec"))throw new Exception("Nespravny zapis programovej konstrukcie, chyba koniec cyklu");
                    scan();
                }

            }
            else if(token.equals("kym")){
                scan();
                BinaryOperation test = compare();
                if(!token.equals("rob"))throw new Exception("Nespravny zapis programovej konstrukcie, chyba rob");
                scan();
                result.add(new While(test, makeSyntacticTree()));
                if(!token.equals("koniec"))throw new Exception("Nespravny zapis programovej konstrukcie, chyba koniec cyklu");
                scan();
            }
            else if(token.equals("cislo")){
                scan();
                if(kind != Type.WORD) throw new Exception("Nespravny zapis programovej konstrukcie, nazov pemennej musi byt slovo");
                String name = token;
                scan();
                check(Type.SYMBOL, "=");
                scan();
                int vysledok = addsub().evaluate();
                numVars.put(name, vysledok);
                System.out.println(numVars);
            }
            else if(token.equals("koniec")){
                break;
            }
            else{
                String name = token;
                scan();
                check(Type.SYMBOL, "=");
                scan();
                if(!numVars.containsKey(name)) throw new Exception("premenna nie je definovana");
                result.add(new Assign(new Variable(name), addsub()));
            }
        }
        return result;
    }

    static public void check(Type expectedKind, String expectedToken){
        if(kind != expectedKind){
            try {
                throw new Exception("Ocakaval som" + expectedKind);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if(expectedToken != null && !token.equals(expectedToken)){
            try {
                System.out.println(token);
                throw new Exception("Ocakaval som" + expectedToken);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static public Syntax addsub() throws Exception {
        Syntax result = muldiv();
        while(true){
            if(token.equals("+")){
                scan();
                result = new Add(result, muldiv());
            }
            else if(token.equals("-")){
                scan();
                result = new Sub(result, muldiv());
            }
            else return result;
        }
    }

   static public Syntax muldiv() throws Exception {
        Syntax result = operand();
        while(true){
            if(token.equals("*")){
                scan();
                result = new Mul(result, muldiv());
            }
            else if(token.equals("/")){
                scan();
                result = new Div(result, muldiv());
            }
            else return result;
        }
    }

    static public Syntax operand() throws Exception {
        Syntax result;
        if(kind == Type.WORD){
            if(!numVars.containsKey(token)) throw new Exception("Neznama premenna");
//            result = new Variable(token);
            result = new Variable(token);
        }
        else{
            check(Type.NUMBER, null);
            result = new NumConst(Integer.parseInt(token));
        }
        scan();
        return result;
    }

    static public BinaryOperation compare() throws Exception {
        Syntax result = addsub();
        if(token.equals("<")){
            scan();
            return new LogicalLowerThan(result, addsub());
        }
        else if(token.equals(">")){
            scan();
            return new LogicalGreaterThan(result, addsub());
        }
        else if(token.equals(">=")){
            scan();
            return new LogicalGreaterEqualThan(result, addsub());
        }
        else if(token.equals(">=")){
            scan();
            return new LogicalLowerEqualThan(result, addsub());
        }
        else if(token.equals("==")){
            scan();
            return new LogicalEqual(result, addsub());
        }
        else if(token.equals("!=")){
            scan();
            return new LogicalDifferent(result, addsub());
        }
        return (BinaryOperation) result;
    }
}
