package com.example.geoboard.ui.main

import android.content.Context
import android.graphics.Canvas
import android.graphics.Paint
import androidx.core.graphics.drawable.toDrawable
import android.graphics.Color
import android.util.Log

class Gum(val color: Int, val points: MutableList<Pair<Float,Float>> = mutableListOf<Pair<Float,Float>>()) {

    fun draw(canvas: Canvas) {
        val mPaint = Paint()
        mPaint.color = color
        mPaint.strokeWidth = canvas.width/90f
        var prevPoint: Pair<Float,Float>? = null
        for (point in points){
            if(prevPoint != null){
                canvas.drawLine(prevPoint.first,prevPoint.second,point.first,point.second,mPaint)
            }
            prevPoint = point
        }
        if (prevPoint != null) {
            canvas.drawLine(prevPoint.first,prevPoint.second,points[0].first,points[0].second,mPaint)
        }
    }

    fun addPoint(point : Pair<Float,Float>,index:Int){

        points.add(index,point)
    }

    fun transformPoint(index:Int, x:Float,y:Float){
        points[index] = Pair(x,y)
        Log.d("ddd", "$points, $index")

    }


}