package com.example.geoboard.ui.main

import android.content.Context
import android.graphics.*
import android.util.AttributeSet
import android.view.KeyEvent
import android.view.View
import androidx.core.graphics.createBitmap
import com.example.geoboard.R

class GumPanel(val context: Context, val height: Float) {
    val b = BitmapFactory.decodeResource(context.resources, R.drawable.clear_button)
    val bi = Bitmap.createScaledBitmap(b,height.toInt(),height.toInt(),false)

    fun draw(canvas: Canvas) {
        val mPaint = Paint()
        val top = canvas.height-height
        mPaint.color = Color.LTGRAY
        canvas.drawRect(0F,top, canvas.width.toFloat(), canvas.height.toFloat(),mPaint)
        mPaint.color = Color.RED
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.strokeWidth = canvas.width/90f
        canvas.drawOval(canvas.width/18f,top+10,2f*(canvas.width/18), canvas.height.toFloat()-10,mPaint)
        mPaint.color = Color.BLUE
        canvas.drawOval(canvas.width/18f*3,top+10,4f*(canvas.width/18), canvas.height.toFloat()-10,mPaint)
        mPaint.color = Color.MAGENTA
        canvas.drawOval(canvas.width/18f*5,top+10,6f*(canvas.width/18), canvas.height.toFloat()-10,mPaint)
        mPaint.color = Color.YELLOW
        canvas.drawOval(canvas.width/18f*7,top+10,8f*(canvas.width/18), canvas.height.toFloat()-10,mPaint)
        mPaint.color = Color.GREEN
        canvas.drawOval(canvas.width/18f*9,top+10,10f*(canvas.width/18), canvas.height.toFloat()-10,mPaint)
        canvas.drawBitmap(bi,canvas.width - height,top, mPaint)
    }
}