package com.example.geoboard.ui.main

import android.content.Context
import android.graphics.Canvas
import android.graphics.Color
import android.util.AttributeSet
import android.util.Log
import android.view.DragEvent
import android.view.DragEvent.ACTION_DRAG_STARTED
import android.view.KeyEvent
import android.view.MotionEvent
import android.view.MotionEvent.*
import android.view.View
import android.widget.Button
import androidx.constraintlayout.widget.ConstraintLayout
import com.example.geoboard.R
import kotlin.math.abs

class PlayGround(context: Context, attrs: AttributeSet): View(context,attrs),
    View.OnKeyListener{

    //n*n geoboard
    val n = 5

    var gridPoints = mutableListOf<GridPoint>()

    var gums = mutableListOf<Gum>()

    lateinit var gumPanel : GumPanel

    var  draggedGum : UnplacedGum? = null

    var modifiedGum : Gum? = null

    var indexOfNewPoint: Int? = null




    init{
        setBackgroundResource(R.drawable.geoboard_background)


    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
        val width = measuredWidth
        val gumPanelHeight = (width/(n+1)) +30
        setMeasuredDimension(width,width + gumPanelHeight)
        gumPanel = GumPanel(context,gumPanelHeight.toFloat())

        val size = width/60
        if(gridPoints.isEmpty()){
            for (i in 1..n) {
                for (j in 1..n) {
                    gridPoints.add(GridPoint(
                        ((width/(n+1))*i).toFloat(), ((width/(n+1))*j).toFloat(),size))
                }
            }
        }

    }

    override fun onKey(p0: View?, p1: Int, p2: KeyEvent?): Boolean {
        when (p1) {
//            KeyEvent.KEYCODE_DPAD_LEFT -> block.update(-100,0)
//            KeyEvent.KEYCODE_DPAD_RIGHT -> block.update(100,0)
            else -> return false
        }
        invalidate()
        return true
    }


    fun distance(p1:Pair<Float,Float>,p2:Pair<Float,Float>): Float{
        return  Math.sqrt(
            Math.pow((p1.first.toDouble() - p2.first.toDouble()), 2.0)
            +
            Math.pow((p1.second.toDouble() - p2.second.toDouble()), 2.0)
        ).toFloat()
    }

    fun pointInLine(p: Pair<Float,Float>, linePoint1: Pair<Float,Float>, linePoint2: Pair<Float,Float>): Boolean{
        return distance(linePoint1, p) + distance(linePoint2, p) -10 < distance(linePoint1, linePoint2);
    }

    fun pointInGum(p: Pair<Float,Float>, gumPoints: MutableList<Pair<Float,Float>>): Pair<Pair<Float,Float>, Pair<Float,Float>>?{
        var prevPoint: Pair<Float,Float>? = null
        for (point in gumPoints){
            if(prevPoint != null){
                val line1 = prevPoint
                val line2 = point
                if(pointInLine(p,line1,line2)){
                    return Pair(line1,line2)
                }
            }
            prevPoint = point
        }
        if (prevPoint != null) {
            val line1 = prevPoint
            val line2 = gumPoints[0]
            if(pointInLine(p,line1,line2)){
                return Pair(line1,line2)
            }
        }
        return null
    }

    fun findClossestGridPoint(x: Float,y: Float) : GridPoint?{
        return gridPoints.minByOrNull { it -> distance(Pair(it.x, it.y), Pair(x, y)) }
    }

    fun clickedOnGridPoint(x:Float,y:Float) : GridPoint?{
        return gridPoints.find { it-> distance(Pair(it.x,it.y),Pair(x,y)) < 15 }
    }

    fun findIndexOfLastGumPointOnGridPoint(x: Float,y: Float, g:Gum): Int?{
        return g.points.indexOfLast { it.first == x && it.second == y }
    }





    override fun onTouchEvent(event: MotionEvent?): Boolean {

        if (event != null) {
            if(event.action == ACTION_DOWN){
                Log.d("aaa","down")
                //cklicked on new red gum
                if(event.x > this.width/18f && event.x < 2f*(this.width/18) && event.y > this.width && event.y < this.height) {
                    draggedGum = UnplacedGum(event.x, event.y, this.height - this.width -0F , this.width/18f, Color.RED)
                    return true
                }
                //cklicked on new blue gum
                if(event.x > this.width/18f*3 && event.x < 4f*(this.width/18) && event.y > this.width && event.y < this.height) {
                    draggedGum = UnplacedGum(event.x, event.y, this.height - this.width -0F , this.width/18f, Color.BLUE)
                    return true
                }

                //cklicked on new magenta gum
                if(event.x > this.width/18f*5 && event.x < 6f*(this.width/18) && event.y > this.width && event.y < this.height) {
                    draggedGum = UnplacedGum(event.x, event.y, this.height - this.width -0F , this.width/18f, Color.MAGENTA)
                    return true
                }
                //cklicked on new yellow gum
                if(event.x > this.width/18f*7 && event.x < 8f*(this.width/18) && event.y > this.width && event.y < this.height) {
                    draggedGum = UnplacedGum(event.x, event.y, this.height - this.width -0F , this.width/18f, Color.YELLOW)
                    return true
                }
                //cklicked on new green gum
                if(event.x > this.width/18f*9 && event.x < 10f*(this.width/18) && event.y > this.width && event.y < this.height) {
                    draggedGum = UnplacedGum(event.x, event.y, this.height - this.width -0F , this.width/18f, Color.GREEN)
                    return true
                }
                //clicked on clear
                if(event.x > width - (height - width) && event.x < width && event.y > this.width && event.y < this.height) {
                    gums = mutableListOf<Gum>()
                    return true
                }
                //clicked on geoboard
                else{
                    val clickedPoint = Pair(event.x,event.y)
                    //clicked on placed gum
                    for(g in gums){
                        val isInGum = pointInGum(clickedPoint, g.points)
                        if(isInGum != null){
                            Log.d("ccc", "$isInGum")
                            val COGP = clickedOnGridPoint(event.x,event.y)
                            modifiedGum = g
                            //clicked on grid point, move clicked point
                            if (COGP != null){
                                indexOfNewPoint = findIndexOfLastGumPointOnGridPoint(COGP.x,COGP.y,g)
                                if(indexOfNewPoint == -1){
                                    modifiedGum = null
                                }
                                return true
                            }
                            //clicked on gum, create new point
                            else{
                                indexOfNewPoint = modifiedGum!!.points.indexOf(isInGum.second)
                                modifiedGum!!.addPoint(Pair(event.x,event.y), indexOfNewPoint!!)
                                return true
                            }

                        }
                    }

                }

            }

            if(event.action == ACTION_UP){
                Log.d("aaa","up")
                if(draggedGum!= null){
                    val points = findGridPointsForGum(event.x,event.y)
                    if(points != null){
                        val new_gum = Gum(draggedGum!!.color,points)
                        gums.add(new_gum)
                        invalidate()
                    }
                    Log.d("bbb",points.toString())
                    draggedGum = null
                }
                if(modifiedGum!= null){
                    val clossestGP = findClossestGridPoint(event.x,event.y)
                    if(clossestGP != null){
                        modifiedGum?.transformPoint(indexOfNewPoint!!,clossestGP.x,clossestGP.y)
                    }
                    invalidate()
                    modifiedGum = null
                }

            }

            if(event.action == ACTION_MOVE){
                Log.d("aaa","dragging")
                draggedGum?.transform(event.x-draggedGum!!.width/2,event.y-draggedGum!!.height/2)
                modifiedGum?.transformPoint(indexOfNewPoint!!,event.x,event.y)
                invalidate()
            }



        }

        return super.onTouchEvent(event)
    }

    fun findGridPointsForGum(x:Float,y:Float) : MutableList<Pair<Float,Float>>?{
        var left = 0F
        var right = 100000F
        var top = 0F
        var bott = 100000F
        for(i in gridPoints){
            if(x > i.x && left < i.x){
                left = i.x
            }
            if(x < i.x && right > i.x){
                right = i.x
            }
            if(y > i.y && top < i.y) {
                top = i.y
            }
            if(y < i.y && bott > i.y){
                bott = i.y
            }
        }
        val closer : Float
        if(x - left < right - x){
            closer = left
        }
        else{
            closer = right
        }
        if(closer == 0f || closer == 100000F || bott == 100000F || top == 0F){
            return null
        }

        return mutableListOf<Pair<Float,Float>>(Pair(closer,top),Pair(closer,bott))

    }

    override fun onDraw(canvas: Canvas) {
        super.onDraw(canvas)
        for (p in gridPoints) {
            p.draw(canvas)
        }
        for (g in gums) {
            g.draw(canvas)
        }
        gumPanel.draw(canvas)
        draggedGum?.draw(canvas)


    }


}