create function path_finder(start integer, finish integer) returns integer[]
    language sql
as
$$
WITH RECURSIVE paths(src,dst,path) AS (
    SELECT e.loca_id, e.locb_id, ARRAY[e.loca_id,e.locb_id]
    FROM connections e where  e.loca_id = start and start != finish
    UNION
    SELECT p.src, e.locb_id, p.path || ARRAY[e.locb_id]
    FROM paths p JOIN connections e ON p.dst = e.loca_id AND e.locb_id != ALL(p.path)
)
SELECT path FROM paths where dst = finish limit 1;
$$;

alter function path_finder(integer, integer) owner to "paluch12@uniba.sk";

