from tkinter import *
import tkinter
from random import randrange
import time

class Pravidla:
    def __init__(self):
        self.okno2 = tkinter.Tk()
        self.okno2.title("pravidla")
        with open("pravidla.txt") as subor:
            pravidla = subor.read()

        t = Text(self.okno2,wrap=WORD,width=50,padx="10", pady="10", font="Calibri 11", bg="lightgreen")
        t.pack()
        
        t.insert(INSERT, pravidla)

class Program:
    def __init__(self):
        self.okno1 = tkinter.Tk()
        self.okno1.title("chessos")
        self.canvas = tkinter.Canvas(width=760,height=760,bg="lightsteelblue")
        self.canvas.pack()
        self.canvas.bind('<ButtonPress>', self.klik)
        self.canvas.bind('<B1-Motion>', self.tahanie)
        self.canvas.bind('<ButtonRelease>', self.naprav)
        #self.B0 = tkinter.Button(self.okno1,text ="menu",cursor="hand2",command = self.menu,state=DISABLED,bg="lightsteelblue",width=106).place(x=5,y=5)
        
        self.w_pawn = tkinter.PhotoImage(file='w_pawn.png')
        self.w_rook = tkinter.PhotoImage(file='w_rook.png')
        self.w_knight = tkinter.PhotoImage(file='w_knight.png')
        self.w_bishop = tkinter.PhotoImage(file='w_bishop.png')
        self.w_queen = tkinter.PhotoImage(file='w_queen.png')
        self.w_king = tkinter.PhotoImage(file='w_king.png')
        self.b_pawn = tkinter.PhotoImage(file='b_pawn.png')
        self.b_rook = tkinter.PhotoImage(file='b_rook.png')
        self.b_knight = tkinter.PhotoImage(file='b_knight.png')
        self.b_bishop = tkinter.PhotoImage(file='b_bishop.png')
        self.b_queen = tkinter.PhotoImage(file='b_queen.png')
        self.b_king = tkinter.PhotoImage(file='b_king.png')

        self.title = tkinter.PhotoImage(file='title.png')
        self.board = tkinter.PhotoImage(file='board.png')
        self.background_image = tkinter.PhotoImage(file='bg1.png')
        self.red1 = tkinter.PhotoImage(file='red.png')
        self.green_small1 = tkinter.PhotoImage(file='green_small.png')
        self.green1 = tkinter.PhotoImage(file='green.png')
        self.prechod = (0,0,0)
        self.single_player = 1
        self.uvodne_menu()
        tkinter.mainloop()

    def uvodne_menu(self):
        self.canvas.unbind('<ButtonPress>')
        self.nadpis = self.canvas.create_image(380,380,image=self.background_image)
        self.canvas.create_image(380,180,image=self.title)
        self.ramec = self.canvas.create_rectangle(270,250,490,380,fill="lightgreen",stipple="",outline="green")
        self.B2 = tkinter.Button(self.okno1,text ="nová hra",cursor="hand2",font="Arial 11",relief="groove",command = self.nova_hra)
        self.B3 = tkinter.Button(self.okno1,text ="pravidlá",cursor="hand2",font="Arial 11",relief="groove",command = self.pravidla)
        self.B4 = tkinter.Button(self.okno1,text ="ukončiť",cursor="hand2",font="Arial 11",relief="groove",command = self.okno1.destroy)
        
        self.B2.place(x=280,y=260,width=200,height=30)
        self.B3.place(x=280,y=300,width=200,height=30)
        self.B4.place(x=280,y=340,width=200,height=30)

    def menu(self):

        def v1():
            self.single_player = 0
            self.nova_hra()
        def v2():
            self.single_player = 1
            self.nova_hra()
        def v3():
            self.single_player = 2
            self.nova_hra()
        
        self.canvas.unbind('<ButtonPress>')
        self.modra = self.canvas.create_rectangle(0,0,760,760,fill="blue",stipple="gray50")
        self.nadpis = self.canvas.create_image(380,180,image=self.title) 
        self.ramec = self.canvas.create_rectangle(270,270,500,440,fill="lightgreen",stipple="",outline="")
        self.B0 = tkinter.Button(self.okno1,text ="menu",cursor="hand2",command = self.menu,state=DISABLED,bg="lightsteelblue",width=106).place(x=5,y=5)
        self.B1 = tkinter.Button(self.okno1,text ="pokračovať",cursor="hand2",font="Arial 11",relief="groove",anchor="w",command = self.zrus_menu)
        self.B2 = tkinter.Button(self.okno1,text ="nová hra"  ,cursor="hand2",font="Arial 11",relief="groove",anchor="w",command = self.nova_hra)
        self.B3 = tkinter.Button(self.okno1,text ="pravidla"  ,cursor="hand2",font="Arial 11",relief="groove",anchor="w",command = self.pravidla)
        self.B4 = tkinter.Button(self.okno1,text ="ukončiť"   ,cursor="hand2",font="Arial 11",relief="groove",command = self.okno1.destroy)
        self.B5 = tkinter.Button(self.okno1,text ="2 hrači"   ,cursor="hand2",font="Arial 11",relief="groove",anchor="w",command = v1)
        self.B6 = tkinter.Button(self.okno1,text ="ai lvl1"   ,cursor="hand2",font="Arial 11",relief="groove",anchor="w",command = v2)
        self.B7 = tkinter.Button(self.okno1,text ="ai lvl2"   ,cursor="hand2",font="Arial 11",relief="groove",anchor="w",command = v3)
        
        self.B1.place(x=280,y=280,width=100,height=30)
        self.B2.place(x=280,y=320,width=100,height=30)
        self.B3.place(x=280,y=360,width=100,height=30)
        self.B4.place(x=280,y=400,width=210,height=30)
        self.B5.place(x=390,y=280,width=100,height=30)
        self.B6.place(x=390,y=320,width=100,height=30)
        self.B7.place(x=390,y=360,width=100,height=30)

        self.koniec_hry(self.vysledok_text)

    def zrus_buttony(self):
        try:
            self.B1.destroy()
        except:
            pass
        try:
            self.B2.destroy()
        except:
            pass
        try:
            self.B3.destroy()
        except:
            pass
        try:
            self.B4.destroy()
        except:
            pass
        try:
            self.B5.destroy()
        except:
            pass
        try:
            self.B6.destroy()
        except:
            pass
        try:
            self.B7.destroy()
        except:
            pass

    def zrus_menu(self):
        self.canvas.bind('<ButtonPress>', self.klik)
        self.B0 = tkinter.Button(self.okno1,text ="menu",cursor="hand2",command = self.menu,state=NORMAL,bg="lightsteelblue",width=106).place(x=5,y=5)
        self.zrus_buttony()
        self.canvas.delete(self.modra)
        self.canvas.delete(self.nadpis)
        self.canvas.delete(self.ramec)
        try:
            self.canvas.delete(self.vysledok)
        except:
            pass

    def pravidla(self):
        #Pravidla.delete(self.okno2)
        self.okno2 = Pravidla()
        

    def koniec_hry(self,vysledok):
        if vysledok != "" and vysledok !="Pat":
            farba = {"Biely":"white","Čierny":"black"}[vysledok.split()[0]]
        else:
            farba = "white"
        self.vysledok = self.canvas.create_text(380,555,text = vysledok,font="Verdana 25  bold",fill=farba)
        self.vysledok_text = vysledok
             
    def nova_hra(self):
        self.canvas.delete('all')
        self.canvas.bind('<ButtonPress>', self.klik)
        self.B0 = tkinter.Button(self.okno1,text ="menu",cursor="hand2",command = self.menu,state=NORMAL,bg="lightsteelblue",width=106).place(x=5,y=5)
        self.zrus_buttony()
        self.vysledok_text = ""
        
        self.sachovnica()
        self.kruzky()
        self.hrac = 0
        self.tah = 0
        self.pole = []
        for i in range(8):
            pom = []
            for j in range(8):
                pom.append(0.0)
            self.pole.append(pom)

        self.pole2 = [[-5,-3,-3.5,-9,-200,-3.5,-3,-5],
                      [-1,-1,-1,-1,-1,-1,-1,-1 ],
                      [ 0, 0, 0, 0, 0, 0, 0, 0 ],
                      [ 0, 0, 0, 0, 0, 0, 0, 0 ],
                      [ 0, 0, 0, 0, 0, 0, 0, 0 ],
                      [ 0, 0, 0, 0, 0, 0, 0, 0 ],
                      [ 1, 1, 1, 1, 1, 1, 1, 1 ],
                      [ 5, 3, 3.5, 9,200,3.5, 3, 5]]
            
        for i in range(8):
            self.pole[1][i] = self.canvas.create_image(135+70*i,205,image=self.b_pawn)
        for i in range(8):
            self.pole[6][i] = self.canvas.create_image(135+70*i,555,image=self.w_pawn)
        for x,i in enumerate((self.b_rook,self.b_knight,self.b_bishop,self.b_queen,self.b_king,self.b_bishop,self.b_knight,self.b_rook)):
            self.pole[0][x] = self.canvas.create_image(135+70*x,135,image=i)
        for x,i in enumerate((self.w_rook,self.w_knight,self.w_bishop,self.w_queen,self.w_king,self.w_bishop,self.w_knight,self.w_rook)):
            self.pole[7][x] = self.canvas.create_image(135+70*x,625,image=i)
            
    def vypis_pola(self):
        for i in range(8):
            for j in range(8):
                print(self.pole2[i][j],end = " ")
            print()       

    def sachovnica2(self):
         for i in range(8):
            for j in range(8):
                if (i+j)%2:
                    farba = "saddlebrown"
                else:
                    farba = "white"
                self.canvas.create_rectangle(100+70*i,100+70*j,170+70*i,170+70*j,fill=farba,stipple="")

    def sachovnica(self):
        self.canvas.create_image(380,380,image=self.background_image) 
        self.canvas.create_image(380,380,image=self.board)

    def kruzky(self):
        self.zelene_kruzky = []
        self.red= self.canvas.create_image(415,625,image=self.red1)
        self.canvas.itemconfig(self.red,state="hidden")
        for i in range(8):
            pom = []
            for j in range(8):
                pom.append([self.canvas.create_image(135+70*j,135+70*i,image=self.green_small1),
                            self.canvas.create_image(135+70*j,135+70*i,image=self.green1)])
                self.canvas.itemconfig(pom[-1][0],state="hidden")
                self.canvas.itemconfig(pom[-1][1],state="hidden")
            self.zelene_kruzky.append(pom)
   
    def klik(self,event):
        if (100 < event.x < 660) and (100<event.y < 660):
            a = (event.x - 100) // 70
            b = (event.y - 100) // 70
            if self.pole[b][a] != 0:
                self.prechod = 1,a,b
                if self.hrac and self.pole2[b][a] < 0:
                    self.zmaz_moznosti()
                    self.kresli_moznosti(b,a)
                elif not self.hrac and self.pole2[b][a] > 0:
                    self.zmaz_moznosti()
                    self.kresli_moznosti(b,a)
                else:
                    self.zmaz_moznosti()
            else:
                self.zmaz_moznosti()
                

    def tahanie(self,event):
        if self.prechod[0]:
            a = self.prechod[1]
            b = self.prechod[2]
            self.canvas.coords(self.pole[b][a],event.x,event.y)

    def naprav(self,event):
        if self.prechod[0]:
            a = (event.x - 100) // 70
            b = (event.y - 100) // 70
            c = self.prechod[1]
            d = self.prechod[2]
            
            if(100 < event.x < 660) and (100<event.y < 660) and  self.kontrola(d,c,b,a):                    
                self.zmaz_moznosti()
                pamet = self.potiahni(d,c,b,a)
                self.hrac = (self.hrac + 1) % 2
                self.tah += 1
                if type(self.pole[b][a]) == int:
                    self.canvas.delete(self.pole[b][a])
                self.pole[b][a], self.pole[d][c] = self.pole[d][c] ,0.0

                self.oprav_damu_pesca((d,c,b,a))
                
            self.prechod = 0,0,0
            for i in range(8):
                for j in range(8):
                    if isinstance(self.pole[i][j],int):
                        self.canvas.coords(self.pole[i][j],135+70*j,135+70*i)


            if self.single_player == 1:
                self.ai3c()
            elif self.single_player == 2:
                self.ai4()
            else:
                for i in -200,200:
                    self.kontrola_matu(i)

    def volnalajna(self,a,b,c,d):
        if a == c:
            if b < d:
                b,d = d,b
            for i in range(d+1,b):
                if self.pole2[i][a] != 0:
                    return 0
            return 1
        elif b == d:
            if a < c:
                a,c = c,a
            for i in range(c+1,a):
                if self.pole2[b][i] != 0:
                    return 0
            return 1
        return 0

    def volnadiagonala(self,a,b,c,d):
        if abs(a-c) == abs(b-d):
            if a < c:
                a,c = c,a
                b,d = d,b
            if b < d:
                znam = -1
            else:
                znam = 1
            for i in range(c+1,a):
                if self.pole2[znam*(i-c)+d][i] != 0:
                    return 0
            return 1
        return 0

    def kontrola(self,y,x,y1,x1):
        if not self.hrac:
            if (y,x,y1,x1) in self.legalne_tahy(200):
                return 1

        elif self.hrac:
            if (y,x,y1,x1) in self.legalne_tahy(-200):
                return 1

        return 0
                    
    def pozicia_figurky(self,meno):
        for i in range(8):
            for j in range(8):
                if meno == self.pole2[i][j]:
                    return i,j

    def sach(self,figurka):
        y,x = self.pozicia_figurky(figurka)
        if figurka > 0:
            for i in range(8):
                for j in range(8):
                    if self.pole2[i][j] < 0:
                        if (y,x) in self.kam_mozem_ist(self.pole2[i][j],i,j):
                            return 1
        else:
            for i in range(8):
                for j in range(8):
                    if self.pole2[i][j] > 0:
                        if (y,x) in self.kam_mozem_ist(self.pole2[i][j],i,j):
                            return 1
        return 0

    def legalne_tahy(self,farba):
        vysl = set()
        if farba > 0:
            for i in range(8):
                for j in range(8):
                    if self.pole2[i][j] > 0:
                        mn = self.kam_mozem_ist2(self.pole2[i][j],i,j)
                        for k in mn:
                            pamet = self.potiahni(i,j,*k)
                            if not self.sach(200):
                                vysl.add((i,j,k[0],k[1]))
                            self.potiahni(*k,i,j,pamet)
        else:
            for i in range(8):
                for j in range(8):
                    if self.pole2[i][j] < 0:
                        mn = self.kam_mozem_ist2(self.pole2[i][j],i,j)
                        for k in mn:
                            pamet = self.potiahni(i,j,*k)
                            if not self.sach(-200):
                                vysl.add((i,j,k[0],k[1]))
                            self.potiahni(*k,i,j,pamet)
        return vysl

    def legalne_tahy2(self,farba):
        vysl = set()
        if farba > 0:
            for i in range(8):
                for j in range(8):
                    if self.pole2[i][j] > 0:
                        mn = self.kam_mozem_ist2(self.pole2[i][j],i,j)
                        for k in mn:
                            vysl.add((i,j,k[0],k[1]))
        else:
            for i in range(8):
                for j in range(8):
                    if self.pole2[i][j] < 0:
                        mn = self.kam_mozem_ist2(self.pole2[i][j],i,j)
                        for k in mn:
                            vysl.add((i,j,k[0],k[1]))
        return vysl

    def mat_pat(self,figurka):
        if len(self.legalne_tahy(figurka)) == 0:
            if self.sach(figurka):
                return 2   #mat
            else:
                return 3   #pat
        return 0

    def kam_mozem_ist(self,figurka,y,x):    #napadajuco
        if abs(figurka) == 1.0:
            return self.pesiak2(figurka,y,x)
        elif abs(figurka) == 5.0:
            return self.veza(figurka,y,x)
        elif abs(figurka) == 3.0:
            return self.konik(figurka,y,x)
        elif abs(figurka) == 3.5:
            return self.strelec(figurka,y,x)
        elif abs(figurka) == 9.0:
            return self.dama(figurka,y,x)
        elif abs(figurka) == 200.0:
            return self.kral(figurka,y,x)
        else:
            return set()

    def kam_mozem_ist2(self,figurka,y,x):    #pohybovo
        if abs(figurka) == 1.0:
            return self.pesiak(figurka,y,x)
        elif abs(figurka) == 5.0:
            return self.veza(figurka,y,x)
        elif abs(figurka) == 3.0:
            return self.konik(figurka,y,x)
        elif abs(figurka) == 3.5:
            return self.strelec(figurka,y,x)
        elif abs(figurka) == 9.0:
            return self.dama(figurka,y,x)
        elif abs(figurka) == 200.0:
            return self.kral2(figurka,y,x)
        else:
            return set()

    def pesiak(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if (self.pole2[i][j] == 0 and (y-1 == i or (y==6 and i==4 and self.pole2[5][x]==0)) and x==j) or (self.pole2[i][j] < 0 and y-1 == i and (j==x+1 or j==x-1)):
                        vysl.add((i,j))
                elif figurka < 0:
                    if (self.pole2[i][j] == 0 and (y+1 == i or (y==1 and i==3 and self.pole2[2][x]==0)) and x==j) or (self.pole2[i][j] > 0 and y+1 == i and (j==x+1 or j==x-1)):
                        vysl.add((i,j))
                    
        return vysl

    def pesiak2(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if y-1 == i and (j==x+1 or j==x-1):
                        vysl.add((i,j))
                elif figurka < 0:
                    if y+1 == i and (j==x+1 or j==x-1):
                        vysl.add((i,j))
                    
        return vysl
        
    def veza(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if self.volnalajna(j,i,x,y) and self.pole2[i][j] <= 0:
                        vysl.add((i,j))
                elif figurka < 0:
                    if self.volnalajna(j,i,x,y) and self.pole2[i][j] >= 0:
                        vysl.add((i,j))
        return vysl

    def konik(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if self.pole2[i][j] <= 0 and abs(i-y) + abs(j-x) == 3 and abs(i-y)>0 and abs(j-x)>0:
                        vysl.add((i,j))
                elif figurka < 0:
                    if self.pole2[i][j] >= 0 and abs(i-y) + abs(j-x) == 3 and abs(i-y)>0 and abs(j-x)>0:
                        vysl.add((i,j))
        return vysl
    
    def strelec(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if self.volnadiagonala(x,y,j,i) and self.pole2[i][j] <= 0:
                        vysl.add((i,j))
                elif figurka < 0:
                    if self.volnadiagonala(x,y,j,i) and self.pole2[i][j] >= 0:
                        vysl.add((i,j))                 
        return vysl
    
    def dama(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if (self.volnadiagonala(x,y,j,i) or self.volnalajna(j,i,x,y)) and self.pole2[i][j] <= 0:
                        vysl.add((i,j))
                elif figurka < 0:
                    if (self.volnadiagonala(x,y,j,i) or self.volnalajna(j,i,x,y)) and self.pole2[i][j] >= 0:
                        vysl.add((i,j))
        return vysl
               
    def kral(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if abs(i-y) < 2 and abs(j-x) < 2 and self.pole2[i][j] <= 0:
                        vysl.add((i,j))
                elif figurka < 0:
                    if abs(i-y) < 2 and abs(j-x) < 2 and self.pole2[i][j] >= 0:
                        vysl.add((i,j))
                        
        return vysl

    def kral2(self,figurka,y,x):
        vysl = set()
        for i in range(8):
            for j in range(8):
                if figurka > 0:
                    if abs(i-y) < 2 and abs(j-x) < 2 and self.pole2[i][j] <= 0:
                        vysl.add((i,j))
                elif figurka < 0:
                    if abs(i-y) < 2 and abs(j-x) < 2 and self.pole2[i][j] >= 0:
                        vysl.add((i,j))
                        
        vysl.update(self.rosada(figurka))
        return vysl

    def rosada(self,figurka):
        if 1:
            vysl = set()
            if figurka > 0:
                if self.pozicia_figurky(200)==(7,4):
                    if self.volnalajna(4,7,7,7):
                        vysl.add((7,6))
                    if self.volnalajna(4,7,0,7):
                        vysl.add((7,2))               
            else:
                if self.pozicia_figurky(-200)==(0,4):
                    if self.volnalajna(4,0,7,0):
                        vysl.add((0,6))
                    if self.volnalajna(4,0,0,0):
                        vysl.add((0,2))
            return vysl

    def ohodnot_plochu(self):
        vysl = 0
        for i in range(8):
            for j in range(8):
                a = self.pole2[i][j]
                if a > 0:
                    vysl += a + self.tabulky(abs(a))[i][j]/4  
                elif a < 0:
                    vysl += a - self.tabulky(abs(a))[7-i][7-j]/4 
        return -vysl

    def ohodnot_plochu2(self):
        vysl = 0
        for i in range(8):
            for j in range(8):
                vysl += self.pole2[i][j]

        return -vysl

    def kontrola_matu(self,figurka):
        if self.mat_pat(figurka) == 2:
            self.menu()
            t = {-200:"Biely",200:"Čierny"}[figurka] + " vyhral"
            self.koniec_hry(t)
        elif self.mat_pat(figurka) == 3:
            self.menu()
            self.koniec_hry("Pat")
            
    def oprav_damu_pesca(self,pamet):
        y,x,y1,x1 = pamet
        if (y1 == 7 or y1 == 0) and abs(self.pole2[y1][x1]) == 1:
            self.pole2[y1][x1] = [9,-9][7==y1]
            self.canvas.delete(self.pole[y1][x1])
            self.pole[y1][x1] = self.canvas.create_image(135+70*x1,135+70*y1,image = [self.b_queen,self.w_queen][y1==0])
            
        elif abs(x-x1) > 1 and abs(self.pole2[y1][x1]) == 200:
            self.nepriatel_pohyb(y,7*(x1>x),y1,3+2*(x1>x))
            self.hrac = (self.hrac + 1) % 2

        self.kresli_sach()

    def ai3b(self):         #Hlbka 3  #biely
        self.kontrola_matu(-200)
        if not self.hrac:
            max2 = -1000
            for (y,x,y1,x1) in self.legalne_tahy(200):
                o = self.potiahni(y,x,y1,x1)

                min2 = 1000
                for (y2,x2,y3,x3) in self.legalne_tahy(-200):
                    p = self.potiahni(y2,x2,y3,x3)
                    
                    max = -1000
                    for (y4,x4,y5,x5) in self.legalne_tahy2(200):
                        q = self.potiahni(y4,x4,y5,x5)
                        a = -self.ohodnot_plochu2()
                        if a > max:
                            max = a
                        self.potiahni(y5,x5,y4,x4,q)
                        #if max > min2:
                        #    break
                        
                    if max <  min2:
                        min2 = max
                    self.potiahni(y3,x3,y2,x2,p)
                    if min2 < max2:
                        break

                if min2 > max2:
                    max2 = min2
                    pamet = (y,x,y1,x1)
                self.potiahni(y1,x1,y,x,o)

            self.nepriatel_pohyb(*pamet)
            self.oprav_damu_pesca(pamet)
            self.kontrola_matu(200)

    def ai3c(self):         #Hlbka 3   #čierny
        self.kontrola_matu(-200)
        if self.hrac:
            max2 = -1000
            for (y,x,y1,x1) in self.legalne_tahy(-200):
                o = self.potiahni(y,x,y1,x1)

                min2 = 1000
                for (y2,x2,y3,x3) in self.legalne_tahy(200):
                    p = self.potiahni(y2,x2,y3,x3)
                    
                    max = -1000
                    for (y4,x4,y5,x5) in self.legalne_tahy2(-200):
                        q = self.potiahni(y4,x4,y5,x5)
                        a = self.ohodnot_plochu()
                        if a > max:
                            max = a
                        self.potiahni(y5,x5,y4,x4,q)
                        #if max > min2:
                        #    break
                        
                    if max <  min2:
                        min2 = max
                    self.potiahni(y3,x3,y2,x2,p)
                    if min2 < max2:
                        break

                if min2 > max2:
                    max2 = min2
                    pamet = (y,x,y1,x1)
                self.potiahni(y1,x1,y,x,o)

            try:
                self.nepriatel_pohyb(*pamet)
                self.oprav_damu_pesca(pamet)
            except:
                if self.mat_pat(-200) == 3:
                    print("pat")
                else:
                    print("mat")
            self.kontrola_matu(200)

    def ai4(self):         #Hlbka 4
        if self.hrac:
            max2 = -1000
            for (y,x,y1,x1) in self.legalne_tahy(-200):
                o = self.potiahni(y,x,y1,x1)

                min2 = 1000
                for (y2,x2,y3,x3) in self.legalne_tahy(200):
                    p = self.potiahni(y2,x2,y3,x3)
                    
                    max = -1000
                    for (y4,x4,y5,x5) in self.legalne_tahy2(-200):
                        q = self.potiahni(y4,x4,y5,x5)

                        min = 1000
                        for (y6,x6,y7,x7) in self.legalne_tahy2(200):
                            r = self.potiahni(y6,x6,y7,x7)
                            a = self.ohodnot_plochu2()
                            if a < min:
                                min = a
                            self.potiahni(y7,x7,y6,x6,r)
                            if min < max:
                                break
                            
                        if min > max:
                            max = min
                        self.potiahni(y5,x5,y4,x4,q)
                        #if max > min2:
                        #    break
                        
                    if max <  min2:
                        min2 = max
                    self.potiahni(y3,x3,y2,x2,p)
                    if min2 < max2:
                        break

                if min2 > max2:
                    max2 = min2
                    pamet = (y,x,y1,x1)
                self.potiahni(y1,x1,y,x,o)

            self.nepriatel_pohyb(*pamet)
            self.oprav_damu_pesca(pamet)

    def ai(self):
        self.kontrola_matu(-200)
        t = time.time()
        def maxi(oo):
            naj = -1000
            for (k,l,m,n) in self.legalne_tahy2(-200):
                tah = self.potiahni(k,l,m,n)
                pp = self.ohodnot_plochu()
                #pp = ohodnotenie + self.pole2[m][n]
                if pp > naj:
                    naj = pp
                self.potiahni(m,n,k,l,tah)
                #if pp > oo:
                    #break
            return naj
                
        if self.hrac:
            max = -1000
            #hodnota1 = self.ohodnot_plochu()
            for (y,x,y1,x1) in self.legalne_tahy2(-200):
                o = self.potiahni(y,x,y1,x1)
                if not self.sach(-200):
                    min = 1000
                    #hodnota2 = hodnota1 + self.pole[y1][x1]

                    for (y2,x2,y3,x3) in self.legalne_tahy2(200):
                        p = self.potiahni(y2,x2,y3,x3)
                        if not self.sach(200):
                            #hodnota3 = hodnota2 + self.pole2[y3][x3]
                            ohodnot = maxi(min)
                            if ohodnot < min:
                                min = ohodnot
                        self.potiahni(y3,x3,y2,x2,p)
                        if min < max:
                            break
                        
                    if min > max:
                        max = min
                        pamet = (y,x,y1,x1)
                self.potiahni(y1,x1,y,x,o)
                
            self.nepriatel_pohyb(*pamet)
            self.oprav_damu_pesca(pamet)
            self.kontrola_matu(200)
            print(time.time()-t)

    def tabulky(self,figurka):
        if figurka == 1:
            return [[7.0,7.0,7.0,7.0,7.0,7.0,7.0,7.0],
                    [5.0,5.0,5.0,5.0,5.0,5.0,5.0,5.0],
                    [1.0,1.0,2.0,3.0,3.0,2.0,1.0,1.0],
                    [0.5,0.5,1.0,2.5,2.5,1.0,0.5,0.5],
                    [0.0,0.0,0.0,2.0,2.0,0.0,0.0,0.0],
                    [0.5,-0.5,-1.0,0.0,0.0,-1.0,-0.5,0.5],
                    [0.5,1.0,1.0,-2.0,-2.0,1.0,1.0,0.5],
                    [0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]]
        elif figurka == 5:
            return [[0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0],
                    [0.5,1.0,1.0,1.0,1.0,1.0,1.0,0.5],
                    [-0.5,0.0,0.0,0.0,0.0,0.0,0.0,-0.5],
                    [-0.5,0.0,0.0,0.0,0.0,0.0,0.0,-0.5],
                    [-0.5,0.0,0.0,0.0,0.0,0.0,0.0,-0.5],
                    [-0.5,0.0,0.0,0.0,0.0,0.0,0.0,-0.5],
                    [-0.5,0.0,0.0,0.0,0.0,0.0,0.0,-0.5],
                    [0.0,0.0,0.0,0.5,0.5,0.0,0.0,0.0]]
        elif figurka == 3:
            return [[-5.0,-4.0,-3.0,-3.0,-3.0,-3.0,-4.0,-5.0],
                    [-4.0,-2.0,0.0,0.0,0.0,0.0,-2.0,-4.0],
                    [-3.0,0.0,1.0,1.5,1.5,1.0,0.0,-3.0],
                    [-3.0,0.5,1.5,2.0,2.0,1.5,0.5,-3.0],
                    [-3.0,0.0,1.5,2.0,2.0,1.5,0.0,-3.0],
                    [-3.0,0.5,1.0,1.5,1.5,1.0,0.5,-3.0],
                    [-4.0,-2.0,0.0,0.5,0.5,0.0,-2.0,-4.0],
                    [-5.0,-4.0,-3.0,-3.0,-3.0,-3.0,-4.0,-5.0]]
        elif figurka == 3.5:
            return [[-2.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-2.0],
                    [-1.0,0.0,0.0,0.0,0.0,0.0,0.0,-1.0],
                    [-1.0,0.0,0.5,1.0,1.0,0.5,0.0,-1.0],
                    [-1.0,0.5,0.5,1.0,1.0,0.5,0.5,-1.0],
                    [-1.0,0.0,1.0,1.0,1.0,1.0,0.0,-1.0],
                    [-1.0,1.0,1.0,1.0,1.0,1.0,1.0,-1.0],
                    [-1.0,0.5,0.0,0.0,0.0,0.0,0.5,-1.0,],
                    [-2.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-2.0]]
        elif figurka == 9:
            return [[-2.0,-1.0,-1.0,-0.5,-0.5,-1.0,-1.0,-2.0],
                    [-1.0,0.0,0.0,0.0,0.0,0.0,0.0,-1.0],
                    [-1.0,0.0,0.5,0.5,0.5,0.5,0.0,-1.0],
                    [-0.5,0.0,0.5,0.5,0.5,0.5,0.0,-0.5],
                    [0.0,0.0,0.5,0.5,0.5,0.5,0.0,-0.5],
                    [-1.0,0.5,0.5,0.5,0.5,0.5,0.0,-1.0],
                    [-1.0,0.0,0.5,0.0,0.0,0.0,0.0,-1.0],
                    [-2.0,-1.0,-1.0,-0.5,-0.5,-1.0,-1.0,-2.0]]
        elif figurka == 200:
            return [[-3.0,-4.0,-4.0,-5.0,-5.0,-4.0,-4.0,-3.0],
                    [-3.0,-4.0,-4.0,-5.0,-5.0,-4.0,-4.0,-3.0],
                    [-3.0,-4.0,-4.0,-5.0,-5.0,-4.0,-4.0,-3.0],
                    [-3.0,-4.0,-4.0,-5.0,-5.0,-4.0,-4.0,-3.0],
                    [-2.0,-3.0,-3.0,-4.0,-4.0,-3.0,-3.0,-2.0],
                    [-1.0,-2.0,-2.0,-2.0,-2.0,-2.0,-2.0,-1.0],
                    [2.0,2.0,0.0,0.0,0.0,0.0,2.0,2.0],
                    [2.0,3.0,1.0,0.0,0.0,1.0,3.0,2.0]]

    def potiahni(self,y,x,y1,x1,o=0.0):
        pamet =  self.pole2[y1][x1]
        self.pole2[y1][x1], self.pole2[y][x] = self.pole2[y][x] ,o
        return pamet
    
    def nepriatel_pohyb(self,y,x,y1,x1):    
        self.potiahni(y,x,y1,x1)
        self.hrac = (self.hrac + 1) % 2
        self.tah += 1
        a,b = 135+y*70, 135+x*70
        while a != 135+y1*70 or b != 135+x1*70:
            if a < 135+y1*70:
                a += 1
            elif a > 135+y1*70:
                a -= 1

            if b < 135+x1*70:
                b += 1
            elif b > 135+x1*70:
                b -= 1
            self.canvas.after(2,self.canvas.update())
            self.canvas.coords(self.pole[y][x],b,a)
        self.canvas.delete(self.pole[y1][x1])
        self.pole[y1][x1], self.pole[y][x] = self.pole[y][x] ,0.0

    def kresli_sach(self):
        for i in 200,-200:
            if self.sach(i):
                y,x = self.pozicia_figurky(i)
                y,x = 135 + 70*y,135+70*x
                self.canvas.itemconfig(self.red,state="normal")
                self.canvas.coords(self.red,x,y)
                return
        self.canvas.itemconfig(self.red,state="hidden")

    def kresli_moznosti(self,y,x):
        for a,b,i,j in self.legalne_tahy(self.pole2[y][x]):
            if (a,b) == (y,x):
            
                if self.pole2[i][j] == 0:
                    self.canvas.itemconfig(self.zelene_kruzky[i][j][0],state="normal")
                else:
                    self.canvas.itemconfig(self.zelene_kruzky[i][j][1],state="normal")

    def zmaz_moznosti(self):
        for i in range(8):
            for j in range(8):
                self.canvas.itemconfig(self.zelene_kruzky[i][j][0],state="hidden")
                self.canvas.itemconfig(self.zelene_kruzky[i][j][1],state="hidden")
               
    
p=Program()
