// Copyright 2005, Google Inc.
// All rights reserved.

#include <iostream>
#include "gtest/gtest.h"
#include "Bankomat.h"
using namespace std;
using namespace ::testing;

BANKOMAT * bankomatInit(void) {
	SPRAVCA_UZIVATELOV * pUzivatelia = new SPRAVCA_UZIVATELOV();
	pUzivatelia->pridajUzivatela(UZIVATEL(0, "9999", 0));
	pUzivatelia->pridajUzivatela(UZIVATEL(1, "1234", 400));
	pUzivatelia->pridajUzivatela(UZIVATEL(2, "2345", 1200));
	pUzivatelia->pridajUzivatela(UZIVATEL(3, "3456", 3750));
	pUzivatelia->pridajUzivatela(UZIVATEL(4, "4567", 825));

	ZOSTAVA_BANKOVIEK prvotnaNapln;
	prvotnaNapln.pocet10 = 35;
	prvotnaNapln.pocet20 = 25;
	prvotnaNapln.pocet50 = 15;
	prvotnaNapln.pocet100 = 10;
	prvotnaNapln.pocet200 = 3;
	prvotnaNapln.pocet500 = 1;

	BANKOMAT *pBankomat = new BANKOMAT(pUzivatelia, prvotnaNapln, 0.05);
	return pBankomat;
}


//Uloha 1.
TEST_F(Test, Stav_uctu) {
	SPRAVCA_UZIVATELOV * pUzivatelia = new SPRAVCA_UZIVATELOV();
	pUzivatelia->pridajUzivatela(UZIVATEL(0, "9999", 0));
	pUzivatelia->pridajUzivatela(UZIVATEL(1, "1234", 400));
	pUzivatelia->pridajUzivatela(UZIVATEL(2, "2345", 1200));
	pUzivatelia->pridajUzivatela(UZIVATEL(3, "3456", 3750));
	pUzivatelia->pridajUzivatela(UZIVATEL(4, "4567", 825));

	ZOSTAVA_BANKOVIEK prvotnaNapln;
	prvotnaNapln.pocet10 = 35;
	prvotnaNapln.pocet20 = 25;
	prvotnaNapln.pocet50 = 15;
	prvotnaNapln.pocet100 = 10;
	prvotnaNapln.pocet200 = 3;
	prvotnaNapln.pocet500 = 1;

	BANKOMAT bankomat(pUzivatelia, prvotnaNapln, 0.05);
	//bankomatInit();
	ASSERT_EQ(400, bankomat.zistitStavUctu(1,"1234"));
}
TEST_F(Test, vyber_nad_limit) {
	BANKOMAT *pBankomat = bankomatInit();

	ASSERT_FALSE((pBankomat->vybratPeniaze(1, "1234", 403)).Status);
}
TEST_F(Test, neplatne_id) {
	BANKOMAT *pBankomat = bankomatInit();
	pBankomat->vybratPeniaze(10, "1234", 500);
	ASSERT_EQ("Neplatny uzivatel", pBankomat->vypisatSystemovuSpravu());
}/*
 viacnasobny vyber - prekrocenie limitu
 neplatny administrator
 nevhodne bankovky v bankomate
 zalozenie duplicitneho uzivatela
 overit uzivatela
 neplatny vzor pinkodu
 zaporne id uzivatela
 zaporna suma na ucte pri inite

 ASSERT_EQ(1, (pBankomat->vybratPeniaze(1, "1234", 100)).bankovky.pocet50);

TEST_F(Test, ) {
	BANKOMAT *pBankomat = bankomatInit();
	pBankomat->vybratPeniaze(10, "1234", 500);
	ASSERT_EQ("Neplatny uzivatel", pBankomat->vypisatSystemovuSpravu());
}*/




//	ASSERT_TRUE(jeCislica('0'));
/*
TEST_F(Test, Pridanie_duplicitneho_uzivatela) {
	UZIVATEL a(1, "2345", 235000);
	UZIVATEL b(1, "0000", 95000);
	UZIVATELIA uzivatelia;
	uzivatelia.pridajUzivatela(a);
	ASSERT_FALSE(uzivatelia.pridajUzivatela(b));
}

TEST_F(Test, Over_uzivatela) {
	UZIVATEL a(1, "2345", 235000);
	UZIVATEL b(1, "0000", 95000);
	UZIVATELIA uzivatelia;
	uzivatelia.pridajUzivatela(a);
	uzivatelia.pridajUzivatela(b);
	ASSERT_TRUE(uzivatelia.overUzivatela(b));
}*/
