class ProbeHashMap:
    _avail = 'avail'

    class _Item:
        def __init__(self, key, value):
            self._key, self._value = key, value

        def __repr__(self):
            return repr(self._key) + ':' + repr(self._value)

    def __init__(self, capacity=11, step=1):
        self._table = [None for i in range(capacity)]
        self.step = step
        self.capacity= capacity
        self.pocet=0

    def _hash(self, key):
        return key % len(self._table)

    def find(self,key):
        
        ix = self._hash(key)
        av = None
        while True:
            item = self._table[ix]
            if item is None:
                if av is None:
                    av=ix
                return False,av
            if item == self._avail:
                if av is None:
                    av=ix
            elif item._key==key:
                return True,ix
            ix = (ix+self.step)%len(self._table)
                
        
        
    
    def valueof(self, key):
        found, ix = self.find(key)
        if found:
            return self._table[ix]._value
        raise KeyError

    def add(self, key, value):
        found, ix=self.find(key)
        if found:
            self._table[ix]._value=value
            return
        
        self._table[ix]=self._Item(key,value)
        self.pocet+=1
        if self.pocet>=(self.capacity//2+1):
            self.resize()
            
        

    def resize(self):
        
        pom = self._table
        self._table = [None for i in range(self.capacity*2)]
        self.capacity*=2
        self.pocet=0
        for item in pom:
            if item is not None and item is not self._avail:
                self.add(item._key,item._value)

            
            

    def delete(self, key):
        found, ix =self.find(key)
        if found:
            self._table[ix]=self._avail
            self.pocet-=1
        else:
            raise KeyError
        

    def __len__(self):
        #return len(self._table)
        return self.pocet
##        pocet=0
##        for prvok in self._table:
##            if prvok is not None and prvok != self._avail:
##                pocet +=1
##        return pocet

    def __iter__(self):
        # vrati generator vsetkych klucov
        # yield from self._table
	for item in self._table:
	    if item is not None:
		yield item
        ...

    def __repr__(self):
        res = []
        for i, item in enumerate(a._table):
            res.append(repr((i, item)))
        return '; '.join(res)

if __name__ == '__main__':
    a = ProbeHashMap()
    for k in 38, 10, 17, 24, 53:
        a.add(k, str(k))
    print(a)
    print('***** pridal som 9 a vyhodil 53')
    a.add(9, 999)
    a.delete(53)
    print(a)
    print('***** pridal som 31')
    a.add(31, 333)
    print(a)
