package application;

import javafx.util.Duration;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.stage.Stage;

import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

/**
 * @author Michal Pazmany
 * @version 1.1
 * 
 *          Trieda Main spusta a ovlada celu hru.
 */
public class Main extends Application {

	/**
	 * @param args args
	 */
	public static void main(String[] args) {
		launch(args);
	}

	/**
	 * Narocnost sudoku. Pocet cisiel na odstranenie, teda cim vacsie cislo ktore je mensie ako 81,
	 * tym tazsie sudoku.
	 */
	public static final int narocnost = 30;

	/**
	 * Pocet riadkov sudoku.
	 */
	public static final int rows = 9;
	/**
	 * Pocet stlpcov sudoku.
	 */
	public static final int cols = 9;
	/**
	 * Velkost zvyrazneneho boxu sudoku.
	 */
	static int B = 3;
	/**
	 * Pocet cisiel ktore sa pridaju na zaciatku, aby sa generovalo vzdy unikatne
	 * sudoku. Najlepsie funguje s hodnotou 12. Odporucane nastavenie je 10-15, moze
	 * mat za nasledok pomalsie generovanie sudoku zadania.
	 */
	static int PRIDAJ = 12;
	/**
	 * Vyska plochy na kreslenie Sudoku.
	 */
	int height = 600;
	/**
	 * Sirka plochy na kreslenie Sudoku.
	 */
	int width = 600;
	/**
	 * Vyska jedneho policka sudoku.
	 */
	int vyskaPolicka = height / rows;
	/**
	 * Sirka jedneho policka sudoku.
	 */
	int sirkaPolicka = width / cols;

	/**
	 * Stav hry, uchovava si cas a pole Cisiel. Pouziva sa na vykreslenie.
	 */
	StavHry stav;
	/**
	 * Stav hry v zjednodusenej verzii. Pouziva sa pri rieseni sudoku.
	 */
	int[][] hra;

	// Layout
	/**
	 * Zaklad okna.
	 */
	BorderPane root;
	/**
	 * Mriezka tlacidiel.
	 */
	GridPane tlacidla;
	/**
	 * Infopanel.
	 */
	FlowPane info;
	/**
	 * Plocha na kreslenie sudoku.
	 */
	Canvas plocha;
	/**
	 * Graficky kontext plochy.
	 */
	GraphicsContext gc;

	/**
	 * Tlacidlo na generovanie noveho zadania sudoku.
	 */
	Button generuj;
	/**
	 * Tlacidlo na zobrazenie pomoci. Najdenie vhodneho tahu.
	 */
	Button pomoc;
	/**
	 * Tlacidlo na ukladanie stavu hry.
	 */
	Button uloz;
	/**
	 * Tlacidlo na nacitanie stavu hry.
	 */
	Button nacitaj;
	/**
	 * Tlacidlo na ukoncenie aplikacie.
	 */
	Button ukonci;
	/**
	 * Tlacidlo na doplnanie s cislom 1.
	 */
	Button c1;
	/**
	 * Tlacidlo na doplnanie s cislom 2.
	 */
	Button c2;
	/**
	 * Tlacidlo na doplnanie s cislom 3.
	 */
	Button c3;
	/**
	 * Tlacidlo na doplnanie s cislom 4.
	 */
	Button c4;
	/**
	 * Tlacidlo na doplnanie s cislom 5.
	 */
	Button c5;
	/**
	 * Tlacidlo na doplnanie s cislom 6.
	 */
	Button c6;
	/**
	 * Tlacidlo na doplnanie s cislom 7.
	 */
	Button c7;
	/**
	 * Tlacidlo na doplnanie s cislom 8.
	 */
	Button c8;
	/**
	 * Tlacidlo na doplnanie s cislom 9.
	 */
	Button c9;
	/**
	 * Tlacidlo na zmazanie cisla z mriezky ak sme sa pomylili.
	 */
	Button zmaz;

	/**
	 * Napis s casom.
	 */
	Label cas;
	/**
	 * Napis s napovedou.
	 */
	Label napoveda;
	/**
	 * Zaciatocny cas hry v milisekundach.
	 */
	long startCas;
	/**
	 * Celkovy cas hry v milisekundach.
	 */
	long total;
	/**
	 * Pocet milisekund na vykreslenie.
	 */
	long millis;
	/**
	 * Pocet hodin na vykreslenie.
	 */
	long hours;
	/**
	 * Pocet minut na vykreslenie.
	 */
	long minutes;
	/**
	 * Pocet sekund na vykreslenie.
	 */
	long seconds;

	/**
	 * Casovac na vykreslovanie casu hry.
	 */
	Timeline casovac;

	/*
	 * (non-Javadoc) Riadi cele sudoku. Odchytava eventy pri stlaceni tlacidiel a
	 * pri kliknuti mysou. Spusta casovac a inicializuje vsetky graficke komponenty.
	 * 
	 * @see javafx.application.Application#start(javafx.stage.Stage)
	 */
	@Override
	public void start(Stage primaryStage) {
		stav = new StavHry();
		hra = new int[rows][cols];

		tlacidla = new GridPane();
		generuj = new Button("generate");
		generuj.setWrapText(true);
		generuj.setMaxSize(width / rows, 50);
		generuj.setPrefSize(width / rows, 50);
		pomoc = new Button("hint");
		pomoc.setWrapText(true);
		pomoc.setMaxSize(width / rows, 50);
		pomoc.setPrefSize(width / rows, 50);
		zmaz = new Button("delete number");
		zmaz.setWrapText(true);
		zmaz.setMaxSize(width / rows, 50);
		zmaz.setPrefSize(width / rows, 50);
		uloz = new Button("save");
		uloz.setWrapText(true);
		uloz.setMaxSize(width / rows, 50);
		uloz.setPrefSize(width / rows, 50);
		nacitaj = new Button("load");
		nacitaj.setWrapText(true);
		nacitaj.setMaxSize(width / rows, 50);
		nacitaj.setPrefSize(width / rows, 50);
		ukonci = new Button("quit");
		ukonci.setWrapText(true);
		ukonci.setMaxSize(width / rows, 50);
		ukonci.setPrefSize(width / rows, 50);
		c1 = new Button("1");
		c1.setWrapText(true);
		c1.setPrefSize(width / rows, 40);
		c2 = new Button("2");
		c2.setWrapText(true);
		c2.setPrefSize(width / rows, 40);
		c3 = new Button("3");
		c3.setWrapText(true);
		c3.setPrefSize(width / rows, 40);
		c4 = new Button("4");
		c4.setWrapText(true);
		c4.setPrefSize(width / rows, 40);
		c5 = new Button("5");
		c5.setWrapText(true);
		c5.setPrefSize(width / rows, 40);
		c6 = new Button("6");
		c6.setWrapText(true);
		c6.setPrefSize(width / rows, 40);
		c7 = new Button("7");
		c7.setWrapText(true);
		c7.setPrefSize(width / rows, 40);
		c8 = new Button("8");
		c8.setWrapText(true);
		c8.setPrefSize(width / rows, 40);
		c9 = new Button("9");
		c9.setWrapText(true);
		c9.setPrefSize(width / rows, 40);
		tlacidla.add(generuj, 0, 0);
		tlacidla.add(pomoc, 1, 0);
		tlacidla.add(uloz, 5, 0);
		tlacidla.add(nacitaj, 6, 0);
		tlacidla.add(ukonci, 8, 0);
		tlacidla.add(c1, 0, 1);
		tlacidla.add(c2, 1, 1);
		tlacidla.add(c3, 2, 1);
		tlacidla.add(c4, 3, 1);
		tlacidla.add(c5, 4, 1);
		tlacidla.add(c6, 5, 1);
		tlacidla.add(c7, 6, 1);
		tlacidla.add(c8, 7, 1);
		tlacidla.add(c9, 8, 1);
		tlacidla.add(zmaz, 3, 0);

		tlacidla.setHgap(0);
		tlacidla.setVgap(0);
		tlacidla.setAlignment(Pos.CENTER);
		tlacidla.setBackground(new Background(new BackgroundFill(Color.SKYBLUE, null, null)));

		cas = new Label("Time: ");
		cas.setFont(Font.font("Consolas", 20));
		napoveda = new Label("Hint: ");
		napoveda.setFont(Font.font("Consolas", 20));

		info = new FlowPane(napoveda, cas);
		info.setHgap(width * 100);
		info.setVgap(1);
		info.setAlignment(Pos.TOP_LEFT);
		// info.setAlignment(Pos.CENTER);
		info.setBackground(new Background(new BackgroundFill(Color.SKYBLUE, null, null)));

		casovac = new Timeline(new KeyFrame(Duration.millis(1), e -> {
			total = System.currentTimeMillis() - startCas;
			millis = System.currentTimeMillis() - startCas;
			hours = millis / (1000 * 60 * 60);
			millis -= hours * (1000 * 60 * 60);
			minutes = millis / (1000 * 60);
			millis -= minutes * (1000 * 60);
			seconds = millis / 1000;
			millis -= seconds * 1000;
			// cas.setText("Time: " + hours + ":" + minutes + ":" + seconds+"."+millis);
			cas.setText("Time: " + String.format("%02d", hours) + ":" + String.format("%02d", minutes) + ":"
					+ String.format("%02d", seconds) + "." + String.format("%1d", millis));
		}));
		casovac.setCycleCount(Timeline.INDEFINITE);

		generuj.setOnAction(event -> {
			Sudoku.generujSudoku(hra, PRIDAJ, narocnost);
			napoveda.setText("Hint: ");
			for (int i = 0; i < rows; i++) {
				for (int j = 0; j < cols; j++) {
					stav.mriezka[i][j].cifra = hra[i][j];
					stav.mriezka[i][j].oznacene = false;
					if (hra[i][j] != 0) {
						stav.mriezka[i][j].generovane = true;
					} else {
						stav.mriezka[i][j].generovane = false;
					}
				}
			}
			paint();
			startCas = System.currentTimeMillis();
			casovac.play();
			// Sudoku.vytlacMriezku(hra);
		});
		pomoc.setOnAction(event -> {
			String hint = Sudoku.onHint(hra);
			napoveda.setText(hint);
			paint();
		});
		ukonci.setOnAction(event -> {
			casovac.stop();
			System.exit(0);
		});
		uloz.setOnAction(event -> {
			// casovac.stop();
			stav.cas = total;
			napoveda.setText("Hint: ");
			stav.save("subor.txt");
		});
		nacitaj.setOnAction(event -> {
			stav = StavHry.load("subor.txt");
			startCas = System.currentTimeMillis() - stav.cas;
			napoveda.setText("Hint: ");
			for (int r = 0; r < rows; r++) {
				for (int s = 0; s < cols; s++) {
					hra[r][s] = stav.mriezka[r][s].cifra;
				}
			}
			casovac.play();
			paint();
			vyhra(hra);
		});

		c1.setOnAction(event -> {
			doplnCifru(1);
			paint();
			vyhra(hra);
		});

		c2.setOnAction(event -> {
			doplnCifru(2);
			paint();
			vyhra(hra);
		});

		c3.setOnAction(event -> {
			doplnCifru(3);
			paint();
			vyhra(hra);
		});

		c4.setOnAction(event -> {
			doplnCifru(4);
			paint();
			vyhra(hra);
		});

		c5.setOnAction(event -> {
			doplnCifru(5);
			paint();
			vyhra(hra);
		});

		c6.setOnAction(event -> {
			doplnCifru(6);
			paint();
			vyhra(hra);
		});

		c7.setOnAction(event -> {
			doplnCifru(7);
			paint();
			vyhra(hra);
		});

		c8.setOnAction(event -> {
			doplnCifru(8);
			paint();
			vyhra(hra);
		});

		c9.setOnAction(event -> {
			doplnCifru(9);
			paint();
			vyhra(hra);
		});

		zmaz.setOnAction(event -> {
			for (int r = 0; r < rows; r++) {
				for (int s = 0; s < cols; s++) {
					if (stav.mriezka[r][s].oznacene == true) {
						stav.mriezka[r][s].cifra = 0;
						hra[r][s] = 0;
					}
				}
			}
			paint();
		});

		plocha = new Canvas(width, height);
		gc = plocha.getGraphicsContext2D();

		BorderPane root = new BorderPane();

		root.setBottom(tlacidla);
		root.setTop(info);
		root.setLeft(plocha);
		Scene scene = new Scene(root, width, height + 140);
		scene.widthProperty().addListener(ov -> {
			plocha.setWidth(scene.getWidth());
			width = (int) plocha.getWidth();
			sirkaPolicka = (int) (plocha.getWidth() / cols);
			paint();
		});
		scene.heightProperty().addListener(ov -> {
			plocha.setHeight(scene.getHeight() - 140);
			height = (int) plocha.getHeight();
			vyskaPolicka = (int) (plocha.getHeight() / rows);
			paint();
		});
		primaryStage.setScene(scene);
		primaryStage.setTitle("Sudoku");
		primaryStage.show();
		paint();

		plocha.setOnMouseClicked(e -> {
			klikV(e.getX(), e.getY());
		});

	}

	/**
	 * Pri kliknuti na plochu prepocita suradnice kliknutia na vhodne suradnice pola
	 * sudoku a oznaci sa prvok na kliknutej pozicii.
	 * 
	 * @param x
	 *            X-ova suradnica kliknutia mysi.
	 * @param y
	 *            Y-ova suradnica kliknutia mysi.
	 */
	void klikV(double x, double y) {
		int sx = (int) (x / sirkaPolicka);
		int sy = (int) (y / vyskaPolicka);
		if (sx > 8) {
			sx = 8;
		}
		if (sy > 8) {
			sy = 8;
		}
		// System.out.println(Integer.toString(sx)+Integer.toString(sy));
		if (stav.mriezka[sx][sy].generovane == false) {
			for (int r = 0; r < rows; r++) {
				for (int s = 0; s < cols; s++) {
					stav.mriezka[r][s].oznacene = false;
				}
			}
			stav.mriezka[sx][sy].oznacene = true;
		}
		paint();
	}

	/**
	 * Pri kliknuti na tlacidlo skontroluje 2d pole cisiel a doplni cislo na
	 * oznacenu poziciu podla stlaceneho tlacidla.
	 * 
	 * @param cifra
	 *            Cislo na doplnenie. Zadava sa tlacidlom.
	 */
	void doplnCifru(int cifra) {
		for (int r = 0; r < rows; r++) {
			for (int s = 0; s < cols; s++) {
				if (stav.mriezka[r][s].oznacene == true) {
					if (Sudoku.vyhovujePravidlam(r, s, cifra, hra)) {
						stav.mriezka[r][s].cifra = cifra;
						hra[r][s] = cifra;
					}
				}
			}
		}
	}

	/**
	 * Kontroluje ci uz je cele sudoku spravne vyplnene. Ak ano, stopne casovac a
	 * oznami vyhru.
	 * 
	 * @param mriezka
	 *            Pole, ktore sa kontroluje.
	 */
	void vyhra(int[][] mriezka) {
		for (int r = 0; r < rows; r++) {
			for (int s = 0; s < cols; s++) {
				if (mriezka[r][s] == 0) {
					return;
				}
			}
		}
		if (Sudoku.jeSudokuPlatne(hra)) {
			// System.out.println("VYHRAL SI");
			napoveda.setText("VYHRAL SI!!");
			casovac.stop();
		}

	}

	/**
	 * Vykreslovanie celej hracej plochy parametrizovane, teda pri zmeneni sirky
	 * okna sa plocha prisposobi.
	 */
	void paint() {
		gc.setFill(Color.GAINSBORO);
		gc.fillRect(0, 0, plocha.getWidth(), plocha.getHeight());
		for (int a = 0; a < B; a++) {
			for (int b = 0; b < B; b++) {
				gc.setStroke(Color.BLACK);
				gc.setLineWidth(3);
				gc.strokeRect(a * sirkaPolicka * 3 + 1.5, b * vyskaPolicka * 3 + 1.5, 3 * sirkaPolicka,
						3 * vyskaPolicka);
			}
		}
		for (int r = 0; r < rows; r++) {
			for (int s = 0; s < cols; s++) {
				if (stav.mriezka[r][s].oznacene == false) {
					gc.setStroke(Color.BLACK);
					gc.setLineWidth(1);
					gc.strokeRect(r * sirkaPolicka, s * vyskaPolicka, sirkaPolicka, vyskaPolicka);
				} else {
					gc.setStroke(Color.BLUE);
					gc.setLineWidth(5);
					gc.strokeRect(r * sirkaPolicka, s * vyskaPolicka, sirkaPolicka, vyskaPolicka);
				}
				if (stav.mriezka[r][s].cifra != 0) {
					if (stav.mriezka[r][s].generovane == true) {
						gc.setFill(Color.BLACK);
						gc.setFont(Font.font("Verdana", vyskaPolicka / 1.8));
						gc.fillText(Integer.toString(stav.mriezka[r][s].cifra), r * sirkaPolicka + sirkaPolicka / 3,
								s * vyskaPolicka + vyskaPolicka / 1.5);
					} else {
						gc.setFill(Color.GRAY);
						gc.setFont(Font.font("Verdana", vyskaPolicka / 1.8));
						gc.fillText(Integer.toString(stav.mriezka[r][s].cifra), r * sirkaPolicka + sirkaPolicka / 3,
								s * vyskaPolicka + vyskaPolicka / 1.5);
					}
				}
			}
		}
	}

}
