package application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * @author Michal Pazmany
 * @version 1.1
 * 
 *          Trieda StavHry uchovava v sebe informacie o hre.
 */
public class StavHry implements Serializable {

	/**
	 * Cas trvania hry v milisekundach.
	 */
	long cas;
	/**
	 * Dvojrozmerne pole objektov triedy Cislo.
	 */
	Cislo[][] mriezka;

	/**
	 * Konstruktor. Nainicializuje mriezku Cisiel s ciframi 0.
	 */
	public StavHry() {
		mriezka = new Cislo[Main.rows][Main.cols];
		for (int i = 0; i < Main.rows; i++) {
			for (int j = 0; j < Main.cols; j++) {
				this.mriezka[i][j] = new Cislo(0, false);
			}
		}
	}

	/**
	 * Ulozenie stavu hry.
	 * 
	 * @param filePath
	 *            Cesta a nazov suboru na ulozenie.
	 * @return Vrati objekt triedy StavHry.
	 */
	public static StavHry load(String filePath) {
		File f = new File(filePath);
		ObjectInputStream os = null;
		StavHry stav = null;
		try {
			os = new ObjectInputStream(new FileInputStream(f));
			stav = (StavHry) os.readObject();
		} catch (IOException | ClassNotFoundException e) {
			e.printStackTrace();
		}
		/*
		 * if (stav == null) System.out.println("Stav je null"); else
		 * System.out.println("Stav je OK");
		 */
		return stav;
	}

	/**
	 * Nacitanie stavu hry.
	 * 
	 * @param filePath
	 *            Cesta k suboru na nacitanie.
	 */
	public void save(String filePath) {
		File f = new File(filePath);
		ObjectOutputStream os = null;
		try {
			os = new ObjectOutputStream(new FileOutputStream(f));
			os.writeObject(this);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
