package com.example.micha.hra;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class Game extends AppCompatActivity {

    int round =0;
    int score =50;
    String name;
    int roundTime=10;
    Random rnd =new Random();
    ImageView kocka;
    Timer timer;
    Integer[] dice = new Integer[3];

    SharedPreferences prefs;
    SharedPreferences.Editor editor;

    TextView scoreText;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_game);


        Intent intent = getIntent();
        name = intent.getStringExtra(MainActivity.EXTRA_MESSAGE);

        TextView textView = findViewById(R.id.textView);
        textView.setText(name);
        scoreText = findViewById(R.id.textView2);
        scoreText.setText("Score: "+score);

        prefs = this.getSharedPreferences("myPrefsKey", Context.MODE_PRIVATE);
        editor = prefs.edit();



        timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        roundTime-=1;
                        int rndKocka = rnd.nextInt(3);
                        switch (rndKocka){
                            case 0:
                                kocka = (ImageView) findViewById(R.id.imageView);
                                break;
                            case 1:
                                kocka = (ImageView) findViewById(R.id.imageView2);
                                break;
                            case 2:
                                kocka = (ImageView) findViewById(R.id.imageView3);
                                break;
                            default:
                                break;
                        }

                        int rndCislo = rnd.nextInt(6);
                        switch (rndCislo){
                            case 0:
                                kocka.setImageResource(R.drawable.c1);
                                break;
                            case 1:
                                kocka.setImageResource(R.drawable.c2);
                                break;
                            case 2:
                                kocka.setImageResource(R.drawable.c3);
                                break;
                            case 3:
                                kocka.setImageResource(R.drawable.c4);
                                break;
                            case 4:
                                kocka.setImageResource(R.drawable.c5);
                                break;
                            case 5:
                                kocka.setImageResource(R.drawable.c6);
                                break;
                            default:
                                break;
                        }
                        dice[rndKocka]=rndCislo;
                        if(round>=10){
                            timer.cancel();

                            editor.putInt(name, score);
                            editor.commit();
                        }
                        if(roundTime==0){
                            score/=2;
                            round++;
                            roundTime=10;
                            scoreText.setText("Score: "+score+" Kolo: "+round);
                        }

                    }
                });
            }
        }, 1000, 1000);
    }

    public void stopGame(View view) {
        if((dice[0]==dice[1] && dice[1]==dice[2])&& round<=10){
            score*=3;
        } else if(((dice[0]==dice[1]) || (dice[1]==dice[2]) || (dice[0]==dice[2]))&& round<=10){
            score*=2;
        } else {
            score/=2;
        }
        if(round<=10){
            scoreText.setText("Score: "+score+" Kolo: "+round);
            round++;
        }


    }


}
