import tkinter
import heapq
import random

class BinTree:
    class _Node:
        def __init__(self, key, value=None, parent=None):
            self._key = key
            self._value = value
            self._parent = parent
            self._left = None
            self._right = None

        def __repr__(self):
            if self._value is not None:
                return '{!r}:{!r}'.format(self._key, self._value)
            else:
                return repr(self._key)

    #------------------------------------------------------------------

    def __init__(self):
        self._root = None
        self._size = 0

        self.root = tkinter.Tk()
        self.root.title('Vizualizácia haldy')

        self.canvas = tkinter.Canvas(self.root,bg='lemon chiffon', width=1000,height=425)
        self.canvas.pack()
        self.zobraz = 0

        self.halda = HeapPriorityQueue()
        self.nakresli_menu()
        self.vykresli()

        self.canvas.bind('<Button-1>', self.klik)
        self.canvas.bind_all('0', self.klavesa)
        self.canvas.bind_all('1', self.klavesa)
        self.canvas.bind_all('2', self.klavesa)
        self.canvas.bind_all('3', self.klavesa)
        self.canvas.bind_all('4', self.klavesa)
        self.canvas.bind_all('5', self.klavesa)
        self.canvas.bind_all('6', self.klavesa)
        self.canvas.bind_all('7', self.klavesa)
        self.canvas.bind_all('8', self.klavesa)
        self.canvas.bind_all('9', self.klavesa)
        self.canvas.bind_all('<Return>', self.klavesa)
        self.canvas.bind_all('<BackSpace>', self.klavesa)
        self.canvas.mainloop()

    def nakresli_menu(self):
        cislo = 0
        for y in 0, 30:
            for x in range(0,121,30):
                self.canvas.create_oval(750+x,40+y,780+x,70+y,width=1, fill='pale goldenrod')
                self.canvas.create_text(765+x,55+y, text=cislo)
                cislo += 1


        self.canvas.create_rectangle(750,125,850,155,width=0,fill='khaki')
                
        self.canvas.create_rectangle(750,170,900,200, width=2,fill='pale goldenrod')
        self.canvas.create_text(825,185, text='zmaž cifru')
        self.canvas.create_rectangle(750,210,900,240, width=2,fill='pale goldenrod')
        self.canvas.create_text(825,225, text='pridaj prvok')
        self.canvas.create_rectangle(750,240,900,270, width=2,fill='pale goldenrod')
        self.canvas.create_text(825,255, text='odstráň najmenší prvok')
        self.canvas.create_rectangle(750,270,900,300, width=2,fill='pale goldenrod')
        self.canvas.create_text(825,285, text='generuj náhodný strom')
        self.canvas.create_rectangle(750,300,900,330, width=2,fill='pale goldenrod')
        self.canvas.create_text(825,315, text='vyprázdni strom')
        self.canvas.create_rectangle(750,340,900,370, width=2,fill='pale goldenrod')
        self.canvas.create_text(825,355, text='načítaj súbor')
        self.canvas.create_rectangle(750,370,900,400, width=2,fill='pale goldenrod')
        self.canvas.create_text(825,385, text='zapíš do súboru')
        
        self.canvas.create_text(920,418, text='Vytvoril: Michal Pázmány')

    def klik(self, udalost):
        self.udalost_x, self.udalost_y = udalost.x, udalost.y
        if self.udalost_x >=750 and self.udalost_x <=780 and self.udalost_y>=40 and self.udalost_y<=70:
            if self.zobraz == 0:
                pass
            else:
                if len(str(self.zobraz))<16:
                    self.zobraz = self.zobraz*10
                    self.vykresli()
            
        elif self.udalost_x >=780 and self.udalost_x <=810 and self.udalost_y>=40 and self.udalost_y<=70:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+1
                self.vykresli()
        elif self.udalost_x >=810 and self.udalost_x <=840 and self.udalost_y>=40 and self.udalost_y<=70:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+2
                self.vykresli()
        elif self.udalost_x >=840 and self.udalost_x <=870 and self.udalost_y>=40 and self.udalost_y<=70:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+3
                self.vykresli()
        elif self.udalost_x >=870 and self.udalost_x <=900 and self.udalost_y>=40 and self.udalost_y<=70:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+4
                self.vykresli()
        elif self.udalost_x >=750 and self.udalost_x <=780 and self.udalost_y>=70 and self.udalost_y<=100:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+5
                self.vykresli()
        elif self.udalost_x >=780 and self.udalost_x <=810 and self.udalost_y>=70 and self.udalost_y<=100:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+6
                self.vykresli()
        elif self.udalost_x >=810 and self.udalost_x <=840 and self.udalost_y>=70 and self.udalost_y<=100:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+7
                self.vykresli()
        elif self.udalost_x >=840 and self.udalost_x <=870 and self.udalost_y>=70 and self.udalost_y<=100:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+8
                self.vykresli()
        elif self.udalost_x >=870 and self.udalost_x <=900 and self.udalost_y>=70 and self.udalost_y<=100:
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+9
                self.vykresli()
        #zmaz
        elif self.udalost_x >=750 and self.udalost_x <=900 and self.udalost_y>=170 and self.udalost_y<=200:
            if self.zobraz // 10 ==0:
                self.zobraz = 0
                self.vykresli()
            else:
                self.zobraz = self.zobraz//10
                self.vykresli()

        
        #pridaj prvok
        elif self.udalost_x >=750 and self.udalost_x <=900 and self.udalost_y>=210 and self.udalost_y<=240:
            self.halda.add(self.zobraz)
            if len(self.halda)==1:
                self._root = None
                self.add_root(self.zobraz)
            self.urob_strom()
            self.draw()
            self.zobraz = 0
            self.vykresli()
            
            
        #odstran najmensi prvok            
        elif self.udalost_x >=750 and self.udalost_x <=900 and self.udalost_y>=240 and self.udalost_y<=270:
            if len(self.halda) == 1:
                self.halda.remove_min()
                self.canvas.delete('all')
                self.nakresli_menu()
            else:    
                self.halda.remove_min()
                self.canvas.delete('all')
                self.nakresli_menu()
                self.urob_strom()
                self.draw()
            self.zobraz = 0
            self.vykresli()             
     
        #nacitat subor
        elif self.udalost_x >=750 and self.udalost_x <=900 and self.udalost_y>=340 and self.udalost_y<=370:
            self.nacitaj_subor('halda.txt')
            self.canvas.delete('all')
            self.nakresli_menu()
            self.urob_strom()
            self.draw()
            self.zobraz = 0
            self.vykresli()
        #zapisat subor
        elif self.udalost_x >=750 and self.udalost_x <=900 and self.udalost_y>=370 and self.udalost_y<=400:
            self.uloz_subor('halda.txt')
        #vyprazdnit strom
        elif self.udalost_x >=750 and self.udalost_x <=900 and self.udalost_y>=300 and self.udalost_y<=330:
            self.canvas.delete('all')
            self.halda._data=[]
            self._root = None
            self.nakresli_menu()
            self.zobraz = 0
            self.vykresli()
        #generuj nahodny strom
        elif self.udalost_x >=750 and self.udalost_x <=900 and self.udalost_y>=270 and self.udalost_y<=300:
            self._root=None
            self.halda._data = []
            self.add_root(0)            
            for i in range(random.randrange(1,50)):
                cislo = random.randrange(50)
                if cislo in self.halda._data:
                    pass
                else:
                    self.halda.add(cislo)
            self.canvas.delete('all')
            self.nakresli_menu()
            self.urob_strom()
            self.draw()
            self.zobraz = 0
            self.vykresli()
            

    def urob_strom(self):        
        def pridaj_vrchy(vrch, i):            
            if vrch._left is None:
                try:
                    vrch._left = self._Node(self.halda._data[2*i+1])
                except:
                    ...     
            if vrch._right is None:
                try:
                    vrch._right = self._Node(self.halda._data[2*i+2])
                except:
                    ...
                return
            
            pridaj_vrchy(vrch._left,2*i+1)
            pridaj_vrchy(vrch._right,2*i+2)
        #------------------------------------------------------------- 
        self._root = self._Node(self.halda._data[0])
        for i in range(len(self.halda)):  
            pridaj_vrchy(self._root,0)
    
    def klavesa(self, udalost):
        if udalost.keysym == '0':
            if self.zobraz == 0:
                pass
            else:
                if len(str(self.zobraz))<16:
                    self.zobraz = self.zobraz*10
                    self.vykresli()
        elif udalost.keysym == '1':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+1
                self.vykresli()
        elif udalost.keysym == '2':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+2
                self.vykresli()
        elif udalost.keysym == '3':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+3
                self.vykresli()
        elif udalost.keysym == '4':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+4
                self.vykresli()
        elif udalost.keysym == '5':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+5
                self.vykresli()
        elif udalost.keysym == '6':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+6
                self.vykresli()
        elif udalost.keysym == '7':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+7
                self.vykresli()
        elif udalost.keysym == '8':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+8
                self.vykresli()
        elif udalost.keysym == '9':
            if len(str(self.zobraz))<16:
                self.zobraz = self.zobraz*10+9
                self.vykresli()
        elif udalost.keysym == 'BackSpace':
            if self.zobraz // 10 ==0:
                self.zobraz = 0
                self.vykresli()
            else:
                self.zobraz = self.zobraz//10
                self.vykresli()
        elif udalost.keysym == 'Return':
            self.halda.add(self.zobraz)
            if len(self.halda)==1:
                self._root = None
                self.add_root(self.zobraz)
            self.urob_strom()
            self.draw()
            self.zobraz = 0
            self.vykresli()


    def vykresli(self):
        try:
            self.canvas.delete(self.id)
            #self.canvas.delete(self.id_pole)
        except:
            ...
        self.id = self.canvas.create_text(800,140,text=self.zobraz)
        #self.id_pole = self.canvas.create_text(275,370, text=self.halda._data)
        self.canvas.update()

    def nacitaj_subor(self, meno):
        self._root=None
        self.halda._data = []
        self.add_root(0)
        with open(meno,'r') as subor:
            for riadok in subor:
                pole = riadok.split()
                for znak in pole:
                    self.halda.add(int(znak))
        self.urob_strom()
        self.draw()

    def uloz_subor(self, meno):
        with open(meno,'w') as subor:
            for znak in self.halda._data:
                print(znak, file=subor,end=' ')

    def add_root(self, key, value=None):
        if self._root:
            raise ValueError('koren existuje')
        self._size = 1
        self._root = self._Node(key, value)

    def add_left(self, node, key, value=None):
        if node._left:
            raise ValueError('lavy syn existuje')
        self._size += 1
        node._left = self._Node(key, value, node)

    def add_right(self, node, key, value=None):
        if node._right:
            raise ValueError('pravy syn existuje')
        self._size += 1
        node._right = self._Node(key, value, node)

    
    def __len__(self):
        return self._size

    def is_empty(self):
        return len(self) == 0   

    def draw(self, node=None, width=None, x=None, y=None):
        if self.canvas is None:
            self.canvas = tkinter.Canvas(bg='white', width=self.canvas_width, height=600)
            self.canvas.pack()
        elif node is None:
            ...
        if node is None:
            ...
            if self.is_empty():
                return
            node = self._root
            width = 350
            if width is None: width = int(self.canvas['width'])//2
            if x is None: x = width
            if y is None: y = 30
        if node._left:
            self.canvas.create_line(x, y, x - width//2, y + 50)
            self.draw(node._left, width//2, x - width//2, y + 50)
        if node._right:
            self.canvas.create_line(x, y, x + width//2, y + 50)
            self.draw(node._right, width//2, x + width//2, y + 50)
        self.canvas.create_oval(x-15, y-15, x+15, y+15, fill='white')
        self.canvas.create_text(x, y, text=node)
        if node is self._root:
            self.canvas.update()
            self.canvas.after(300)

class Empty(Exception): pass

class HeapPriorityQueue():
    class _Item:
        def __init__(self, key):
            self.key = key

        def __lt__(self, other):
            return self.key < other.key

        def __repr__(self):
            return str((self.key))

    def __init__(self):
        self._data = []

    def __len__(self):
        return len(self._data)

    def add(self, key):
        heapq.heappush(self._data, self._Item(key))

    def min(self):
        if self.is_empty():
            raise Empty('priority queue is empty')
        item = self._data[0]
        return item.key

    def remove_min(self):
        if self.is_empty():
            raise Empty('priority queue is empty')
        item = heapq.heappop(self._data)
        return item.key
    def is_empty(self):
        return len(self) == 0



strom = BinTree()

    
