/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Level;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;

public class Main
extends Application {
    Image box = new Image("/imgs/box.bmp");
    Image boxT = new Image("/imgs/box_on_target.bmp");
    Image floor = new Image("/imgs/floor.bmp");
    Image floorT = new Image("/imgs/floor_target.bmp");
    Image pusher = new Image("/imgs/pusher.bmp");
    Image pusherT = new Image("/imgs/pusher_over_target.bmp");
    Image wall = new Image("/imgs/wall.bmp");
    Scene scene;
    BorderPane root;
    Canvas plocha;
    GraphicsContext gc;
    Level stav;
    int indexL = 1;
    double sirkaP = 40.0;
    double vyskaP = 40.0;
    Timeline casovac;
    long startCas;
    long total;
    long millis;
    long hours;
    long minutes;
    long seconds;
    MenuBar menu;
    Menu info;
    MenuItem autor;
    MenuItem ohre;
    MenuItem ovladanie;
    Menu hra;
    MenuItem undo;
    MenuItem exit;
    MenuItem load;
    MenuItem save;
    MenuItem restart;
    MenuItem fileCh;
    FileChooser file;

    public void start(Stage primaryStage) {
        primaryStage.getIcons().add((Object)new Image("/imgs/icon.png"));
        this.stav = new Level("maps/level_" + String.format("%02d", this.indexL) + ".txt");
        this.plocha = new Canvas((double)this.stav.pocetStlpcov * this.sirkaP, (double)this.stav.pocetRiadkov * this.vyskaP);
        this.gc = this.plocha.getGraphicsContext2D();
        this.plocha.setFocusTraversable(true);
        this.casovac = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1.0), e -> {
            this.total = System.currentTimeMillis() - this.startCas;
            this.millis = System.currentTimeMillis() - this.startCas;
            this.hours = this.millis / 3600000L;
            this.millis -= this.hours * 3600000L;
            this.minutes = this.millis / 60000L;
            this.millis -= this.minutes * 60000L;
            this.seconds = this.millis / 1000L;
            this.millis -= this.seconds * 1000L;
        }, new KeyValue[0])});
        this.casovac.setCycleCount(-1);
        this.startCas = System.currentTimeMillis();
        this.casovac.play();
        this.info = new Menu("Info");
        this.ohre = new MenuItem("About");
        this.ohre.setOnAction(e -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("About");
            alert.setHeaderText(null);
            alert.setContentText("Push all boxes onto the targets to win.");
            alert.showAndWait();
        });
        this.ovladanie = new MenuItem("Controls");
        this.ovladanie.setOnAction(e -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Controls");
            alert.setHeaderText(null);
            alert.setContentText("Use arrows on keyboard to move around.");
            alert.showAndWait();
        });
        this.autor = new MenuItem("Author");
        this.autor.setOnAction(e -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Author");
            alert.setHeaderText(null);
            alert.setContentText("Created by: Michal Pazmany\nVersion 1.0\nJune 2018");
            alert.showAndWait();
        });
        this.info.getItems().addAll((Object[])new MenuItem[]{this.ohre, this.ovladanie, this.autor});
        this.hra = new Menu("Game");
        this.menu = new MenuBar();
        this.file = new FileChooser();
        this.fileCh = new MenuItem("Choose level");
        this.fileCh.setOnAction(e -> {
            Object[] choices = new String[75];
            int i = 1;
            while (i <= 75) {
                choices[i - 1] = String.format("level_%02d", i);
                ++i;
            }
            ChoiceDialog dialog = new ChoiceDialog(null, choices);
            dialog.initOwner((Window)primaryStage);
            dialog.setTitle("Sokoban");
            dialog.setHeaderText("Choose level");
            Optional result = dialog.showAndWait();
            if (result.isPresent()) {
                String level = (String)result.get();
                this.sirkaP = 40.0;
                this.vyskaP = 40.0;
                this.stav = new Level("maps/" + level + ".txt");
                primaryStage.setTitle("Sokoban: " + level);
                this.indexL = Integer.parseInt(level.substring(6, 8));
                this.startCas = System.currentTimeMillis();
                this.casovac.play();
                this.plocha.setWidth((double)this.stav.pocetStlpcov * this.sirkaP);
                this.plocha.setHeight((double)this.stav.pocetRiadkov * this.vyskaP);
                primaryStage.setWidth((double)this.stav.pocetStlpcov * this.sirkaP + 16.0);
                primaryStage.setHeight((double)this.stav.pocetRiadkov * this.vyskaP + 39.0 + 25.0);
                this.paint();
            }
        });
        this.restart = new MenuItem("Restart level");
        this.restart.setOnAction(e -> {
            this.stav = new Level("maps/level_" + String.format("%02d", this.indexL) + ".txt");
            primaryStage.setTitle("Sokoban: level_" + String.format("%02d", this.indexL));
            this.plocha.setWidth((double)this.stav.pocetStlpcov * this.sirkaP);
            this.plocha.setHeight((double)this.stav.pocetRiadkov * this.vyskaP);
            this.startCas = System.currentTimeMillis();
            this.casovac.play();
            primaryStage.setWidth((double)this.stav.pocetStlpcov * this.sirkaP + 16.0);
            primaryStage.setHeight((double)this.stav.pocetRiadkov * this.vyskaP + 39.0 + 25.0);
            this.paint();
        });
        this.undo = new MenuItem("Undo");
        this.undo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.undo.setOnAction(e -> {
            if (this.stav.pamat.size() > 1) {
                this.stav.pamat.remove(this.stav.pamat.size() - 1);
                int i = 0;
                while (i < this.stav.mriezka.length) {
                    int j = 0;
                    while (j < this.stav.mriezka[i].length) {
                        this.stav.mriezka[i][j] = this.stav.pamat.get(this.stav.pamat.size() - 1)[i][j];
                        if (this.stav.mriezka[i][j] == '@' || this.stav.mriezka[i][j] == '+') {
                            this.stav.px = j;
                            this.stav.py = i;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.paint();
            }
        });
        this.exit = new MenuItem("Exit");
        this.exit.setOnAction(e -> System.exit(0));
        this.save = new MenuItem("Save game");
        this.save.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.save.setOnAction(e -> {
            this.stav.cas = this.total;
            this.stav.indexL = this.indexL;
            this.stav.save("ulozena_hra.txt");
        });
        this.load = new MenuItem("Load game");
        this.load.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.load.setOnAction(e -> {
            this.stav = Level.load("ulozena_hra.txt");
            this.indexL = this.stav.indexL;
            primaryStage.setTitle("Sokoban: level_" + String.format("%02d", this.indexL));
            this.startCas = System.currentTimeMillis() - this.stav.cas;
            this.sirkaP = 40.0;
            this.vyskaP = 40.0;
            this.plocha.setWidth((double)this.stav.pocetStlpcov * this.sirkaP);
            this.plocha.setHeight((double)this.stav.pocetRiadkov * this.vyskaP);
            primaryStage.setWidth((double)this.stav.pocetStlpcov * this.sirkaP + 16.0);
            primaryStage.setHeight((double)this.stav.pocetRiadkov * this.vyskaP + 39.0 + 25.0);
            this.casovac.play();
            this.paint();
        });
        this.hra.getItems().addAll((Object[])new MenuItem[]{this.undo, this.restart, this.save, this.load, this.fileCh, this.exit});
        this.menu.getMenus().addAll((Object[])new Menu[]{this.hra, this.info});
        this.root = new BorderPane();
        this.plocha.setFocusTraversable(true);
        this.root.setTop((Node)this.menu);
        this.root.setCenter((Node)this.plocha);
        this.scene = new Scene((Parent)this.root, this.plocha.getWidth(), this.plocha.getHeight() + 25.0);
        this.scene.widthProperty().addListener(ov -> {
            this.plocha.setWidth(this.scene.getWidth());
            this.sirkaP = this.plocha.getWidth() / (double)this.stav.pocetStlpcov;
            this.paint();
        });
        this.scene.heightProperty().addListener(ov -> {
            this.plocha.setHeight(this.scene.getHeight() - this.menu.getHeight());
            this.vyskaP = this.plocha.getHeight() / (double)this.stav.pocetRiadkov;
            this.paint();
        });
        this.scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("application.css").toExternalForm());
        primaryStage.setScene(this.scene);
        primaryStage.setTitle("Sokoban: level_" + String.format("%02d", this.indexL));
        primaryStage.show();
        primaryStage.setMinHeight(125.0);
        primaryStage.setMinWidth(100.0);
        this.plocha.setHeight(this.scene.getHeight() - 25.0);
        this.paint();
        this.plocha.requestFocus();
        this.plocha.setOnKeyPressed(e -> {
            char[][] kopia;
            if (e.getCode() == KeyCode.UP) {
                this.move('u');
                kopia = this.skopiruj(this.stav.mriezka);
                this.stav.pamat.add(kopia);
            } else if (e.getCode() == KeyCode.DOWN) {
                this.move('d');
                kopia = this.skopiruj(this.stav.mriezka);
                this.stav.pamat.add(kopia);
            } else if (e.getCode() == KeyCode.LEFT) {
                this.move('l');
                kopia = this.skopiruj(this.stav.mriezka);
                this.stav.pamat.add(kopia);
            } else if (e.getCode() == KeyCode.RIGHT) {
                this.move('r');
                kopia = this.skopiruj(this.stav.mriezka);
                this.stav.pamat.add(kopia);
            }
            if (this.vyhra()) {
                this.paint();
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Sokoban");
                alert.setHeaderText(null);
                alert.setContentText("You won!\n\nNumber of steps: " + this.stav.pamat.size() + "\nTime: " + String.format("%02d", this.minutes) + ":" + String.format("%02d", this.seconds));
                this.casovac.stop();
                alert.showAndWait();
                ++this.indexL;
                this.sirkaP = 40.0;
                this.vyskaP = 40.0;
                this.stav = new Level("maps/level_" + String.format("%02d", this.indexL) + ".txt");
                this.plocha.setWidth((double)this.stav.pocetStlpcov * this.sirkaP);
                this.plocha.setHeight((double)(this.stav.pocetRiadkov + 1) * this.vyskaP);
                this.startCas = System.currentTimeMillis();
                this.casovac.play();
                primaryStage.setTitle("Sokoban: level_" + String.format("%02d", this.indexL));
                primaryStage.setWidth(this.plocha.getWidth() + 16.0);
                primaryStage.setHeight(this.plocha.getHeight() + 25.0);
            }
            this.paint();
        });
    }

    char[][] skopiruj(char[][] mriezka) {
        char[][] kopia = new char[mriezka.length][mriezka[0].length];
        int i = 0;
        while (i < mriezka.length) {
            int j = 0;
            while (j < mriezka[i].length) {
                kopia[i][j] = mriezka[i][j];
                ++j;
            }
            ++i;
        }
        return kopia;
    }

    void paint() {
        this.gc.clearRect(0.0, 0.0, this.plocha.getWidth(), this.plocha.getHeight());
        int r = 0;
        while (r < this.stav.pocetRiadkov) {
            int s = 0;
            while (s < this.stav.pocetStlpcov) {
                if (this.stav.mriezka[r][s] == ' ') {
                    this.gc.drawImage(this.floor, (double)s * this.sirkaP, (double)r * this.vyskaP, this.sirkaP, this.vyskaP);
                } else if (this.stav.mriezka[r][s] == '#') {
                    this.gc.drawImage(this.wall, (double)s * this.sirkaP, (double)r * this.vyskaP, this.sirkaP, this.vyskaP);
                } else if (this.stav.mriezka[r][s] == '.') {
                    this.gc.drawImage(this.floorT, (double)s * this.sirkaP, (double)r * this.vyskaP, this.sirkaP, this.vyskaP);
                } else if (this.stav.mriezka[r][s] == '@') {
                    this.gc.drawImage(this.pusher, (double)s * this.sirkaP, (double)r * this.vyskaP, this.sirkaP, this.vyskaP);
                } else if (this.stav.mriezka[r][s] == '+') {
                    this.gc.drawImage(this.pusherT, (double)s * this.sirkaP, (double)r * this.vyskaP, this.sirkaP, this.vyskaP);
                } else if (this.stav.mriezka[r][s] == '$') {
                    this.gc.drawImage(this.boxT, (double)s * this.sirkaP, (double)r * this.vyskaP, this.sirkaP, this.vyskaP);
                } else if (this.stav.mriezka[r][s] == '*') {
                    this.gc.drawImage(this.box, (double)s * this.sirkaP, (double)r * this.vyskaP, this.sirkaP, this.vyskaP);
                }
                ++s;
            }
            ++r;
        }
    }

    boolean vyhra() {
        int r = 0;
        while (r < this.stav.pocetRiadkov) {
            int s = 0;
            while (s < this.stav.pocetStlpcov) {
                if (this.stav.mriezka[r][s] == '.' || this.stav.mriezka[r][s] == '+') {
                    return false;
                }
                ++s;
            }
            ++r;
        }
        return true;
    }

    void move(char znak) {
        if (this.stav.px > 0 && this.stav.px < this.stav.pocetStlpcov - 1 && this.stav.py > 0 && this.stav.py < this.stav.pocetRiadkov) {
            if (znak == 'u') {
                if (this.stav.mriezka[this.stav.py][this.stav.px] == '@') {
                    if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == ' ') {
                        this.stav.mriezka[this.stav.py - 1][this.stav.px] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        --this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '.') {
                        this.stav.mriezka[this.stav.py - 1][this.stav.px] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        --this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '#') {
                        return;
                    }
                    if (this.stav.py > 1) {
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '*') {
                            return;
                        }
                    }
                } else if (this.stav.mriezka[this.stav.py][this.stav.px] == '+') {
                    if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == ' ') {
                        this.stav.mriezka[this.stav.py - 1][this.stav.px] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        --this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '.') {
                        this.stav.mriezka[this.stav.py - 1][this.stav.px] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        --this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '#') {
                        return;
                    }
                    if (this.stav.py > 1) {
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py - 2][this.stav.px] == '*') {
                            return;
                        }
                    }
                }
            } else if (znak == 'd') {
                if (this.stav.mriezka[this.stav.py][this.stav.px] == '@') {
                    if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == ' ') {
                        this.stav.mriezka[this.stav.py + 1][this.stav.px] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        ++this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '.') {
                        this.stav.mriezka[this.stav.py + 1][this.stav.px] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        ++this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '#') {
                        return;
                    }
                    if (this.stav.py < this.stav.pocetRiadkov - 2) {
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py + 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py + 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py + 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py + 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py + 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py + 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py + 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py + 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '*') {
                            return;
                        }
                    }
                } else if (this.stav.mriezka[this.stav.py][this.stav.px] == '+') {
                    if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == ' ') {
                        this.stav.mriezka[this.stav.py + 1][this.stav.px] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        ++this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '.') {
                        this.stav.mriezka[this.stav.py + 1][this.stav.px] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        ++this.stav.py;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '#') {
                        return;
                    }
                    if (this.stav.py < this.stav.pocetRiadkov - 2) {
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py + 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py + 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py + 1][this.stav.px] = 64;
                            this.stav.mriezka[this.stav.py + 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '$' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '.') {
                            this.stav.mriezka[this.stav.py + 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py + 2][this.stav.px] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py - 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == ' ') {
                            this.stav.mriezka[this.stav.py - 1][this.stav.px] = 43;
                            this.stav.mriezka[this.stav.py - 2][this.stav.px] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.py;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py + 1][this.stav.px] == '*' && this.stav.mriezka[this.stav.py + 2][this.stav.px] == '*') {
                            return;
                        }
                    }
                }
            } else if (znak == 'l') {
                if (this.stav.mriezka[this.stav.py][this.stav.px] == '@') {
                    if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == ' ') {
                        this.stav.mriezka[this.stav.py][this.stav.px - 1] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        --this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '.') {
                        this.stav.mriezka[this.stav.py][this.stav.px - 1] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        --this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '#') {
                        return;
                    }
                    if (this.stav.px > 1) {
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '*') {
                            return;
                        }
                    }
                } else if (this.stav.mriezka[this.stav.py][this.stav.px] == '+') {
                    if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == ' ') {
                        this.stav.mriezka[this.stav.py][this.stav.px - 1] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        --this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '.') {
                        this.stav.mriezka[this.stav.py][this.stav.px - 1] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        --this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '#') {
                        return;
                    }
                    if (this.stav.px > 1) {
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px - 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px - 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            --this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px - 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px - 2] == '*') {
                            return;
                        }
                    }
                }
            } else if (znak == 'r') {
                if (this.stav.mriezka[this.stav.py][this.stav.px] == '@') {
                    if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == ' ') {
                        this.stav.mriezka[this.stav.py][this.stav.px + 1] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        ++this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '.') {
                        this.stav.mriezka[this.stav.py][this.stav.px + 1] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                        ++this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '#') {
                        return;
                    }
                    if (this.stav.px < this.stav.pocetStlpcov - 2) {
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 32;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '*') {
                            return;
                        }
                    }
                } else if (this.stav.mriezka[this.stav.py][this.stav.px] == '+') {
                    if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == ' ') {
                        this.stav.mriezka[this.stav.py][this.stav.px + 1] = 64;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        ++this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '.') {
                        this.stav.mriezka[this.stav.py][this.stav.px + 1] = 43;
                        this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                        ++this.stav.px;
                        return;
                    }
                    if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '#') {
                        return;
                    }
                    if (this.stav.px < this.stav.pocetStlpcov - 2) {
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 64;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '$' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '*') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '.') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 42;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == ' ') {
                            this.stav.mriezka[this.stav.py][this.stav.px + 1] = 43;
                            this.stav.mriezka[this.stav.py][this.stav.px + 2] = 36;
                            this.stav.mriezka[this.stav.py][this.stav.px] = 46;
                            ++this.stav.px;
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '#') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '$') {
                            return;
                        }
                        if (this.stav.mriezka[this.stav.py][this.stav.px + 1] == '*' && this.stav.mriezka[this.stav.py][this.stav.px + 2] == '*') {
                            return;
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

