package application;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Michal Pazmany
 * @version 1.0
 *
 */
public class Level implements Serializable {
	/**
	 * Cas trvania levelu v milisekundach.
	 */
	long cas;
	/**
	 * Dvojrozmerne pole znakov uchovavajuce stav hry.
	 */
	char[][] mriezka;
	/**
	 * Pocet riadkov levelu.
	 */
	int pocetRiadkov;
	/**
	 * Pocet stlpcov levelu.
	 */
	int pocetStlpcov;
	/**
	 * X-ova pozicia pushera v mriezke.
	 */
	int px;
	/**
	 * Y-ova pozicia pushera v mriezke.
	 */
	int py;
	/**
	 * Index levelu, teda cislo levelu.
	 */
	int indexL;
	/**
	 * Pole dvojrozmernych poli znakov na uchovavanie mriezok ako jednotlivych tahov hry.
	 */
	List<char[][]> pamat = new ArrayList<>();

	/**
	 * Vytvori dvojrozmerne pole znakov naplnene medzerami.
	 * @param vyska Vyska pola.
	 * @param sirka Sirka pola.
	 */
	public void inicializujMriezku(int vyska, int sirka) {
		mriezka = new char[vyska][sirka];
		for (int i = 0; i < vyska; i++) {
			for (int j = 0; j < sirka; j++) {
				mriezka[i][j] = ' ';
			}
		}
	}

	/**
	 * Konstruktor prekopiruje vstupne dvojrozmerne pole do mriezky objektu.
	 * @param mriezka Vstupne dvojrozmerne pole.
	 */
	public Level(char[][] mriezka) {

		for (int i = 0; i < mriezka.length; i++) {
			for (int j = 0; j < mriezka[i].length; j++) {
				this.mriezka[i][j] = mriezka[i][j];
			}
		}
	}

	/**
	 * Konstruktor, ktory nacita subor do dvojrozmerneho pola mriezka a prida do pamate zaciatocny stav.
	 * @param filePath Cesta k suboru.
	 */
	public Level(String filePath) {
		pocetRiadkov = 0;
		pocetStlpcov = 0;

		try (BufferedReader in = new BufferedReader(new InputStreamReader(getClass().getResourceAsStream("/" + filePath)))) {
			String read = null;

			while ((read = in.readLine()) != null) {
				if (read.length() > pocetStlpcov) {
					pocetStlpcov = read.length();
				}
				pocetRiadkov++;
			}
		} catch (IOException e) {
			// System.out.println("There was a problem: " + e);
			e.printStackTrace();
		}

		inicializujMriezku(pocetRiadkov, pocetStlpcov);
		try (BufferedReader in = new BufferedReader(new InputStreamReader(getClass().getResourceAsStream("/" + filePath)))) {
			int index = 0;
			String read = null;

			while ((read = in.readLine()) != null) {
				for (int i = 0; i < read.length(); i++) {
					mriezka[index][i] = read.charAt(i);
					if (read.charAt(i) == '@' || read.charAt(i) == '+') {
						py = index;
						px = i;
					}
				}
				index++;
			}
		} catch (IOException e) {
			// System.out.println("There was a problem: " + e);
			e.printStackTrace();
		}
		char[][] kopia = new char[mriezka.length][mriezka[0].length];
		for (int i = 0; i < mriezka.length; i++) {
			for (int j = 0; j < mriezka[i].length; j++) {
				kopia[i][j] = mriezka[i][j];
			}
		}
		pamat.add(kopia);
	}

	/**
	 * Nacita a vrati ulozeny objekt.
	 * @param filePath Cesta k suboru s ulozenym objektom.
	 * @return Vrati level.
	 */
	public static Level load(String filePath) {
		File f = new File(filePath);
		ObjectInputStream os = null;
		Level level = null;
		try {
			os = new ObjectInputStream(new FileInputStream(f));
			level = (Level) os.readObject();
		} catch (IOException | ClassNotFoundException e) {
			e.printStackTrace();
		}

		return level;
	}

	/**
	 * Ulozi level ako objekt do suboru.
	 * @param filePath Cesta k suboru, do ktoreho chceme ulozit level.
	 */
	public void save(String filePath) {
		File f = new File(filePath);
		ObjectOutputStream os = null;
		try {
			os = new ObjectOutputStream(new FileOutputStream(f));
			os.writeObject(this);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
