package application;

import java.util.Optional;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Duration;

/**
 * @author Michal Pazmany
 * @version 1.0
 *
 */
public class Main extends Application {

	/**
	 * Obrazok krabice.
	 */
	Image box = new Image("/imgs/box.bmp");
	/**
	 * Obrazok krabice na cieli.
	 */
	Image boxT = new Image("/imgs/box_on_target.bmp");
	/**
	 * Obrazok podlahy.
	 */
	Image floor = new Image("/imgs/floor.bmp");
	/**
	 * Obrazok podlahy s cielom.
	 */
	Image floorT = new Image("/imgs/floor_target.bmp");
	/**
	 * Obrazok pushera(skladnika).
	 */
	Image pusher = new Image("/imgs/pusher.bmp");
	/**
	 * Obrazok pushera(skladnika) na cieli.
	 */
	Image pusherT = new Image("/imgs/pusher_over_target.bmp");
	/**
	 * Obrazok steny.
	 */
	Image wall = new Image("/imgs/wall.bmp");

	/**
	 * Scena.
	 */
	Scene scene;
	/**
	 * Okraj plochy.
	 */
	BorderPane root;
	/**
	 * Plocha na vykreslovanie.
	 */
	Canvas plocha;
	/**
	 * Graficky kontext plochy na vykreslovanie.
	 */
	GraphicsContext gc;
	/**
	 * Stav hry.
	 */
	Level stav;
	/**
	 * Index levelu, mapy.
	 */
	int indexL = 1;
	/**
	 * Sirka policka na vykreslenie.
	 */
	double sirkaP = 40;
	/**
	 * Vyska policka na vykreslenie.
	 */
	double vyskaP = 40;

	/**
	 * Casovac hry.
	 */
	Timeline casovac;
	/**
	 * Zaciatocny cas levelu v milisekundach.
	 */
	long startCas;
	/**
	 * Celkovy cas levelu v milisekundach.
	 */
	long total;
	/**
	 * Pocet milisekund na ratanie casu.
	 */
	long millis;
	/**
	 * Pocet hodin na ratanie casu.
	 */
	long hours;
	/**
	 * Pocet minut na ratanie casu.
	 */
	long minutes;
	/**
	 * Pocet sekund na ratanie casu.
	 */
	long seconds;

	/**
	 * Plocha s menu.
	 */
	MenuBar menu;

	/**
	 * Menu s informaciami.
	 */
	Menu info;
	/**
	 * Informacia o autorovi v menu.
	 */
	MenuItem autor;
	/**
	 * Informacia o hre v menu.
	 */
	MenuItem ohre;
	/**
	 * Informacia o ovladani v menu.
	 */
	MenuItem ovladanie;

	/**
	 * Menu s ovladanim hry.
	 */
	Menu hra;
	/**
	 * Tlacidlo v menu na vratenie posledneho tahu.
	 */
	MenuItem undo;
	/**
	 * Tlacidlo v menu na ukoncenie hry.
	 */
	MenuItem exit;
	/**
	 * Tlacidlo v menu na nacitanie ulozenej hry.
	 */
	MenuItem load;
	/**
	 * Tlacidlo v menu na ulozenie hry.
	 */
	MenuItem save;
	/**
	 * Tlacidlo v menu na restartovanie levelu.
	 */
	MenuItem restart;
	/**
	 * Tlacidlo v menu na vyber levelu(mapy).
	 */
	MenuItem fileCh;
	/**
	 * Vybera level.
	 */
	FileChooser file;

	/* (non-Javadoc)
	 * Inicializacia celej hry na zaciatku. Odchytavanie udalosti na ploche
	 *  a klavesnici a riadenie celej hry. 
	 * @see javafx.application.Application#start(javafx.stage.Stage)
	 */
	@Override
	public void start(Stage primaryStage) {
		primaryStage.getIcons().add(new Image("/imgs/icon.png"));
		stav = new Level("maps/level_" + String.format("%02d", indexL) + ".txt");
		plocha = new Canvas(stav.pocetStlpcov * sirkaP, stav.pocetRiadkov * vyskaP);
		gc = plocha.getGraphicsContext2D();
		plocha.setFocusTraversable(true);

		casovac = new Timeline(new KeyFrame(Duration.millis(1), e -> {
			total = System.currentTimeMillis() - startCas;
			millis = System.currentTimeMillis() - startCas;
			hours = millis / (1000 * 60 * 60);
			millis -= hours * (1000 * 60 * 60);
			minutes = millis / (1000 * 60);
			millis -= minutes * (1000 * 60);
			seconds = millis / 1000;
			millis -= seconds * 1000;
		}));

		casovac.setCycleCount(Timeline.INDEFINITE);
		startCas = System.currentTimeMillis();
		casovac.play();

		info = new Menu("Info");

		ohre = new MenuItem("About");
		ohre.setOnAction(e -> {
			Alert alert = new Alert(AlertType.INFORMATION);
			alert.setTitle("About");
			alert.setHeaderText(null);
			alert.setContentText("Push all boxes onto the targets to win.");
			alert.showAndWait();
		});
		ovladanie = new MenuItem("Controls");
		ovladanie.setOnAction(e -> {
			Alert alert = new Alert(AlertType.INFORMATION);
			alert.setTitle("Controls");
			alert.setHeaderText(null);
			alert.setContentText("Use arrows on keyboard to move around.");
			alert.showAndWait();
		});
		autor = new MenuItem("Author");
		autor.setOnAction(e -> {
			Alert alert = new Alert(AlertType.INFORMATION);
			alert.setTitle("Author");
			alert.setHeaderText(null);
			alert.setContentText("Created by: Michal Pazmany\nVersion 1.0\nJune 2018");
			alert.showAndWait();
		});
		info.getItems().addAll(ohre, ovladanie, autor);

		hra = new Menu("Game");
		menu = new MenuBar();
		file = new FileChooser();
		fileCh = new MenuItem("Choose level");
		fileCh.setOnAction(e -> {
			String[] choices = new String[75];
			for (int i = 1; i <= 75; ++i) {
				choices[i - 1] = String.format("level_%02d", i);
			}

			ChoiceDialog<String> dialog = new ChoiceDialog<>(null, choices);
			dialog.initOwner(primaryStage);
			dialog.setTitle("Sokoban");
			dialog.setHeaderText("Choose level");

			Optional<String> result = dialog.showAndWait();
			if (result.isPresent()) {
				String level = result.get();
				sirkaP = 40;
				vyskaP = 40;

				stav = new Level("maps/" + level + ".txt");
				primaryStage.setTitle("Sokoban: " + level);
				indexL = Integer.parseInt(level.substring(6, 8));
				startCas = System.currentTimeMillis();
				casovac.play();

				plocha.setWidth((stav.pocetStlpcov) * sirkaP);
				plocha.setHeight((stav.pocetRiadkov) * vyskaP);
				primaryStage.setWidth((stav.pocetStlpcov) * sirkaP + 16);
				primaryStage.setHeight((stav.pocetRiadkov) * vyskaP + 39 + 25);
				paint();
			}

		});

		restart = new MenuItem("Restart level");
		restart.setOnAction(e -> {
			stav = new Level("maps/level_" + String.format("%02d", indexL) + ".txt");
			primaryStage.setTitle("Sokoban: level_" + String.format("%02d", indexL));
			plocha.setWidth((stav.pocetStlpcov) * sirkaP);
			plocha.setHeight((stav.pocetRiadkov) * vyskaP);
			startCas = System.currentTimeMillis();
			casovac.play();
			primaryStage.setWidth((stav.pocetStlpcov) * sirkaP + 16);
			primaryStage.setHeight((stav.pocetRiadkov) * vyskaP + 39 + 25);
			paint();

		});

		undo = new MenuItem("Undo");
		undo.setAccelerator(new KeyCodeCombination(KeyCode.U, KeyCombination.CONTROL_DOWN));
		undo.setOnAction(e -> {
			if (stav.pamat.size() > 1) {
				stav.pamat.remove(stav.pamat.size() - 1);
				for (int i = 0; i < stav.mriezka.length; i++) {
					for (int j = 0; j < stav.mriezka[i].length; j++) {
						stav.mriezka[i][j] = stav.pamat.get(stav.pamat.size() - 1)[i][j];
						if (stav.mriezka[i][j] == '@'|| stav.mriezka[i][j]=='+') {
							stav.px = j;
							stav.py = i;
						}
					}
				}
				paint();
			}
		});

		exit = new MenuItem("Exit");
		exit.setOnAction(e -> {
			System.exit(0);
		});
		save = new MenuItem("Save game");
		save.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.CONTROL_DOWN));
		save.setOnAction(e -> {
			stav.cas = total;
			stav.indexL = indexL;
			stav.save("ulozena_hra.txt");
		});
		load = new MenuItem("Load game");
		load.setAccelerator(new KeyCodeCombination(KeyCode.L, KeyCombination.CONTROL_DOWN));
		load.setOnAction(e -> {

			stav = stav.load("ulozena_hra.txt");
			indexL = stav.indexL;
			primaryStage.setTitle("Sokoban: level_" + String.format("%02d", indexL));
			startCas = System.currentTimeMillis() - stav.cas;
			sirkaP = 40;
			vyskaP = 40;
			plocha.setWidth((stav.pocetStlpcov) * sirkaP);
			plocha.setHeight((stav.pocetRiadkov) * vyskaP);
			primaryStage.setWidth((stav.pocetStlpcov) * sirkaP + 16);
			primaryStage.setHeight((stav.pocetRiadkov) * vyskaP + 39 + 25);
			casovac.play();
			paint();
		});
		hra.getItems().addAll(undo, restart, save, load, fileCh, exit);
		menu.getMenus().addAll(hra, info);
		root = new BorderPane();
		plocha.setFocusTraversable(true);
		root.setTop(menu);
		root.setCenter(plocha);
		scene = new Scene(root, plocha.getWidth(), plocha.getHeight() + 25);

		scene.widthProperty().addListener(ov -> {
			plocha.setWidth(scene.getWidth());
			sirkaP = (plocha.getWidth() / stav.pocetStlpcov);
			paint();

		});

		scene.heightProperty().addListener(ov -> {
			plocha.setHeight(scene.getHeight() - menu.getHeight());
			vyskaP = (plocha.getHeight() / stav.pocetRiadkov);
			paint();

		});

		scene.getStylesheets().add(getClass().getResource("application.css").toExternalForm());
		primaryStage.setScene(scene);

		primaryStage.setTitle("Sokoban: level_" + String.format("%02d", indexL));
		primaryStage.show();
		primaryStage.setMinHeight(125);
		primaryStage.setMinWidth(100);
		plocha.setHeight(scene.getHeight() - 25);
		paint();

		plocha.requestFocus();
		plocha.setOnKeyPressed(e -> {
			if (e.getCode() == KeyCode.UP) {
				move('u');
				char[][] kopia = skopiruj(stav.mriezka);
				stav.pamat.add(kopia);
			} else if (e.getCode() == KeyCode.DOWN) {
				move('d');
				char[][] kopia = skopiruj(stav.mriezka);
				stav.pamat.add(kopia);
			} else if (e.getCode() == KeyCode.LEFT) {
				move('l');
				char[][] kopia = skopiruj(stav.mriezka);
				stav.pamat.add(kopia);
			} else if (e.getCode() == KeyCode.RIGHT) {
				move('r');
				char[][] kopia = skopiruj(stav.mriezka);
				stav.pamat.add(kopia);
			}

			if (vyhra()) {
				paint();
				Alert alert = new Alert(AlertType.INFORMATION);
				alert.setTitle("Sokoban");
				alert.setHeaderText(null);
				alert.setContentText("You won!\n\nNumber of steps: " + stav.pamat.size() + "\nTime: " + String.format("%02d", minutes) + ":"
						+ String.format("%02d", seconds));
				casovac.stop();
				alert.showAndWait();
				indexL++;
				sirkaP = 40;
				vyskaP = 40;
				stav = new Level("maps/level_" + String.format("%02d", indexL) + ".txt");
				plocha.setWidth((stav.pocetStlpcov) * sirkaP);
				plocha.setHeight((stav.pocetRiadkov + 1) * vyskaP);
				startCas = System.currentTimeMillis();
				casovac.play();
				primaryStage.setTitle("Sokoban: level_" + String.format("%02d", indexL));

				primaryStage.setWidth(plocha.getWidth() + 16);
				primaryStage.setHeight(plocha.getHeight() + 25);

			}
			;
			paint();
		});

	}

	/**
	 * Kopiruje vstupne dvojrozmerne pole znakov do noveho pola a vrati novoskopirovane pole.
	 * @param mriezka Vstupne dvojrozmerne pole znakov.
	 * @return Vrati nove dvojrozmerne pole znakov.
	 */
	char[][] skopiruj(char[][] mriezka) {
		char[][] kopia = new char[mriezka.length][mriezka[0].length];
		for (int i = 0; i < mriezka.length; i++) {
			for (int j = 0; j < mriezka[i].length; j++) {
				kopia[i][j] = mriezka[i][j];

			}
		}
		return kopia;
	}

	/**
	 * Kresli Hraciu plochu.
	 */
	void paint() {
		gc.clearRect(0, 0, plocha.getWidth(), plocha.getHeight());
		for (int r = 0; r < stav.pocetRiadkov; r++) {
			for (int s = 0; s < stav.pocetStlpcov; s++) {
				if (stav.mriezka[r][s] == ' ') {
					gc.drawImage(floor, s * sirkaP, r * vyskaP, sirkaP, vyskaP);
				} else if (stav.mriezka[r][s] == '#') {
					gc.drawImage(wall, s * sirkaP, r * vyskaP, sirkaP, vyskaP);
				} else if (stav.mriezka[r][s] == '.') {
					gc.drawImage(floorT, s * sirkaP, r * vyskaP, sirkaP, vyskaP);
				} else if (stav.mriezka[r][s] == '@') {
					gc.drawImage(pusher, s * sirkaP, r * vyskaP, sirkaP, vyskaP);
				} else if (stav.mriezka[r][s] == '+') {
					gc.drawImage(pusherT, s * sirkaP, r * vyskaP, sirkaP, vyskaP);
				} else if (stav.mriezka[r][s] == '$') {
					gc.drawImage(boxT, s * sirkaP, r * vyskaP, sirkaP, vyskaP);
				} else if (stav.mriezka[r][s] == '*') {
					gc.drawImage(box, s * sirkaP, r * vyskaP, sirkaP, vyskaP);
				}
			}
		}

	}

	/**
	 * Kontroluje ci su vsetky krabice na cieli. Ak ano, vrati true, inak false.
	 * @return Vracia true, alebo false podla stavu hry.
	 */
	boolean vyhra() {
		for (int r = 0; r < stav.pocetRiadkov; r++) {
			for (int s = 0; s < stav.pocetStlpcov; s++) {
				if (stav.mriezka[r][s] == '.' || stav.mriezka[r][s] == '+') {
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * Kontrola pohybu a nasledne menenie mriezky. Teoreticky cela logika hry.
	 * @param znak Vstupny znak ucrujuci smer pohybu.
	 */
	void move(char znak) {
		if (stav.px > 0 && stav.px < stav.pocetStlpcov - 1 && stav.py > 0 && stav.py < stav.pocetRiadkov) {
			if (znak == 'u') {
				if (stav.mriezka[stav.py][stav.px] == '@') {
					if (stav.mriezka[stav.py - 1][stav.px] == ' ') {
						stav.mriezka[stav.py - 1][stav.px] = '@';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.py--;
						return;
					} else if (stav.mriezka[stav.py - 1][stav.px] == '.') {
						stav.mriezka[stav.py - 1][stav.px] = '+';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.py--;
						return;
					} else if (stav.mriezka[stav.py - 1][stav.px] == '#') {
						return;
					} else if (stav.py > 1) {
						if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '.') {
							stav.mriezka[stav.py - 1][stav.px] = '@';
							stav.mriezka[stav.py - 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == ' ') {
							stav.mriezka[stav.py - 1][stav.px] = '@';
							stav.mriezka[stav.py - 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '*') {
							return;
						}
						if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '.') {
							stav.mriezka[stav.py - 1][stav.px] = '+';
							stav.mriezka[stav.py - 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == ' ') {
							stav.mriezka[stav.py - 1][stav.px] = '+';
							stav.mriezka[stav.py - 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '*') {
							return;
						}
					}

				} else if (stav.mriezka[stav.py][stav.px] == '+') {
					if (stav.mriezka[stav.py - 1][stav.px] == ' ') {
						stav.mriezka[stav.py - 1][stav.px] = '@';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.py--;
						return;
					} else if (stav.mriezka[stav.py - 1][stav.px] == '.') {
						stav.mriezka[stav.py - 1][stav.px] = '+';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.py--;
						return;
					} else if (stav.mriezka[stav.py - 1][stav.px] == '#') {
						return;
					} else if (stav.py > 1) {
						if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '.') {
							stav.mriezka[stav.py - 1][stav.px] = '@';
							stav.mriezka[stav.py - 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == ' ') {
							stav.mriezka[stav.py - 1][stav.px] = '@';
							stav.mriezka[stav.py - 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '$' && stav.mriezka[stav.py - 2][stav.px] == '*') {
							return;
						}
						if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '.') {
							stav.mriezka[stav.py - 1][stav.px] = '+';
							stav.mriezka[stav.py - 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == ' ') {
							stav.mriezka[stav.py - 1][stav.px] = '+';
							stav.mriezka[stav.py - 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py--;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py - 2][stav.px] == '*') {
							return;
						}
					}

				}
			} else if (znak == 'd') {
				if (stav.mriezka[stav.py][stav.px] == '@') {
					if (stav.mriezka[stav.py + 1][stav.px] == ' ') {
						stav.mriezka[stav.py + 1][stav.px] = '@';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.py++;
						return;
					} else if (stav.mriezka[stav.py + 1][stav.px] == '.') {
						stav.mriezka[stav.py + 1][stav.px] = '+';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.py++;
						return;
					} else if (stav.mriezka[stav.py + 1][stav.px] == '#') {
						return;
					} else if (stav.py < stav.pocetRiadkov - 2) {
						if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '.') {
							stav.mriezka[stav.py + 1][stav.px] = '@';
							stav.mriezka[stav.py + 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == ' ') {
							stav.mriezka[stav.py + 1][stav.px] = '@';
							stav.mriezka[stav.py + 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '*') {
							return;
						}
						if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '.') {
							stav.mriezka[stav.py + 1][stav.px] = '+';
							stav.mriezka[stav.py + 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == ' ') {
							stav.mriezka[stav.py + 1][stav.px] = '+';
							stav.mriezka[stav.py + 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '*') {
							return;
						}
					}

				} else if (stav.mriezka[stav.py][stav.px] == '+') {
					if (stav.mriezka[stav.py + 1][stav.px] == ' ') {
						stav.mriezka[stav.py + 1][stav.px] = '@';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.py++;
						return;
					} else if (stav.mriezka[stav.py + 1][stav.px] == '.') {
						stav.mriezka[stav.py + 1][stav.px] = '+';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.py++;
						return;
					} else if (stav.mriezka[stav.py + 1][stav.px] == '#') {
						return;
					} else if (stav.py < stav.pocetRiadkov - 2) {
						if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '.') {
							stav.mriezka[stav.py + 1][stav.px] = '@';
							stav.mriezka[stav.py + 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == ' ') {
							stav.mriezka[stav.py + 1][stav.px] = '@';
							stav.mriezka[stav.py + 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '$' && stav.mriezka[stav.py + 2][stav.px] == '*') {
							return;
						}
						if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '.') {
							stav.mriezka[stav.py + 1][stav.px] = '+';
							stav.mriezka[stav.py + 2][stav.px] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py - 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == ' ') {
							stav.mriezka[stav.py - 1][stav.px] = '+';
							stav.mriezka[stav.py - 2][stav.px] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.py++;
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '#') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '$') {
							return;
						} else if (stav.mriezka[stav.py + 1][stav.px] == '*' && stav.mriezka[stav.py + 2][stav.px] == '*') {
							return;
						}
					}

				}
			} else if (znak == 'l') {
				if (stav.mriezka[stav.py][stav.px] == '@') {
					if (stav.mriezka[stav.py][stav.px - 1] == ' ') {
						stav.mriezka[stav.py][stav.px - 1] = '@';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.px--;
						return;
					} else if (stav.mriezka[stav.py][stav.px - 1] == '.') {
						stav.mriezka[stav.py][stav.px - 1] = '+';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.px--;
						return;
					} else if (stav.mriezka[stav.py][stav.px - 1] == '#') {
						return;
					} else if (stav.px > 1) {
						if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '.') {
							stav.mriezka[stav.py][stav.px - 1] = '@';
							stav.mriezka[stav.py][stav.px - 2] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == ' ') {
							stav.mriezka[stav.py][stav.px - 1] = '@';
							stav.mriezka[stav.py][stav.px - 2] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '*') {
							return;
						}
						if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '.') {
							stav.mriezka[stav.py][stav.px - 1] = '+';
							stav.mriezka[stav.py][stav.px - 2] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == ' ') {
							stav.mriezka[stav.py][stav.px - 1] = '+';
							stav.mriezka[stav.py][stav.px - 2] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '*') {
							return;
						}
					}

				} else if (stav.mriezka[stav.py][stav.px] == '+') {
					if (stav.mriezka[stav.py][stav.px - 1] == ' ') {
						stav.mriezka[stav.py][stav.px - 1] = '@';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.px--;
						return;
					} else if (stav.mriezka[stav.py][stav.px - 1] == '.') {
						stav.mriezka[stav.py][stav.px - 1] = '+';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.px--;
						return;
					} else if (stav.mriezka[stav.py][stav.px - 1] == '#') {
						return;
					} else if (stav.px > 1) {
						if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '.') {
							stav.mriezka[stav.py][stav.px - 1] = '@';
							stav.mriezka[stav.py][stav.px - 2] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == ' ') {
							stav.mriezka[stav.py][stav.px - 1] = '@';
							stav.mriezka[stav.py][stav.px - 2] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '$' && stav.mriezka[stav.py][stav.px - 2] == '*') {
							return;
						}
						// PUSHER KRABICACIEL
						if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '.') {
							stav.mriezka[stav.py][stav.px - 1] = '+';
							stav.mriezka[stav.py][stav.px - 2] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == ' ') {
							stav.mriezka[stav.py][stav.px - 1] = '+';
							stav.mriezka[stav.py][stav.px - 2] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px--;
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px - 1] == '*' && stav.mriezka[stav.py][stav.px - 2] == '*') {
							return;
						}
					}

				}

			} else if (znak == 'r') {
				if (stav.mriezka[stav.py][stav.px] == '@') {
					if (stav.mriezka[stav.py][stav.px + 1] == ' ') {
						stav.mriezka[stav.py][stav.px + 1] = '@';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.px++;
						return;
					} else if (stav.mriezka[stav.py][stav.px + 1] == '.') {
						stav.mriezka[stav.py][stav.px + 1] = '+';
						stav.mriezka[stav.py][stav.px] = ' ';
						stav.px++;
						return;
					} else if (stav.mriezka[stav.py][stav.px + 1] == '#') {
						return;
					} else if (stav.px < stav.pocetStlpcov - 2) {
						if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '.') {
							stav.mriezka[stav.py][stav.px + 1] = '@';
							stav.mriezka[stav.py][stav.px + 2] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == ' ') {
							stav.mriezka[stav.py][stav.px + 1] = '@';
							stav.mriezka[stav.py][stav.px + 2] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '*') {
							return;
						}
						if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '.') {
							stav.mriezka[stav.py][stav.px + 1] = '+';
							stav.mriezka[stav.py][stav.px + 2] = '*';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == ' ') {
							stav.mriezka[stav.py][stav.px + 1] = '+';
							stav.mriezka[stav.py][stav.px + 2] = '$';
							stav.mriezka[stav.py][stav.px] = ' ';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '*') {
							return;
						}
					}

				} else if (stav.mriezka[stav.py][stav.px] == '+') {
					if (stav.mriezka[stav.py][stav.px + 1] == ' ') {
						stav.mriezka[stav.py][stav.px + 1] = '@';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.px++;
						return;
					} else if (stav.mriezka[stav.py][stav.px + 1] == '.') {
						stav.mriezka[stav.py][stav.px + 1] = '+';
						stav.mriezka[stav.py][stav.px] = '.';
						stav.px++;
						return;
					} else if (stav.mriezka[stav.py][stav.px + 1] == '#') {
						return;
					} else if (stav.px < stav.pocetStlpcov - 2) {
						if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '.') {
							stav.mriezka[stav.py][stav.px + 1] = '@';
							stav.mriezka[stav.py][stav.px + 2] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == ' ') {
							stav.mriezka[stav.py][stav.px + 1] = '@';
							stav.mriezka[stav.py][stav.px + 2] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '$' && stav.mriezka[stav.py][stav.px + 2] == '*') {
							return;
						}
						if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '.') {
							stav.mriezka[stav.py][stav.px + 1] = '+';
							stav.mriezka[stav.py][stav.px + 2] = '*';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == ' ') {
							stav.mriezka[stav.py][stav.px + 1] = '+';
							stav.mriezka[stav.py][stav.px + 2] = '$';
							stav.mriezka[stav.py][stav.px] = '.';
							stav.px++;
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '#') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '$') {
							return;
						} else if (stav.mriezka[stav.py][stav.px + 1] == '*' && stav.mriezka[stav.py][stav.px + 2] == '*') {
							return;
						}
					}

				}

			}
		}
	}

	/**
	 * Spustenie hry.
	 * @param args args.
	 */
	public static void main(String[] args) {
		launch(args);
	}
}
