package informationflow;

public class Calculator {
	private static final String WRONG_NUMBER_MESSAGE = "Wrong number";
    private static final String WRONG_INPUT_MESSAGE = "Wrong input";
    private static final String ALLOWED_OPERATORS = "+-*/";
    private static final String ALLOWED_CHARS = "IVXLCDM";

    private String operator = "";
    private int integerNumber1 = -1;
    private int integerNumber2 = -1;


    public String romanCalculator(String expression) {
        int result = 0;

        if (expression != null && isExpressionValid(expression)) {
            switch (operator){
                case "+":
                    result = integerNumber1 + integerNumber2;
                    break;
                case "-":
                    result = integerNumber1 - integerNumber2;
                    break;
                case "*":
                    result = integerNumber1 * integerNumber2;
                    break;
                case "/":
                    if ((integerNumber1 % integerNumber2) != 0){
                        return WRONG_NUMBER_MESSAGE;
                    }
                    result = integerNumber1 / integerNumber2;
                    break;
                default:
                    break;
            }

            if (result > 0 && result < 4000){
                return "";
            } else {
                return WRONG_NUMBER_MESSAGE;
            }
        } else {
            return WRONG_INPUT_MESSAGE;
        }
    }

    public boolean isExpressionValid(String expression){
        expression = expression.replace(" ","");

        for (char expressionCharacter : expression.toCharArray()){
            if(!(ALLOWED_CHARS + ALLOWED_OPERATORS).contains(String.valueOf(expressionCharacter))){
                return false;
            }

            if(ALLOWED_OPERATORS.contains(String.valueOf(expressionCharacter)) && "".equals(operator)){
                operator = String.valueOf(expressionCharacter);
            } else if(!(ALLOWED_CHARS.contains(String.valueOf(expressionCharacter)))){
                return false;
            }
        }
        return !"".equals(operator) && validateNumbersFromExpression(expression);
    }

    public boolean validateNumbersFromExpression(String expression) {
        String[] tempExpression = expression.replace(operator, ",").split(",");
        if (tempExpression.length == 2){
            return integerNumber1 != -1 && integerNumber2 != -1;
        }
        return false;
    }

}
