package informationflow;



import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataValidator {
	public static final String ONLY_NUMERIC_REGEX = "[0-9]";
    public static final String ROW_ERROR_MESSAGE = "Error in answer ";
    public static final String QUESTION_ERROR_MESSAGE = ", question ";
    public static final String ANSWER_ERROR_MESSAGE = ", answer ";
    public static final String ANSWER_ERROR_NOT_FILLED = "not filled";
    public static final String MISSING_ANSWERS_MESSAGE = "Missing answers for ID: {}";
    public static final String SOME_ANSWERS_MISSING = "{}, some answers are missing";
    public static final String SOME_ADDITIONAL_ANSWERS = "{}, some additional answers was detected";
    public static final String FULLY_EMPTY_LINE = "Line after answer with ID {} is fully empty";
    public static final String ANSWER_ERROR_REASON_NON_NUMERIC = ", value does not match any of: A, B, C, D, E, N, XX";
    public static final String ANSWER_ERROR_REASON_OUT_OF_RANGE_0_7 = ", value must be a number [0-7, 9]";
    public static final String ANSWER_ERROR_REASON_OUT_OF_RANGE_0_4 = ", value must be a number [0-4, 9]";


    private int lastAnswerId = 0;

    public void findMistakes() {
        String dataFilePath = "./src/main/resources/suborDat.csv";

        String[] data ={ "A", "B", "C", "D", "E" };// new String[20]  ;//loadDataFromCsv(dataFilePath);
        lastAnswerId = 0;

        for (int i = 1; i < data.length; i++) {

           
        }
    }

    public boolean checkMissingAnswersLogs(String[] rowData) {
        if (!rowData[0].isEmpty() && Integer.parseInt(rowData[0]) > lastAnswerId + 1) {
            int actualRowId = Integer.parseInt(rowData[0]);
            lastAnswerId += 1;
            while (lastAnswerId < actualRowId) {
                lastAnswerId += 1;
            }
            return false;
        } else if (!rowData[0].isEmpty()) {
            lastAnswerId = Integer.parseInt(rowData[0]);
            return true;
        }

        return false;
    }

    public static boolean checkAnswerCount(String[] rowData, int dataColumnsNumber) {
        if (rowData[0].length() == 0) {
            return false;
        } else if (rowData.length < dataColumnsNumber) {
            return false;
        } else if (rowData.length > dataColumnsNumber) {
            return false;
        } else
            return true;
    }

    // Kontroluje odpovede na otazky 1-9, 28-36
    public boolean checkMandatoryQuestionsMoreOptions(String[] row) {
        ArrayList<Integer> questionNumbers = new ArrayList<>();
        boolean withoutErr = true;

        for (int i = 1; i <= 9; i++) {
            questionNumbers.add(i);
        }

        for (int i = 28; i <= 36; i++) {
            questionNumbers.add(i);
        }

        for (int question: questionNumbers) {
            if (row[question].isEmpty()
                    || !row[question].matches(ONLY_NUMERIC_REGEX)
                    || Integer.parseInt(row[question]) < 0
                    || Integer.parseInt(row[question]) == 8
                    || Integer.parseInt(row[question]) > 9) {
                withoutErr = false;
                String answerValue = row[question].replaceAll("\\s+","").isEmpty() ? ANSWER_ERROR_NOT_FILLED : row[question];
                }
        }
        return withoutErr;
    }

    // Kontroluje odpovede na otazky 13-20, 23-27
    public boolean checkMandatoryQuestionsLessOptions(String[] row) {
        ArrayList<Integer> questionNumbers = new ArrayList<>();
        boolean withoutErr = true;

        for (int i = 13; i <= 20; i++) {
            questionNumbers.add(i);
        }

        for (int i = 23; i <= 27; i++) {
            questionNumbers.add(i);
        }

        for (int question: questionNumbers) {
            if (row[question].isEmpty()
                    || !row[question].matches(ONLY_NUMERIC_REGEX)
                    || Integer.parseInt(row[question]) < 0
                    || (Integer.parseInt(row[question]) > 4 && Integer.parseInt(row[question]) < 9)
                    || Integer.parseInt(row[question]) > 9) {
                withoutErr = false;
                String answerValue = row[question].replaceAll("\\s+","").isEmpty() ? ANSWER_ERROR_NOT_FILLED : row[question];
            }
        }
        return withoutErr;
    }

    // Kontroluje odpovede na otazky 10-12
    public boolean checkNonMandatoryQuestionsLessOptions(String[] row) {
        ArrayList<Integer> questionNumbers = new ArrayList<>(Arrays.asList(10,11,12));
        boolean withoutErr = true;

        for (int question: questionNumbers) {
            if (!row[question].isEmpty() && (!row[question].matches(ONLY_NUMERIC_REGEX)
                    || Integer.parseInt(row[question]) < 0
                    || (Integer.parseInt(row[question]) > 4 && Integer.parseInt(row[question]) < 9)
                    || Integer.parseInt(row[question]) > 9)) {
                withoutErr = false;
                String answerValue = row[question].replaceAll("\\s+","").isEmpty() ? ANSWER_ERROR_NOT_FILLED : row[question];
            }
        }
        return withoutErr;
    }

    // Kontroluje odpovede na otazku 21
    public boolean checkNonMandatoryQuestionsMoreOptions(String[] row) {
        int question = 21;
        boolean withoutErr = true;

        if (!row[question].matches(ONLY_NUMERIC_REGEX)
                || Integer.parseInt(row[question]) < 0
                || Integer.parseInt(row[question]) == 8
                || Integer.parseInt(row[question]) > 9) {
            withoutErr = false;
            String answerValue = row[question].replaceAll("\\s+","").isEmpty() ? ANSWER_ERROR_NOT_FILLED : row[question];
       }
        return withoutErr;
    }

    // Kontroluje odpovede na otazku 22
    public boolean checkMandatoryQuestionsLetterOptions(String[] row) {
        int question = 22;
        boolean withoutErr = true;

        if (row[question].isEmpty()
                || (row[question].length() == 1 && !row[question].matches("[ABCDEN]"))
                || (row[question].length() == 2 && !row[question].equals("XX"))
                || Integer.parseInt(row[question]) < 0
                || Integer.parseInt(row[question]) == 8
                || Integer.parseInt(row[question]) > 9) {
            withoutErr = false;
            String answerValue = row[question].replaceAll("\\s+","").isEmpty() ? ANSWER_ERROR_NOT_FILLED : row[question];
       }
        return withoutErr;
    }

  

}
