from typing import Set, Dict, Tuple


CAP_SIGMA = 'Σ'
DELTA = '𝛿'
EPSILON = 'ε'


class FA:
    def __init__(self, states: Set[str], alphabet: Set[str], delta: Dict[Tuple[str, str], Set[str] | str], initial: str,
                 finals: Set[str], name: str = 'A',
                 sets_name: Tuple[str, str, str, str] = ('K', CAP_SIGMA, DELTA, 'F')):
        self.states = states
        self.alphabet = alphabet
        self.delta = delta
        self.initial = initial
        self.finals = finals
        self.name = name
        self.sets_name = sets_name
        self.type: str = "FA"

    def __str__(self):
        string = self.type + ' ' + self.name + ': states: ' + str(self.states) + '\ninitial:' + self.initial
        string += '\nfinals: ' + str(self.finals) + '\nalphabet: ' + str(self.alphabet) + '\ndelta: ' + str(self.delta)
        return string


class DFA(FA):
    def __init__(self, states: Set[str], alphabet: Set[str], delta: Dict[Tuple[str, str], str], initial: str,
                 finals: Set[str], name: str = 'A',
                 sets_name: Tuple[str, str, str, str] = ('K', CAP_SIGMA, DELTA, 'F')):
        super().__init__(states, alphabet, delta, initial, finals, name, sets_name)
        self.type = 'DFA'


class NFA(FA):
    def __init__(self, states: Set[str], alphabet: Set[str], delta: Dict[Tuple[str, str], Set[str]], initial: str,
                 finals: Set[str], name: str = 'A',
                 sets_name: Tuple[str, str, str, str] = ('K', CAP_SIGMA, DELTA, 'F')):
        super().__init__(states, alphabet, delta, initial, finals, name, sets_name)
        self.type = 'NFA'

TEST_NFA = NFA(states={'0', '1', '2', '3', '4'},
               alphabet={'a', 'b'},
               delta={('0', EPSILON): {'1'},
                      ('0', 'a'): {'0', '2'},
                      ('0', 'b'): {'3'},
                      ('1', EPSILON): {'2'},
                      ('1', 'a'): {'2'},
                      ('1', 'b'): {'1', '3'},
                      ('2', EPSILON): {'0', '3'},
                      ('2', 'a'): {'0', '1'},
                      ('3', EPSILON): {'4'},
                      ('3', 'a'): {'0', '1'},
                      ('3', 'b'): {'3'}},
               initial='0',
               finals={'3'},
               name='TA'
               )

ABBA_NFA = NFA(states={'0', '1', '2', '3', '4'},
               alphabet={'a', 'b'},
               delta={('0', 'a'): {'0', '1'},
                      ('0', 'b'): {'0'},
                      ('1', 'b'): {'2'},
                      ('2', 'b'): {'3'},
                      ('3', 'a'): {'4'},
                      ('4', 'a'): {'4'},
                      ('4', 'b'): {'4'}},
               initial='0',
               finals={'4'},
               name='A')


