import io
import os
import subprocess
from tkinter import messagebox


class CreateLatex():
    header = r"\documentclass[11pt, a4paper]{article}" + '\n'
    header += r"\parindent 0pt" + '\n'
    header += r"\begin{document}" + '\n'
    end = r"\end{document}"

    def __init__(self, string: str = ''):
        self.string = CreateLatex.header + string + CreateLatex.end
        self.dir = 'saves'

    def create_tex_file(self, name: str | io.TextIOWrapper):
        if isinstance(name, str):
            try:
                with open(name, 'w', encoding='utf-8') as file:
                    file.write(self.string)
            except PermissionError:
                messagebox.showerror(title='Nepodarilo sa vytvoriť tex súbor',
                                     message=f"Nepodarilo sa zapisovať do súboru {name}")
        else:
            name.reconfigure(encoding='utf-8')
            name.write(self.string)
            name.close()

    def compile_tex_file(self, name: str, dir: str):
        c = subprocess.run("pdflatex " + name, shell=True, cwd=dir, capture_output=True)
        if c.stderr:
            messagebox.showerror(title='Nepodarilo sa skompilovať tex súbor', message="Potrebný je program pdflatex.\n"+
            str(c.stderr))

