from tkinter import *
from tkinter import ttk
from typing import Optional, Dict

from Automata import FA
from DiagramEditor import DiagramEditor
from TextEditor import TextEditor


class NotebookTab:
    def __init__(self, notebook: ttk.Notebook, order: int, icons_dict: Dict[str, PhotoImage]):
        self.frame: ttk.Frame = ttk.Frame(notebook)
        self.frame.pack(fill='both', expand=True)
        self.frame.rowconfigure(0, weight=1)
        self.frame.columnconfigure(0, weight=1)
        self.frame.columnconfigure(1, weight=1)
        self.name = StringVar(value='nový automat')
        notebook.add(self.frame, text=self.name.get())
        self.order = order
        self.diagram: DiagramEditor = DiagramEditor(self.frame, 0, 0, icons_dict)
        self.text: TextEditor = TextEditor(self.frame, 0, 1)
        self.regex_label: ttk.Label = ttk.Label(self.frame, width=150)
        self.regex_label.grid(row=1, column=0, columnspan=2, sticky='w')
        self.fa: Optional[FA] = None
        self.compute_exists: bool = False
