import os.path
from tkinter import *
from tkinter import ttk, messagebox
from tkinter.filedialog import asksaveasfile
from typing import List

from CreateLatex import CreateLatex
from SaveData import *

class SaveWindow:
    def __init__(self):
        self.left_tree: ttk.Treeview
        self.right_tree: ttk.Treeview
        self.save_dict: Dict[int, SaveData] = {}

    def item_selected(self, from_tree: ttk.Treeview, to_tree: ttk.Treeview):
        for selected_item in from_tree.selection():
            item = from_tree.item(selected_item)
            record = item['values']
            if to_tree == self.right_tree and not record in [to_tree.item(it)['values'] for it in to_tree.get_children()]:
                to_tree.insert('', END, values=record, iid=selected_item)
            if from_tree == self.right_tree:
                from_tree.delete(selected_item)


    def create_save_window(self, save_data: List[SaveData]):
        self.window = Toplevel()
        self.left_tree = ttk.Treeview(self.window, columns='all', show='headings')
        self.right_tree = ttk.Treeview(self.window, columns='save', show='headings')
        self.left_tree.heading('all', text='Všetky', anchor=CENTER)
        self.right_tree.heading('save', text='Uložiť', anchor=CENTER)
        self.left_tree.column('all', stretch=True)
        self.right_tree.column('save', stretch=True)

        for save in save_data:
            id = self.left_tree.insert('', END, values=[save.show_name()])
            self.save_dict[id] = save

        self.left_tree.bind('<<TreeviewSelect>>', lambda _: self.item_selected(self.left_tree, self.right_tree))
        self.right_tree.bind('<<TreeviewSelect>>', lambda _: self.item_selected(self.right_tree, self.left_tree))

        self.left_tree.grid(row=0, column=0, sticky='nsew')
        self.right_tree.grid(row=0, column=1, sticky='nsew')

        save_button = ttk.Button(self.window, text='Uložiť tex súbor', command=self.save)
        save_button.grid(row=1, column=0, sticky='nsew')
        save_and_compile_button = ttk.Button(self.window, text='Uložiť tex súbor a skompilovať na pdf', command=self.save_and_compile)
        save_and_compile_button.grid(row=1, column=1, sticky='nsew')



    def save(self):
        try:
            file = asksaveasfile(initialdir='', defaultextension=".tex",
                           filetypes=[ ("Tex dokumenty", "*.tex"), ("Všetky súbory", "*.*")])
            if file is not None:
                string = ""
                for id in self.right_tree.get_children():
                    string += "$" + self.save_dict[id].to_tex() + '$\n' + r"\newpage" + '\n'
                c = CreateLatex(string)
                c.create_tex_file(file)
        except PermissionError:
            messagebox.showerror(title='Nepodarilo sa vytvoriť tex súbor',
                                 message=f"Nepodarilo sa otvoriť súbor s týmto menom")

    def save_and_compile(self):
        try:
            file = asksaveasfile(initialdir='', defaultextension=".tex",
                               filetypes=[ ("Tex dokumenty", "*.tex"), ("Všetky súbory", "*.*")])
            if file is not None:
                string = ""
                for id in self.right_tree.get_children():
                    string += "$" + self.save_dict[id].to_tex() + '$\n' + r"\newpage" + '\n'
                c = CreateLatex(string)
                c.create_tex_file(file)
                try:
                    with open(os.path.splitext(file.name)[0]+'.pdf', 'w', encoding='utf-8') as file:
                        pass
                    c.compile_tex_file(file.name, os.path.dirname(file.name))
                except PermissionError:
                    messagebox.showerror(title='Nepodarilo sa skompilovať tex súbor',
                                         message=f"Nepodarilo sa zapisovať do súboru {os.path.splitext(file.name)[0]}.pdf")
        except PermissionError:
            messagebox.showerror(title='Nepodarilo sa vytvoriť tex súbor',
                                 message=f"Nepodarilo sa otvoriť súbor s týmto menom")
