from queue import Queue
from threading import Thread


from constant import *
from time import sleep


class General_filter(Thread):
    q_in: Queue
    q_out: Queue
    blackboard = None
    type_filtered: str
    type_saved: str

    def run(self):
        try:
            while True:
                index = self.q_in.get()
                sleep(1)
                # print("thread of", self.type_filtered, ",  index =", index)
                if isinstance(index, EOFError):
                    self.q_out.put(EOFError(""))
                    break
                if self.greater_than_blackboard(index):
                    self.q_out.put(EOFError(""))
                    break
                elif self.is_my_type(index):
                    self.save(index)
                    self.q_out.put(index + 1)
                else:
                    self.q_out.put(index)
        except:
            pass

    def greater_than_blackboard(self, index):
        return len(self.blackboard.data[half_raw_data]) <= index

    def is_my_type(self, index):
        return self.type_filtered == self.blackboard.data[half_raw_data][index][0]

    def save(self, index):
        self.blackboard.data[event_second_data][self.type_saved]\
            .append(self.blackboard.data[half_raw_data][index][1])
        self.blackboard.type_event = event_print + " " + self.type_saved
        self.blackboard.notify()


