import threading


# https://stackoverflow.com/questions/2785821/is-there-an-easy-way-in-python-to-wait-until-certain-condition-is-true
class Waiter:
    def __init__(self):
        self.var = None
        self.var_mutex = threading.Lock()
        self.var_event = threading.Event()

    def wait_until(self, v):
        while True:
            self.var_mutex.acquire()
            if self.var is not None and self.var == v:
                self.var = None
                self.var_mutex.release()
                return  # Done waiting
            self.var_mutex.release()
            self.var_event.wait()  # Wait 1 sec

    def update(self, v):
        self.var_mutex.acquire()
        self.var = v
        self.var_mutex.release()
        self.var_event.set()  # In case someone is waiting
        self.var_event.clear()
