import os
from pydicom import FileDataset
from patient import Patient, Metadata
import pydicom as pd
import matplotlib.pyplot as plt
from utils import plot_ct_image, resize_image, plot_pixel_array

POSITIVE_DATA_FOLDER = "../data/meningeomy/meningeomy_1_6_20"
# NEGATIVE_DATA_FOLDER = "data/mozgy"

patients_with_meningeomas_directory = os.listdir(POSITIVE_DATA_FOLDER)

patients = []
for patient_directory_name in patients_with_meningeomas_directory:
    patient_directory_path = os.path.join(POSITIVE_DATA_FOLDER, patient_directory_name)
    patient = Patient(patient_directory_path, is_positive=True)
    patients.append(patient)

patient = patients[0]
