from skimage.transform import resize


# plt from matplotlib
def plot_line(plt, point0, point1, color="red", linewidth=1.0):
    x_values = point0[0], point1[0]
    y_values = point0[1], point1[1]
    plt.plot(x_values, y_values, color=color, linewidth=linewidth)


def plot_point(plt, point, color="red", marker="o", markersize=1.0):
    plt.plot(point[0], point[1], marker=marker, markersize=markersize, color=color)


def scale_point(point, width, height):
    return width * point[0], height * point[1]


def transform_to_hu(medical_image, image):
    intercept = medical_image.RescaleIntercept

    slope = medical_image.RescaleSlope

    hu_image = image * slope + intercept

    return hu_image


def window_image(image, window_center, window_width):
    img_min = window_center - window_width // 2

    img_max = window_center + window_width // 2

    window_image = image.copy()

    window_image[window_image < img_min] = img_min

    window_image[window_image > img_max] = img_max

    return window_image


def plot_pixel_array(plt, pixel_array):
    plt.style.use('grayscale')
    # brain_image = window_image(pixel_array, 40, 80)
    plt.imshow(pixel_array)
    plt.style.use('default')


def plot_ct_image(plt, slice, pixel_array):
    plt.style.use('grayscale')
    pixel_arr = transform_to_hu(slice, pixel_array)
    brain_image = window_image(pixel_arr, 40, 80)
    plt.imshow(brain_image)
    plt.style.use('default')


def resize_image(pixel_array, img_px_size):
    resized_img = resize(pixel_array, (img_px_size, img_px_size), anti_aliasing=True)
    return resized_img
