#lang typed/racket ;#:no-optimize
;#lang typed/racket/no-check

(require "expr.rkt")
(require "proof.rkt")
(require "read.rkt")
(require "write.rkt")
(require "display.rkt")
(require "elim.rkt")

(define proof-sep ; kvoli type checkingu
  (make-string 3 #\newline))



;; formulas and their conversion to/from sexp

(: F Sexp)
;(define F 'P)
;(define F 'Q)
;(define F 'R)
;(define F '⊤)
;(define F '(∧ P Q))
(define F '(∧ (∧ P Q) R))
;(define F '(→ (→ P Q) R))

(: F2 Sexp)
(define F2 '(∨ (∧ (→ (→ P Q) A) (∨ A B ) ) R))

;F
;(sexp->formula F)
;(formula->sexp (sexp->formula F))
;(display/formula (sexp->formula F))

;(: B1 Formula)
;(define B1 (∨ (P 1) (P 2)))
;B1


; 'f(a,b,c,d,e)
;(: B Formula)
;(define B (Af (cons 0 0) (list))) ; f_{0}^{0}(0)
;(define B (Af (cons 1 1) (list t)))


;B
;(is-semiformula? B)




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;signeformulas and their conversion to sexp

(: sH SignedFormula)
(define sH (sexp->signedformula F2))


(: sC SignedFormula)
(define sC (sexp->signedformula '(¬ P) ))
;(signedformula->sexp sC)



(: sC1 SignedFormula)
(define sC1 (sexp->signedformula 'P))
;sC1


(: sC11 SignedFormula)
(define sC11 (sexp->signedformula 'Q))
;sC11


(: sC2 SignedFormula)
(define sC2 (sexp->signedformula '(∧ P Q)))
;sC2
;(define sexp/sf (signedformula->sexp sC2))
;sexp/sf

(: sC22 SignedFormula)
(define sC22 (sexp->signedformula '(∧ A B)))

(: sC222 SignedFormula)
(define sC222 (sexp->signedformula '(*(∧ B C))))

(: sC3 SignedFormula)
(define sC3 (sexp->signedformula '(∨ P Q)))

(: sC33 SignedFormula)
(define sC33 (sexp->signedformula '(*(∨ A B))))

(: sC4 SignedFormula)
(define sC4 (sexp->signedformula '(→ P Q)))
;sC4

(: sC44 SignedFormula)
(define sC44 (sexp->signedformula '(* (→ P Q))))

(: sC5 SignedFormula)
(define sC5 (sexp->signedformula '(→ (∧ A B) (∧ B C))))
;sC5

(: sfC5 SignedFormula)
(define sfC5 (sexp->signedformula '(→ (∧ A B) (∨ P D))))



(: sDoubleNeg SignedFormula)
(define sDoubleNeg (sexp->signedformula '(¬ (¬ P))))
;sDoubleNeg

(: sTripleNeg SignedFormula)
(define sTripleNeg (Goal (sexp->formula '(¬ ( ¬ ( ¬ P))))))
;sTripleNeg


(: sF SignedFormula)
(define sF (sexp->signedformula '(* P)))
;sF


(: sFF SignedFormula)
(define sFF (sexp->signedformula '(* Q)))
;sFF

(: sFFF SignedFormula)
(define sFFF (sexp->signedformula '(* C)))
;sFFF


(: sF1 SignedFormula)
(define sF1 (sexp->signedformula '(* (¬ P))))
;sF1


(: sF11 SignedFormula)
(define sF11 (sexp->signedformula '(* (¬ Q))))


(: sFCon SignedFormula)
(define sFCon (sexp->signedformula '(* (∧ P Q))))
;sFCon


(: sFDis SignedFormula)
(define sFDis (sexp->signedformula '(* (∨ P Q))))
;sDis


(: sImp SignedFormula)
(define sImp (sexp->signedformula '(* (→ P Q))))
;sImp

(: axiomT SignedFormula)
(define axiomT (Goal (⊤)))

(: axiomTinv SignedFormula)
(define axiomTinv (Asmp (⊥)))

(: sf-axiom⊥ SignedFormula)
(define sf-axiom⊥ (Goal (⊥)))

(: sfc SignedFormula)
(define sfc (sexp->signedformula '(∧ A A)))



(: sCD Sexp)
(define sCD (signedformula->sexp sC))
;sCD

(: sCD2 Sexp)
(define sCD2 (signedformula->sexp sF))
;sCD2




;signedformulas conversions


(: sFsS (Listof Sexp))
;(define sFsS '(P (* P)))
;(define sFsS `(,F
;               ))
(define sFsS `(,F2
              ,F
               ))

;sFsS




;(: sFs SignedFormulas)
;(define sFs (sexps->signedformulas sFsS))
;
;(signedformulas->string sFs)
;(signedformulas->sexps sFs)



;cut formulas

(: sCut2 SignedFormula)
(define sCut2 (sexp->signedformula '(∧ A B)))

(: sCut1 SignedFormula)
(define sCut1 (sexp->signedformula '(* (∧ A B))))

(: sCut3 SignedFormula)
(define sCut3 (sexp->signedformula '(* (∨ A B))))

(: sCuti SignedFormula)
(define sCuti (sexp->signedformula '(* (→ A B))))

(: Cuta SignedFormula)
(define Cuta (sexp->signedformula '(* A)))

(: sCutn SignedFormula)
(define sCutn (sexp->signedformula '(* (¬ A))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;proofs and their conversion to sexp





(: π Proof)
(define π (Node1 (Prule1 "¬a" sC sF) (Node0(■))))
;(is-proof? π (list sC))

;(define π (Node1 (Prule1 "¬g" sF1 sC1) (Node0(■))))
;(is-proof? π (list sF1))

;(define π (Node1 (Prule1 "∧a1" sC2 sC1) (Node1 (Prule1 "∧a2" sC2 sC11)(Node0(■)))))
;(is-proof? π (list sCon))

;(define π (Node1 (Prule1 "∨g1" sFDis sF) (Node1 (Prule1 "∨g2" sFDis sF2)(Node0(■)))))
;(is-proof? π (list sDis))

;(define π (Node1 (Prule1 "→g1" sImp sC1) (Node1 (Prule1 "→g2" sImp sF2)(Node0(■)))))

;(is-proof? π (list sImp))
;(sexp->proof π5)

;binarne pravidla

;(define π (Node2 (Prule2 "∧g" sF5 sF1 sF11) (Node0(■)) (Node0(■))))
;(is-proof? π (list sF5)) 

;(sfs->sexps sFs)


(: π1 Proof)
;(define π1 (Node0(Axiom "□⊤"  (list (Goal (⊤))))))
;(is-proof? π1 (list (Goal (⊤))))

;(define π1 (Node0 (Axiom "□⊥"  (list (Asmp (⊥))))))
(define π1 (Node0 (Axiom "□" (list (sexp->signedformula 'P) (sexp->signedformula '(* P))))))



;(is-proof? π1 (list (Asmp  (⊥))))




;(: π2 Proof)
;(define π2 (sexp->proof `(Cut (0 ■ ■)) (list sCuti)))
;(display/proof π2 (list) (list))

;(: ρ2 Proof)
;(define ρ2 (eliminate π2))
;(display/proof ρ2 (list) (list))
;

(: π6 Proof)
;(define π6 (Node2 (Cut "Cut" (Goal (P 0)) (Asmp (P 0))) (Node0(■)) (Node0(■))))
(define π6 (Node2 (Cut "Cut" sCut1 sCut2) (Node0(■)) (Node0(■))))
;(define π6 (Node2 (Cut "Cut" sCut1 sCut2) (Node0(■)) (Node0(■))))


;(define π6
;  (sexp->proof `(Cut
;                           (0
;                            
;                             (→a ■ ■)
;                            (∧a1
;                              (∧a2
;                                 ■)))) (list axiomT  sC2 sC5 sFDis)))

;(define π6
;  (sexp->proof `(Cut
;                           (0
;                            
;                             (→a ■ ■)
;                            (∧a1
;                              (∧a2
;                                 ■)))) (list sf-axiom⊥  sC2 sC5 sFDis)))

(displayln proof-sep)

;(display/proof π6 (list sf-axiom⊥  sC2 sC2 sC5 sFDis) (list))
;(cut-rank π6)
;(is-proof? π6 (list))
;(display/proof (eliminate π6) (list sf-axiom⊥  sC2 sC5 sFDis) (list))


(define-type hHt (HashTable String Ht))

;(displayln "tab")
;(: tab1 hHt)
;(define tab1 (make-hash '()))
;(hash-set! tab1 "a" (Ht (⊤)))
;(hash-ref)
;tab1

(: π7 Proof)

;(define π7 (sexp->proof '■ '()))
;(proof->sexp π7)

(define Sm (signedformula->sexp axiomTinv))

;(define-values (π7 table/π7) (sexp->proof '(□⊤) (list sC axiomT)))
(define-values (π7 table/π7) (sexp->proof `(□⊥ ,Sm) (list sC axiomT sF axiomTinv)))
;(define-values (π7 table/π7) (sexp->proof `(□⊥ 3) (list sC axiomT sF axiomTinv)))
;(define-values (π7 table/π7) (sexp->proof '(□⊥) (list sC axiomT sF axiomTinv)))
;(define-values (π7 table/π7) (sexp->proof `(□ 1 0) (list sC sC1 sF)))
;(define-values (π7 table/π7) (sexp->proof `(□ 0 1) (list sC sC1 sF)))
;(define-values (π7 table/π7) (sexp->proof '(□) (list sC sC1 sF)))
;(define-values (π7 table/π7) (sexp->proof '(□) (list sC1 sC sF)))
;π7
;(proof->sexp π7)



;(: π8 Proof)


;(define-values (π8 table/π8) 
;(sexp->proof `(¬a
;               ,sCD
;               ,sCD2
;               0
;               ■) (list sC))
;)

;(define-values (π8 table/π8) (sexp->proof `(¬a
;                          0
;                          ■) (list sC)))

;(define-values (π8 table/π8) (sexp->proof `(¬a
 ;                         ■) (list sC)))


;π8

;(: π8-Sexp Sexp)
;(define π8-Sexp (proof->sexp π8))
;π8-Sexp


(: SS1 Sexp)
(define SS1 (signedformula->sexp sFCon))
;SS1

(: SS2 Sexp)
(define SS2 (signedformula->sexp sF))
;SS2

(: SS3 Sexp)
(define SS3 (signedformula->sexp sFF))
;SS3



(: π9 Proof)
;
;(define-values (π9 table/π9) (sexp->proof `(∧g
;                          ,SS1
;                          ,SS2
;                          ,SS3
;                          ■
;                          ■) (list sF1 sFCon)))

;(define-values (π9 table/π9) (sexp->proof `(∧g 1
;                          ■
;                          ■) (list sF1 sFCon)))

;(define-values (π9 table/π9) (sexp->proof `(∧g
;                           ■
;                          ■) (list sF1 sFCon)))

(define-values (π9 table/π9) (sexp->proof `(∧g
                           (¬g ■)
                          ■) (list sF1 sFCon)))

;(define-values (π9 table/π9) (sexp->proof `(∧g
;                          (¬g (¬a ■))
;                          ■) (list sF1 sFCon sDoubleNeg)))
;π9

;(displayln "π9")
;(display/proof π9 (list sF1 sFCon sDoubleNeg) (list))

;(:  π10 Proof)
;(define-values (π10 table/π10) (sexp->proof `(¬g
;                           ■
;                           
;                           ) (list sF1 sF1)))


;(:  π11 Proof)
;(define-values (π11 table/π11) (sexp->proof `(¬g
;                           (¬a
;                           (¬g
;                            ■))
;                           ) (list sTripleNeg) ))


;(define-values (π11 table/π11) (sexp->proof `(→a
;                          ()) (list sC5 sC111 sC22)))
;π11

;;(∧a1
;                          (∧a2
;                          (□
;                          (□
;                            ))))
;(sexp->proof (proof->sexp π11) (list sTripleNeg))



(: π12 Proof)
;(define-values (π12 table/π12) (sexp->proof `(→a ■ ■) (list sC5 sFFF sC22)))
;(define-values (π12 table/π12) (sexp->proof `(→a ■ (∧a1 (∧a2 (□)))) (list sC5 sFFF sC22)))
(define-values (π12 table/π12) (sexp->proof `(→a (∧g (□⊤) (□⊤))(∧a1 (∧a2(□)))) (list sC5 sFFF sC222 axiomT)))



;π12
;(is-proof? π12 (list sC5 sFFF sC22 axiomT)) ; v is proof v tom liste sa nachadzaju pociatocne formuly
(display/proof π12 (list sC5 sFFF sC22 axiomT) (list))

;(displayln proof-sep)
(: π13 Proof)
;(define-values (π13 table/π13) (sexp->proof `(Cut(0 ■ ■)) (list sCut1 sCut2)))
(define-values (π13 table/π13) (sexp->proof `(∧a1 (∧a2 ■)) (list sC22)))


;(is-proof?  π13 (list sC22))

;(display/proof π13 (list  sC22 ))
;display proof 

(: ρ13 Proof)
(define ρ13 (eliminate π13))
;(display/proof ρ13 (list))
;(displayln proof-sep)

(: π14 Proof)
;(define-values (π14 table/π14) (sexp->proof `(Cut (0 ■ ■)) (list sC44) ))
(define-values (π14 table/π14) (sexp->proof `(∧a1 (∧a2 (Cut (2 (Cut (4 ■ ■)) ■)))) (list sC44 sC33 sC22)))

;π14
;(display/proof π14 (list sfq1 sC22));

(: ρ14 Proof)
(define ρ14 (eliminate π14))


(: π15 Proof) ; original proof
;(define-values (π15 table/π15) (sexp->proof `(∧a1 3 (Cut (1 ■ ■))) (list sCuti sCut1 sCut3 sCut2)))
;(define-values (π15 table/π15) (sexp->proof `(∧a1 3 (∧a2 4 (Cut (2 ■ ■)))) (list sCuti sCut1 sCut3 sCut2)))
(define-values (π15 table/π15) (sexp->proof `(∧a1 3 (∧a2 4 (Cut (2 (Cut (3 ■ ■)) ■)))) (list sCuti sCut1 sCut3 sCut2)))

;(display/proof π15 (list sCut2) (list))

(: t-f Formula)
(define t-f (sexp->formula '(→ A B)))


(: π15-cinv Proof) ; cut inversion test
(define π15-cinv (cut-inversion-t π15 t-f))

;(display/proof π15-cinv (list sCut2) (list))


(: ρ15 Proof) ; eliminated
(define ρ15 (eliminate π15))
;(display/proof ρ15 (list sCut2) '())
;(displayln proof-sep)


(: π-unary-inv Proof)
;(define-values (π-unary-inv table/π-unary-inv) (sexp->proof `(∧a1 0 (∧a2 1 ■)) (list sCut2 sC)))
(define-values (π-unary-inv table/π-unary-inv) (sexp->proof `(∧a1  (∧a2 (¬a ■))) (list sCut2 sC)))

;(display/proof π-unary-inv (list sCut2 sC) (list))

(: π-unary-inv-r Proof)
;(define π-unary-inv-r (invert-unary π-unary-inv sCut2))
(define π-unary-inv-r (invert-unary π-unary-inv sC))
;(display/proof π-unary-inv-r (list sCut2 sC) (list))


;(displayln proof-sep)

(: π16 Proof)
;(define-values (π16 table/π16) (sexp->proof `(Cut (0 ■ ■))  (list sCutn)))
;(define-values (π16 table/π16) (sexp->proof `(Cut (0 (¬g ■) ■))  (list sCutn)))
;(define-values (π16 table/π16) (sexp->proof `(Cut (0 (¬g (∧a1 ■)) ■))  (list sCutn sC22)))
(define-values (π16 table/π16) (sexp->proof `(Cut (0 (¬g ■) (∧a1 ■)))  (list sCutn sC22)))


;π16

;(display/proof π16 (list sC22) (list))


(: ρ16 Proof)
(define ρ16 (eliminate π16))
;(depth/formula Cutn)

;(display/proof ρ16 (list sC22) (list))


;(Goal (∧ (⊤) (P 0)))
;def ozn., vyt. dokazu a is proof 3 r


;(displayln "atomic")
;(displayln proof-sep)

;(: π17-test Proof)
;(define π17-test (sexp->proof () (list sfc)))


(: π17 Proof)
;(define-values (π17 table/π17) (sexp->proof `(Cut (0 ■ ■)) (list Cuta)))
;(define-values (π17 table/π17) (sexp->proof `(Cut (0 ■ ■)) (list Cuta sfc)))
(define-values (π17 table/π17) (sexp->proof `(Cut (0  (∧a1 (□)) (∧a2 ■))) (list Cuta sfc)))


;(display/proof π17 '() '())
;(display/proof π17 (list sfc) '() )



;(displayln proof-sep)

(: ρ17 Proof)
(define ρ17 (eliminate π17))

;(display/proof π17-elim '() '())
;(display/proof ρ17 (list sfc) '() )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;auxiliary functions
;(list-refs sFs (list 20))
;(list-refs sFs (list))
;(list-refs sFs (list 0 1))

;(sexps->indices '(0))
;(sexps->indices '(0 1 2))
;(sexps->indices '(0 1 2 3 4))

;(member? sFCon (list sH sF sTripleNeg sFCon axiomT))
;(members? (list sH sFCon) (list sH sF sTripleNeg sFCon axiomT))
;(members? (list sH sFCon sH) (list sH sF sTripleNeg sFCon axiomT))
;

;(display-string (indices->string (list 0 1 2)))
;(display/indices (list 0 1 2))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;quantifier proofs and strucutres


(: t Term)
;(define t (sexp->term 'a))
(define t (Ht (∀ (Vt 1) (Af (cons 1 0) (list (Vt 1))))))
;(term->sexp t)


(: t1 Term)
;(define t1 (sexp->term '(f^2 x y)))
;(define t1 (sexp->term '(f^2 x y y)))
;(define t1 (sexp->term '(f^2)))
;(define t1 (sexp->term '(∃ x (P^2 x y))))
(define t1 (sexp->term '(f^0)))

;(display/term t1)
;(is-semiterm? t1)
;(is-term? t1)





(: qf Formula)
;(define qf (sexp->formula '(∃ x (P^2 x y))))
;(define qf (sexp->formula '(∃ y (∃ x (P^2 x y)))))
(define qf (sexp->formula '(∃ y (∃ x (∨ (P^2 x y) (P^1 y))))))
;(define qf (sexp->formula '(∃ y (∃ x (∨ (P^2 (f^2 x y) y) (P^1 y))))))

(: qf1 Formula)
(define qf1 (sexp->formula '(∀ x (P^1 x))))
;(define qf1 (sexp->formula '(∀ x (P^ x y))))
;qf1

(: qft Formula)
;(define qft (sexp->formula '(∃ x (→ (P^2 1 x) (P^2 1 (∀ x (P^2 1 x))) )  )))
(define qft (sexp->formula '(∃ x (→ (P^2 1 x) (P^2 1 (∃ x (P^2 1 x)))))))

;(display/signedformula (Asmp qft))
;qft
(: r Term)
(define r (sexp->term '1))

(: s Term)
(define s (sexp->term '2))

(: sfqt SignedFormula)
(define sfqt (Asmp qft))


(: sqfr SignedFormula)
(define sqfr (dr/signedformula sfqt r s))
;(display/signedformula sqfr)


(: sfqf SignedFormula)
(define sfqf (Goal qf))

(: sfqf1 SignedFormula)
(define sfqf1 (Goal qf1))



(: psfqf SignedFormula)
(define psfqf (Asmp qf))


(: psfqf1 SignedFormula)
(define psfqf1 (Asmp qf1))


;(display/signedformula sfqf)
;(display/signedformula sfqf1)
;
;
;(display/signedformula psfqf)
;(display/signedformula psfqf1)

;(: tsf SignedFormula)
;(define tsf (Asmp (∧ sfqf sfqf1)))

(: qfs Formula)
(define qfs (sexp->formula '(∃ x (P^2 x y))))

(: qht Formula)
;(define qht (sexp->formula '(P^1 (∃ x (P^2 x y)))))
(define qht (sexp->formula '(∧ (P^1 (∃ x (P^2 x y))) (P^1 (∃ x (P^2 x y))))))

;qht


(: sqfs SignedFormula)
(define sqfs (Goal qfs))

(: sqht SignedFormula)
(define sqht (Asmp qht))



(: sfd SignedFormula)
(define sfd (sexp->signedformula '(P^2 (∃ x (R^1 x (∃ x (P^1 x)))) (∃ x (P^1 x)))))

(: sff SignedFormula)
(define sff (sexp->signedformula '(P^1 (∃ x (P^1 x)))))

(: f1 Formula)
(define f1 (sexp->formula '(∃ x (P^1 x))))
;(formula->sexp f1)


(: f2 Formula)
(define f2 (sexp->formula '(∃ x (R^1 x (∃ x (P^1 x))))))
;(formula->sexp f2)


(: sfq SignedFormula)
(define sfq (sexp->signedformula '(∀ x (Q^1 x))))


(: sfq1 SignedFormula)
(define sfq1 (sexp->signedformula '(∀ x (A^1 x))))



(: sf1 SignedFormula)
(define sf1 (Goal f1))


(: sf2 SignedFormula)
(define sf2 (Goal f2))


(: πn Proof)
;(define-values (πn table/πn) (sexp->proof `(∃g 0 y z ■) (list sfqf)))
;(define-values (πn table/πn) (sexp->proof `(∃g 0 z ■) (list sfqf)))
;(define-values (πn table/πn) (sexp->proof `(∃g z ■) (list sfqf)))

;(display/proof πn (list sfqf))

;(define-values (πn table/πn) (sexp->proof `(∀g 0 ■) (list sfqf1)))
;(define-values (πn table/πn) (sexp->proof `(∀g  ■) (list sfqf1)))

;(display/proof πn (list sfqf1))


;(define-values (πn table/πn) (sexp->proof `(∃a 0 y z ■) (list psfqf)))
;(define-values (πn table/πn) (sexp->proof `(∃a 0  z ■) (list psfqf)))
;(define-values (πn table/πn) (sexp->proof `(∃a ■) (list psfqf)))
;(define-values (πn table/πn) (sexp->proof `(∃a (∃a ■)) (list psfqf)))
;(define-values (πn table/πn) (sexp->proof `(∃a (∃a (∨a ■ ■))) (list psfqf)))
(define-values (πn table/πn) (sexp->proof `(∃a (∃a (∨a ■ ■))) (list psfqf sfd sff)))

;πn
;(display/proof πn (list sff sfd psfqf) (list  ))


;(define-values (πn table/πn) (sexp->proof `(∀a 0 z ■) (list psfqf1)))
;(define-values (πn table/πn) (sexp->proof `(∀a z ■) (list psfqf1)))

;(display/proof πn (list psfqf1))


(displayln proof-sep)


(: sft SignedFormula)
(define sft (sexp->signedformula '(* (∃ y (→ (P^1 y) (∀ x (P^1 x)))))))

(: sft1 SignedFormula)
;(define sft1 (sexp->signedformula '(* (P^1 a))))
(define sft1 (sexp->signedformula '(* (P^1 (∀ x (P^1 x))))))

(: sft2 SignedFormula)
(define sft2 (sexp->signedformula '(* (∀ z (→ (∃ y (P^2 y z)) (∀ x (P^2 x z)))))))
(display/signedformula sft2)


(: πnts Proof)
;(define-values (πnts table/πnts) (sexp->proof '(∀g ■) (list sft2)))
(define-values (πnts table/πnts) (sexp->proof '(∀g (→g1 (→g2 ■))) (list sft2)))

(display/proof πnts (list sft2) (list))

(: πnt Proof)
;(define-values (πnt table/πnt) (sexp->proof '(Cut (0 ■ ■)) (list sft1)))
;(define-values (πnt table/πnt) (sexp->proof '(Cut (0 (∃g a ■) (∃g a ■))) (list sft1 sft)))
;(define-values (πnt table/πnt) (sexp->proof '(Cut (0 (∃g (∀ x (P^1 x)) (→g1 ■)) (∃g (∀ x (P^1 x)) (→g1 ■)))) (list sft1 sft)))
;(define-values (πnt table/πnt) (sexp->proof '(Cut (0 (∃g a (→g1 (□))) (∃g a (→g1 (→g2 (∀g ■)))))) (list sft1 sft)))
(define-values (πnt table/πnt) (sexp->proof '(Cut (0
                                (∃g (∀ x (P^1 x))
                                    (→g1
                                     (□)))
                                (∃g (∀ x (P^1 x))
                                    (→g1
                                     (→g2
                                      (∀g
                                       (□)))))))
                         (list sft1 sft)))
;

(: h Ht)
(define h (sexp->ht '(∀ x (P^1 x))))

(display/proof πnt (list sft) (list (cons "a" h)))
(is-proof? πnt (list sft))

(displayln proof-sep)

;
(: ρnt Proof)
(define ρnt (eliminate πnt))
;
(display/proof ρnt (list sft) (list))
;


;(displayln "sort")
;(sort (list f1 f2) compare)
;(compare f1 f2)
;(compare f2 f1)

(: πn-q Proof)
;(define-values (πn-q table/πn-q) (sexp->proof `(Cut (0 ■ ■)) (list sf2)))
;(define-values (πn-q table/πn-q) (sexp->proof `(Cut (0 (Cut (2 ■ ■)) ■)) (list sf2 sf1 sC2)))
;(define-values (πn-q table/πn-q) (sexp->proof `(∧a1 (∧a2 (Cut (2 (Cut (3 ■ ■)) ■)))) (list sf2 sf1 sC2)))
;(define-values (πn-q table/πn-q) (sexp->proof `(∧a1 (∧a2 (Cut (2 (Cut (4 ■ ■)) ■)))) (list sf2 sf1 sC2)))
;(define-values (πn-q table/πn-q) (sexp->proof `(∀a 0 (∃ x (R^1 x (∃ x (P^1 x)))) ■) (list sfq)))
(define-values (πn-q table/πn-q) (sexp->proof `(∀a 3 (∃ x (R^1 x (∃ x (P^1 x)))) (∧a1 (∧a2 (Cut (3 (Cut (5 ■ ■)) ■))))) (list sf2 sf1 sC2 sfq)))
;(define-values (πn-q table/πn-q) (sexp->proof `(∀a 3 (∃ x (R^1 x (∃ x (P^1 x)))) (∧a1 (∧a2 (Cut (3 (Cut (5 ■ ■)) ■))))) (list sf2 sf1 sC2 sfq sfq1)))



(display/proof πn-q (list sfq sC2) (list (cons "a" (Ht f1))  (cons "b" (Ht f2))))

(displayln proof-sep)


(: f-ts (Listof Formula))
(define f-ts (get-rqcuts πn-q 2))
;(display/formulas f-ts)
;(display/formulas (sort f-ts compare))

(displayln proof-sep)

(display/proof (quasiregularization πn-q 2) (list sfq sC2) (list (cons "a" (Ht f1))  (cons "b" (Ht f2))))

(displayln proof-sep)

(display/proof (eliminate πn-q) (list sfq sC2) (list (cons "a" (Ht f1))  (cons "b" (Ht f2))))

(displayln proof-sep)


(: πn1 Proof)
;(define-values (πn1 table/πn1) (sexp->proof `(∃g z (∃g u (∨g1 ■))) (list sqfs))) FIX
;(define-values (πn1 table/πn1) (sexp->proof `(Cut (0 ■ ■)) (list sqfs)))
;(define-values (πn1 table/πn1) (sexp->proof `(Cut (0 (∃g z ■) ■)) (list sqfs)))
;(define-values (πn1 table/πn1) (sexp->proof `(Cut (0 (∃g z ■) (∃a ■))) (list sqfs)))
(define-values (πn1 table/πn1) (sexp->proof `(Cut (0 (∃g z ■) ■)) (list sqfs)))
;(define-values (πn1 table/πn1) (sexp->proof `(Cut (0 (∃g z ■) (∧a1 ■))) (list sqfs sqht)))



;(is-proof? πn1 (list sqfs))
;(display/proof πn1 (list sqfs) (list))


;(displayln proof-sep)

(: ρn1 Proof)
(define ρn1 (eliminate πn1))
;ρn1
;(display/proof ρn (list ρn1) (list))

(: πn1-qe Proof) ; eliminate test for r = 2
(define πn1-qe (eliminate/all2 πn1 2))

;(display/proof πn1-qe (list sqfs) (list))
