#lang typed/racket ;#:no-optimize
;#lang typed/racket/no-check

;(require/typed racket/format
;               (~a (-> Sexp String)))

(require "expr.rkt")
(require "proof.rkt")
(require "write.rkt") ; zmenit aby len display boli provide
(require "read.rkt")
(provide
 
         enum-indices->string
         sexp->string
         display-string
         display/term
         display/terms
         formula->string
         display/formula       
         signedformula->string
         display/signedformula
         signedformulas->string         
         display/signedformulas
         display/indices
         display/proof
         display/formulas
         )



;; auxilliary operations

(: sexp->string (-> Sexp String))
(define (sexp->string e)
  (~a e))

(: display-string (-> String Void))
(define (display-string string)
  (displayln
     string) 
   ;string
   )

;; display of formulas

(: unary->string (-> String String String))
(define (unary->string op a)
  (string-append op a)) ; unarny operator  + formula

(: infix->string (-> String String String String))
(define (infix->string a op b)
  (string-append "(" a " " op " " b ")")) ; skonvertuje na infixovy zaois

(: symbolp->string (-> Symbol String))
(define (symbolp->string p)
  (substring (sexp->string  (symbolp->sexp p)) 0 1))

(: display/symbolp (-> Symbol Void))
(define (display/symbolp p)
  (displayln (symbolp->string p)))


(: symbolf->string (-> Symbol String))
(define (symbolf->string p)
  (substring (sexp->string  (symbolf->sexp p)) 0 1))


(: display/symbolf (-> Symbol Void))
(define (display/symbolf p)
  (displayln (symbolf->string p)))

(: variables-symbols->list (-> (Listof (Pairof String Ht)) (Listof String)))
(define (variables-symbols->list vs)
  (match vs
    ['() vs]
    [(list* v vs1) (list* (car v) (variables-symbols->list vs1))]))


(: display/variables-symbols (-> (Listof (Pairof String Ht)) Void))
(define (display/variables-symbols vs)
  (displayln (variables-symbols->list vs)))

(: term->string (-> Term String))
(define (term->string t)
  (match t
    [(At f ts) (string-append (symbolf->string f) (add-bracket (terms->string ts)))]
    [(Ht f) (string-append "c_" (formula->string f))];(string-append "<" (formula->string f) ">")]
    [_ (sexp->string (term->sexp t))]))

(: find-henkin/name (-> Ht (Listof (Pairof String Ht)) String))
(define (find-henkin/name ht variables)
  (match variables
    ['() (term->string ht)];(error "find-henkin/name/" ht)];]
    [(list* t ts)
     (define f-ht (cdr t))
     (if (equal? ht f-ht) (car t) (find-henkin/name ht (cdr variables)))]))

(: term->string/sub (-> Term (Listof (Pairof String Ht)) String))
(define (term->string/sub t variables)
  (match t
    [(At f ts) (string-append (symbolf->string f) (add-bracket (terms->string/sub ts variables)))]
    [(Ht f) (find-henkin/name t variables)]
    [_ (sexp->string (term->sexp t))]))



(: display/term (-> Term Void))
(define (display/term t)
  (displayln (term->string t)))

(: terms->string (-> Terms String))
(define (terms->string ts)
  (match ts
    ['() ""]
    [(list* t ts1) (if (empty? ts1) (string-append (term->string t) (terms->string ts1))
                        (string-append (term->string t) ","(terms->string ts1)))]))

(: terms->string/sub (-> Terms (Listof (Pairof String Ht)) String))
(define (terms->string/sub ts variables)
  (match ts
    ['() ""]
    [(list* t ts1) (if (empty? ts1) (string-append (term->string/sub t variables) (terms->string/sub ts1 variables))
                        (string-append (term->string/sub t variables) ","(terms->string/sub ts1 variables)))]))



(: display/terms (-> Terms Void))
(define (display/terms ts)
  (displayln (terms->string ts)))


(: add-bracket (-> String String))
(define (add-bracket  op)
  (string-append "(" op ")"))

(: qf->string (-> String String String String))
(define (qf->string q x a)
  (string-append  q  x " " a ))


(: vt->string (-> Vt String))
(define (vt->string vt) (sexp->string (vt->sexp vt)))




(: formula->string (-> Formula String))
(define (formula->string a)
  (match a
    [(Af P es) (string-append (symbolp->string P) (number->string (length es)) (if (empty? es) "" (add-bracket (terms->string es))))]
    [(⊤) "⊤"]
    [(⊥) "⊥"]
    [(¬ b) (unary->string "¬" (formula->string b))]
    [(∧ b c) (infix->string (formula->string b) "∧" (formula->string c))]
    [(∨ b c) (infix->string (formula->string b) "∨" (formula->string c))]
    [(→ b c) (infix->string (formula->string b) "→" (formula->string c))]
    [(∃ x b) (string-append "∃" (vt->string x)  (formula->string b))]
    [(∀ x b) (string-append "∀" (vt->string x)  (formula->string b))]
    [_ (error "formula->string/" a)]))
;
(: formula->string/sub (-> Formula (Listof (Pairof String Ht)) String))
(define (formula->string/sub a variables)
  (match a
    [(Af P es) (string-append (symbolp->string P) (number->string (length es))
                              (if (empty? es) "" (add-bracket (terms->string/sub es variables))))]
    [(⊤) "⊤"]
    [(⊥) "⊥"]
    [(¬ b) (unary->string "¬" (formula->string b))]
    [(∧ b c) (infix->string (formula->string/sub b variables) "∧" (formula->string/sub c variables))]
    [(∨ b c) (infix->string (formula->string/sub b variables) "∨" (formula->string/sub c variables))]
    [(→ b c) (infix->string (formula->string/sub b variables) "→" (formula->string/sub c variables))]
    [(∃ x b) (string-append "∃" (vt->string x)  (formula->string/sub b variables))]
    [(∀ x b) (string-append "∀" (vt->string x)  (formula->string/sub b variables))]
    [_ (error "formula->string/" a)]))


(: display/formula (-> Formula Void))
(define (display/formula a)
  (display-string (formula->string a))) ;najst disp

(: formulas->strings (-> (Listof Formula) String))
(define (formulas->strings fs)
  (match fs
    ['() ""]
    [(list* f1 fss) (if (empty? fss) (string-append (formula->string f1) (formulas->strings fss))
                        (string-append (formula->string f1) ", " (formulas->strings fss)))]))


(: display/formulas (-> (Listof Formula) Void))
(define (display/formulas fs)
  (display-string (add-bracket (formulas->strings fs))))

(: signedformula->string/sub (-> SignedFormula (Listof (Pairof String Ht)) String))
(define (signedformula->string/sub a variables)
  (match a
    [(Goal b)
     (string-append (formula->string/sub b variables) "*")] ; kvoli cislovaniu lepsie davat na koniec 
    [(Asmp b)
     (formula->string/sub b variables)]
    [_ (error "signedformula->string " a)]))

(: signedformula->string (-> SignedFormula String))
(define (signedformula->string a)
  (match a
    [(Goal b)
     (string-append (formula->string b) "*")] ; kvoli cislovaniu lepsie davat na koniec 
    [(Asmp b)
     (formula->string b)]
    [_ (error "signedformula->string " a)]))


(: display/signedformula/sub (-> SignedFormula (Listof (Pairof String Ht)) Void))
(define (display/signedformula/sub a variables)
  (display-string (signedformula->string/sub a variables)))


(: display/signedformula (-> SignedFormula Void))
(define (display/signedformula a)
  (display-string (signedformula->string a)))

(: signedformulas->string (-> SignedFormulas String))
(define (signedformulas->string sas)
  (match sas
    ['() ""]
    [(list* sf sfs) (if (empty? sfs) (string-append (signedformula->string sf) (signedformulas->string sfs))
                        (string-append (signedformula->string sf) ", "(signedformulas->string sfs))) ]
    [_ (error "signedformulas->string/" )]))


(: display/signedformulas (-> SignedFormulas Void))
(define (display/signedformulas sas)
  (display-string (add-bracket  (signedformulas->string sas))))

;pre kontrolu pripadnych chyb
(: list-of-tuples->string (-> (Listof (Pairof Index SignedFormula)) (Listof String)))
(define (list-of-tuples->string isas)
  (match isas
    ['() (list "")]
    [(list* pair pairs)  (if (empty? pairs) (list  (pair->string pair))
                             (list* (pair->string pair) "," (list-of-tuples->string pairs) )) ]
    [_ (error "list-of-tuples->string")]))

(: display/list-of-tuples (-> (Listof (Pairof Index SignedFormula)) Void))
(define (display/list-of-tuples isas)
  (displayln (list-of-tuples->string isas)))


(: pair->string (-> (Pairof Index SignedFormula) String))
(define (pair->string pair)
  (string-append "(" (number->string (car pair)) "," (signedformula->string (cdr pair)) ")"))


(: display/pair (-> (Pairof Index SignedFormula) Void))
(define (display/pair pair)
  (displayln (pair->string pair)))


(define-type Lines (U Line0 Line1 Line2 LineEmpty  LineCons LineAppend))
(struct Line0 ([line : (Listof String)]) #:transparent)
(struct Line1 ([line : (Listof String)]
               [lines : Lines]) #:transparent)
(struct Line2 ([line1 : (Listof String)]
               [lines1 : Lines]
               [line2 : (Listof String)]
               [lines2 : Lines]) #:transparent)


(struct LineEmpty () #:transparent)
(struct LineCons ([line : (Listof String)]
                  [lines : Lines]) #:transparent)
(struct LineAppend ([lines1 : Lines]
                    [lines2 : Lines]) #:transparent)
(struct LineStringAppend ([lines1 : LineAppend]
                          [string : String]))

(: q-add (-> Name (Listof (Pairof String Ht)) Boolean))
(define (q-add name variables)
  (match name
    ["∃a" #t]
    ["∀g" #t]
    [_ #f]))

(: display/strings (-> (Listof String) Void))
(define (display/strings strings)
  (display-string (string-join strings)))

(: indent->string (-> Natural String))
(define (indent->string in)
  (make-string (* 3 in) #\space))
  


(define newline ; kvoli type checkingu
  (make-string 0 #\newline))

(: conversion-list->string (-> (Listof (Pairof String Ht)) String))
(define (conversion-list->string c-list)
  (match c-list
    ['() ""]
    [(list* v vs)
     (define tuple (string-append (car v) (term->string (cdr v))))
     (string-append tuple (conversion-list->string (cdr c-list)))]))

(: display/conversion-list (-> (Listof (Pairof String Ht)) Void))
(define (display/conversion-list c-list)
  (displayln (conversion-list->string c-list)))


(: in-chosen-namings (-> String (Listof (Pairof String Ht)) Boolean))
(define (in-chosen-namings c c-list)
  (match c-list
    ['() #f]
    [(list* t ts)
     (define s (car t))
     (if (string=? c s) #t (in-chosen-namings c (cdr c-list)))]))

(: free-vars (-> (Listof String) (Listof (Pairof String Ht)) (Listof String)))
(define (free-vars cs c-list)
  (match cs
    ['() cs]
    [(list* c cs1) (if (in-chosen-namings c c-list) (free-vars (cdr cs) c-list) (list* c (free-vars (cdr cs) c-list)))]))


(: change-free-vars (-> (Listof String) Integer (Listof String)))
(define (change-free-vars cs i)
  (match cs
    ['() cs]
    [(list* c cs1) (list* (string-append c (number->string i)) (change-free-vars (cdr cs) i))]))

(: choose-naming (-> (Listof (Pairof String Ht)) String))
(define (choose-naming c-list)
  (define l (list "a" "b" "c"))
  (: choose-naming-iter (->  Integer String))
  (define (choose-naming-iter i)
    (cond [(= i 0)
           (define free (free-vars l c-list))
           (if (empty? free) (choose-naming-iter (+ i 1)) (car free))]
          [else (define free (free-vars (change-free-vars l i) c-list))
                (if (empty? free) (choose-naming-iter (+ i 1)) (car free))]))
  (choose-naming-iter 0))






(: indices->string (-> Indices String))
(define (indices->string is)
  (match is
    ['() ""]
    [(list* i is1) (if (empty? is1) (number->string i)
                      (string-append (number->string i) " " (indices->string is1)))]
    [_ (error "indices->string/" is)]))

(: display/indices (-> Indices Void))
(define (display/indices is)
  (displayln (add-bracket (indices->string is))))


(: find-index (-> SignedFormula (Listof (Pairof Index SignedFormula)) Natural))
(define (find-index sa isas)
(match isas
  ['() (display/signedformula sa)
   (error "find-index/" )]
  [(list* pair pairs)
   (cond [(and (pair? pair) (equal? (cdr pair) sa)) (car pair)]
         [else (find-index sa (cdr isas))])]))


(: iter-and-apply (-> SignedFormula SignedFormulas Index Index (Listof (Pairof Index SignedFormula)) Indices))
(define (iter-and-apply premise1 premises i1 i2 isas)
  (define premise2 (cdr (car isas)))
  (define n-premises (list premise1 premise2))
  (define n (length isas))
  (cond
    [(equal? (list premise1 premise2) premises) (list i1 i2)]
    [(equal? (list premise2 premise1)  premises) (list i2 i1)]
    [(empty? (cdr isas)) '()]
    [(not (empty? (cdr isas)))  (iter-and-apply  premise1 premises i1 (+ i2 1)  (cdr isas))]
    [else (error "mdisplay.rkt/" "iter-and-apply/")]))

(: find-indices-iter (-> SignedFormulas Index Index (Listof (Pairof Index SignedFormula)) Indices ))
(define (find-indices-iter premises i1 i2 isas)

  (define n (length isas))
  (define premise1 (cdr (car isas)))
  (define res (if (< n 2) (error "mdisplay.rkt/" "find-indices-iter/")
                  (iter-and-apply premise1 premises i1 (+ i2 1) (cdr isas))))
  
  (if (empty? res) (find-indices-iter premises (+ i1 1) (+ i1 1) (cdr isas))
      res))


(: find-indices (-> SignedFormulas (Listof (Pairof Index SignedFormula)) Indices))
(define (find-indices premises isas)
  (match premises
    [(list sf)     
     (list (find-index sf isas))]
    [(list sf1 sf2)
     (define res (find-indices-iter premises 0 0 isas))
     (define pair1 (list-ref isas (car res))) ;bc isas is unordered so we need to find 
     (define pair2 (list-ref isas (car (cdr res))))
     (list (car pair1)  (car pair2))]
    [_ (error "find-indices/" premises)]))


(: enumerate-to-string (-> Index String))
   (define (enumerate-to-string i)
     (add-bracket (number->string i)))


(: enum-indices->string (-> Indices String))
(define (enum-indices->string is)
  (match is
    ['() ""]
    [(list* i is1)
     (if (empty? is1) (string-append (enumerate-to-string i) (enum-indices->string is1))
         (string-append (enumerate-to-string i) " and " (enum-indices->string is1)))]
    [_ (error "indices->string/" is)]))


(: axiom->list-of-string (-> Name Index Natural Indices (Listof (Pairof String Ht)) (Listof String)))
(define (axiom->list-of-string name  preorder-index indent indices variables)
  (define indent-and-num (string-append (indent->string indent) (enumerate-to-string preorder-index)))
  (match indices
    ['()
     (list indent-and-num
           name)]
    [(list* sf sfs) 
     (list indent-and-num
           name
           "by"
           (enum-indices->string indices))]
    [_ (error "create-list/Line0/" name)]))

(: child->list-of-string (-> Name Index SignedFormula Index Natural (Listof (Pairof String Ht)) (Listof String)))
(define (child->list-of-string name i sa parent-i indent variables)
  (define indent-and-num (string-append (indent->string indent) (enumerate-to-string i)))
  (list   indent-and-num
          (signedformula->string/sub sa variables)
          "from"
          (enumerate-to-string parent-i)
          "by"
          name))

(: gethtf (-> Ht (Listof (Pairof String Ht)) String))
(define (gethtf ht variables)
  (match ht
    [(Ht f) (formula->string/sub f variables)]
    [_ (error "gethtf/")]))


(: show-substitution (-> (Pairof String Ht) (Listof (Pairof String Ht)) String))
(define (show-substitution t variables)
  (string-append  "(" (car t) " ≡ " "c_" (gethtf (cdr t) variables) ")"))

(: show-substitution/table (-> (Pairof String Ht) (Listof (Pairof String Ht)) String))
(define (show-substitution/table t variables)
  (string-append  (car t) " ≡ " "c_" (gethtf (cdr t) variables)))



(: qchild->list-of-string (-> Name Index SignedFormula Index Natural (Listof (Pairof String Ht)) (Pairof String Ht) (Listof String)))
(define (qchild->list-of-string name i sa parent-i indent variables newt)
  (define indent-and-num (string-append (indent->string indent) (enumerate-to-string i)))
  (list   indent-and-num
          (signedformula->string/sub sa variables)
          "from"
          (enumerate-to-string parent-i)
          "by"
          name
          "using"
          (show-substitution newt variables)))



(: cut-node->list-of-string (-> Name Index SignedFormula Natural (Listof (Pairof String Ht)) (Listof String)))
(define (cut-node->list-of-string name i sa indent variables)
  (define indent-and-num (string-append (indent->string indent) 
          (enumerate-to-string i)))
  (list indent-and-num
        (signedformula->string/sub sa variables)
        "by"
        name))


(: Node0->lines (-> Rule (Listof (Pairof Index SignedFormula)) Index Natural (Listof (Pairof String Ht))
                    (Values Index Lines (Listof (Pairof String Ht)))))
(define (Node0->lines rule isas preorder-index indent variables)
  (match rule
    [(■)
     (define name "■")
     (values (+ preorder-index 1) (Line0 (axiom->list-of-string name preorder-index indent '() variables)) variables)]
    [(Axiom name premises)
     (values (+ preorder-index 1) (Line0 (axiom->list-of-string name preorder-index indent (find-indices premises isas) variables)) variables)]
    [_ (error "Node0->lines/" rule)]))

(: cf (-> SignedFormula Formula SignedFormula))
(define (cf sf f)
  (match sf
    [(Goal f1) (Goal f)]
    [(Asmp f1) (Asmp f)]))

(: check-if-in-list (-> Ht (Listof (Pairof String Ht)) (Values Name Boolean)))
(define (check-if-in-list h h-list)
  (match h-list
    ['() (values "" #f)]
    [(list* (cons name ht) ts1) 
     (if (equal? ht h) (values name #t) (check-if-in-list h (cdr h-list)))]))

(: Node1->lines (-> Rule Proof (Listof (Pairof Index SignedFormula)) Index Natural (Listof (Pairof String Ht))
                    (Values Index Lines (Listof (Pairof String Ht)))))
(define (Node1->lines rule p isas preorder-index indent variables)
  (match rule
    [(Prule1 name premise conclusion)
     (define i (find-index premise isas))
     
     (define-values (in lines variables1)
       (transform/proof->lines p (list* (cons preorder-index conclusion) isas) (+ preorder-index 1) indent variables))
     (values in
             (Line1 (child->list-of-string name preorder-index conclusion i indent variables1) lines)
             variables1)]
    [(Qrule name premise term conclusion)
     (define i (find-index premise isas))
     (cond [(and (is-strong-qrule? name) (Ht? term))
            (define-values (tname tv) (check-if-in-list term variables))
            (display "new")
            (displayln tv)
            (define new-t (if (equal? tv #t) (cons tname term) (cons (choose-naming variables) term)))
            (displayln new-t)
            (define vars (if (equal? tv #t) variables (list* new-t variables)))
            (define-values (in lines variables1)
              (transform/proof->lines p (list* (cons preorder-index conclusion) isas) (+ preorder-index 1) indent vars))
            (values in
                    (Line1 (qchild->list-of-string name preorder-index conclusion i indent variables1 new-t) lines)
                    variables1)]
           [else
            (display "newu")
            (define-values (in lines variables1)
              (transform/proof->lines p (list* (cons preorder-index conclusion) isas) (+ preorder-index 1) indent variables))

            (values in
                    (Line1 (child->list-of-string name preorder-index conclusion i indent variables1) lines)
                    variables1)])]
    [_ (error "Node1->lines/" rule)]))

(: Node2->lines (-> Rule Proof Proof (Listof (Pairof Index SignedFormula)) Index Natural (Listof (Pairof String Ht))
                    (Values Index Lines (Listof (Pairof String Ht)))))
(define (Node2->lines rule p1 p2 isas preorder-index indent variables)
  (match rule
    [(Prule2 name premise conclusion1 conclusion2)
     (define i (find-index premise isas))
     (define left-child (child->list-of-string name preorder-index conclusion1 i (+ indent 1) variables))
     (define-values (right-child-index left-subtree variables1)
       (transform/proof->lines p1 (list* (cons preorder-index conclusion1) isas)  (+ preorder-index 1) (+ indent 1) variables))
     (define right-child (child->list-of-string name right-child-index conclusion2 i (+ indent 1) variables1)) 
     (define-values (right-subtree-index right-subtree variables2)
       (transform/proof->lines p2 (list* (cons right-child-index conclusion2) isas) (+ right-child-index 1) (+ indent 1) variables1))
     (values right-subtree-index (Line2 left-child
            left-subtree
            right-child
            right-subtree) variables2)]
    
    [(Cut name conclusion1 conclusion2)
     (define left-child (cut-node->list-of-string name preorder-index conclusion1 (+ indent 1) variables))
    (define-values (right-child-index left-subtree variables1)
       (transform/proof->lines p1 (list* (cons preorder-index conclusion1) isas)  (+ preorder-index 1) (+ indent 1) variables))
     (define right-child (cut-node->list-of-string name right-child-index conclusion2  (+ indent 1) variables1))
      (define-values (right-subtree-index right-subtree variables2)
       (transform/proof->lines p2 (list* (cons right-child-index conclusion2) isas) (+ right-child-index 1) (+ indent 1) variables1))
     (values right-subtree-index (Line2 left-child
            left-subtree
            right-child
            right-subtree) variables2)] 
    [_ (error "Node2->lines/" rule)]))

#|
aaaa

|#

(: transform/proof->lines (-> Proof (Listof (Pairof Index SignedFormula)) Index Natural (Listof (Pairof String Ht))
                              (Values Index Lines (Listof (Pairof String Ht)))))
(define (transform/proof->lines p isas preorder-index indent variables)
  (match p
    [(Node0 rule) (Node0->lines rule isas preorder-index indent variables)]
    [(Node1 rule p1) (Node1->lines rule p1 isas preorder-index indent variables)]
    [(Node2 rule p1 p2) (Node2->lines rule p1 p2 isas preorder-index indent variables)]
    [_ (error "transform/proof->lines/" p)]))

(: pair->line (-> (Pairof Index SignedFormula) (Listof (Pairof String Ht)) (Listof String)))
(define (pair->line pair vars)
  (displayln pair)
  (list (enumerate-to-string (car pair)) (signedformula->string/sub (cdr pair) vars)))


(: pairs->lines (-> (Listof (Pairof Index SignedFormula)) (Listof (Pairof String Ht)) Lines))
(define (pairs->lines isas vars)
  (match isas
    ['() (LineEmpty)]
    [(list* pair1 pairs)
     (LineCons (pair->line pair1 vars) (pairs->lines pairs vars))]))


(: enumerate/formulas (-> SignedFormulas (Listof (Pairof Index SignedFormula))))
(define(enumerate/formulas sas)
  (: enumerate/formulas-iter (-> Index SignedFormulas (Listof (Pairof Index SignedFormula))))
  (define (enumerate/formulas-iter i sfs)
    (if (empty? sfs) sfs
         (list* (cons i (car sfs)) (enumerate/formulas-iter (+ i 1) (cdr sfs)))))
  (enumerate/formulas-iter 1 sas))
;(: show-henkin-names (-> (Listof (Pairof String Ht))  ))

(: proof->lines (-> Proof SignedFormulas (Listof (Pairof String Ht)) Lines))
(define (proof->lines p sas variables)
  (define isas (enumerate/formulas sas))
  (define lines1 (pairs->lines isas variables))  
  (define-values (_ lines2 variables1) (transform/proof->lines p (reverse isas) (+ 1 (length sas)) 0 variables)) ; reverse is necessary so the search goes from top to down
  (displayln variables1)
  (define l (cond [(not (empty? variables1)) (LineAppend (Line0 (list newline)) (Line0 (list "Na mieste voľných premenných sme použili:")))]
                  [else (LineEmpty)]))
  (LineAppend (LineAppend lines1 lines2) (LineAppend l (table->lines variables1))))


(: table->lines (-> (Listof (Pairof String Ht))  Lines))
(define (table->lines vars)
  (match vars
    ['() (LineEmpty)]
    [(list* var vars1)
     (define str (car var))
     (define ht (cdr var))
     (Line1  (list (show-substitution/table var vars)) (table->lines vars1))]))


;line1,line2 su conclusions
(: display/lines (-> Lines Void))
(define (display/lines lines)
  (match lines
    [(Line0 line) (display/strings line)]
    [(Line1 line lines) (display/strings line)
                        (display/lines lines)]
    [(Line2 line1 lines1 line2 lines2) (display-string newline)
                                    ;   (special->string (special->string (caar line1)))
                                       (display/strings line1)
                                       (display/lines lines1)
                                       (display-string newline)
                                       (display/strings line2)
                                       (display/lines lines2)]
    [(LineEmpty)(void)]
    [(LineCons line lines) (display/strings line)
                           (display/lines lines)]
    [(LineAppend lines1 lines2) (display/lines lines1)
                                (display/lines lines2)]))

(: display/proof (-> Proof SignedFormulas (Listof (Pairof String Ht)) Void))
(define (display/proof p sas variables)
  (display/lines (proof->lines p sas variables)))
