#lang typed/racket ;#:no-optimize
;#lang typed/racket/no-check


(require "expr.rkt")
(require "proof.rkt")
(require "display.rkt")
(require "write.rkt")

(provide cut-rank
         eliminate
         eliminate/rcuts
         cut-inversion-t
         invert-unary
         compare
         get-rqcuts
         quasiregularization
      ;   invert-binary
         eliminate/all2
         )


(: get-rule-premise (-> Rule SignedFormula))
(define (get-rule-premise rule)
  (match rule
    [(Prule1 name premise conclusion) premise]
    [(Prule2 name premise conclusion1 conclusion2) premise]
    [(Qrule name premise term conclusion) premise]
    [_ (error "get-rule-premise/")]))

(: reduce/⊤ (-> Proof Proof Proof))
(define (reduce/⊤ p1 p2)
  p1)


(: reduce/⊥ (-> Proof Proof Proof))
(define (reduce/⊥ p1 p2)
  p2)



(: reduce/P (-> Proof Proof Formula Proof)) ; no need to delete premises?
(define (reduce/P p1 p2 a)
  (define premises (list (Goal a) (Asmp a)))
  (extend-branches p1 p2 premises))



(: reduce/¬ (-> Proof Proof Formula SignedFormula Proof))
(define (reduce/¬ p1 p2 a c)
 (define q1 (invert-unary p1 (Goal (¬ a))))
 (define q2 (invert-unary p2 (Asmp (¬ a))))
; (create-cut a q2 q1)
 (Node2 (Cut "Cut"  (Goal a) (Asmp a)) q2 q1))




(: reduce/∧ (-> Proof Proof Formula Formula SignedFormula Proof))
(define (reduce/∧ p1 p2 a b c)
  (define p1-cut-formula (Goal (∧ a b))) ; all occurences in subtrees will be deleted
 ; (define p2-cut-formula (Asmp (∧ a b)))
  (define-values (q1 q2)  (invert-binary p1 p1-cut-formula))
  (define q3 (invert-unary p2 c))
  (create-cut a q1 (create-cut b q2 q3)))


(: reduce/∨ (-> Proof Proof Formula Formula SignedFormula Proof))
(define (reduce/∨ p1 p2 a b c)
  (define p1-cut-formula (Goal (∨ a b))) ; all occurences in subtrees will be deleted
  ;(define p2-cut-formula (Asmp (∨ a b)))
  (define q1 (invert-unary p1 p1-cut-formula))
  (define-values (q2 q3) (invert-binary p2 c))
  (create-cut a (create-cut b q1 q3) q2))


(: reduce/→ (-> Proof Proof Formula Formula SignedFormula Proof))
(define (reduce/→ p1 p2 a b c)
  (define p1-cut-formula (Goal (→ a b))) ; all occurences in subtrees will be deleted
  (define q1 (invert-unary p1 p1-cut-formula))
  (define-values (q2 q3) (invert-binary p2 c))
  (create-cut a q1 (create-cut b q2 q3)))

(: reduce/∃ (-> Proof Proof Formula Proof))
(define (reduce/∃ p1 p2 a)
  ;p2
  (define conclusion1 (Goal a))
  (define conclusion2 (Asmp a))
  (define q2 (invert-unary p2 conclusion2))
  (q-inversion p1 q2 (Goal a) "∃g"))



(: reduce/∀ (-> Proof Proof Formula Proof))
(define (reduce/∀ p1 p2 a)
  (define conclusion1 (Goal a))
  (define conclusion2 (Asmp a))
  (define q1 (invert-unary p1 conclusion1))
  (q-inversion p2 q1 (Asmp a) "∀a"))
;

(: extend-branches (-> Proof Proof SignedFormulas Proof))
(define (extend-branches p p-extend premises)
  (: check? (-> Rule Boolean))
  (define (check? rule)
    (and (Axiom? rule)
         (string=? (Axiom-name rule) "□")
         (equal? premises (Axiom-premises rule))))
  (match p
    [(Node0 rule) (if (check? rule) p-extend p)]
    [(Node1 rule p1) (Node1 rule (extend-branches p1 p-extend premises))]
    [(Node2 rule p1 p2) (Node2 rule (extend-branches p1 p-extend premises)
                               (extend-branches p2 p-extend premises))]))


(: q-inversion (-> Proof Proof SignedFormula Name Proof))
(define (q-inversion p p-extend sf r-name)
  (match p
    [(Node0 rule) p]
    [(Node1 rule p1) (match rule
                       [(Prule1 name premise conclusion) (Node1 rule (q-inversion p1 p-extend sf r-name))]
                       [(Qrule name premise term conclusion)
                        (cond
                          [(and (Goal? conclusion) (string=? name r-name "∃g") (equal? premise sf))
                           (define conclusion2 (Asmp (signedformula->formula conclusion)))
                           (define a (Ht (signedformula->formula premise)))
                           (Node2 (Cut "Cut" conclusion conclusion2)  (q-inversion p1 p-extend sf r-name) (dr/proof p-extend a term))]
                          
                          [(and (Asmp? conclusion) (string=? name r-name "∀a") (equal? premise sf))
                           (define conclusion1 (Goal (signedformula->formula premise)))
                           (define a (Ht (signedformula->formula premise)))
                           (Node2 (Cut "Cut" conclusion1 conclusion) (q-inversion p1 p-extend sf r-name) (dr/proof p-extend a term))]
                          [else (Node1 rule (q-inversion p1 p-extend sf r-name))])])]
    [(Node2 rule p1 p2) (Node2 rule (q-inversion p1 p-extend sf r-name) (q-inversion p2 p-extend sf r-name))]))






(: invert-binary-c (-> Proof SignedFormula String Proof))
(define (invert-binary-c p premise name)
  (: check? (-> Rule Boolean))
  (define (check? rule)
    (and (not (Cut? rule)) (equal? (get-rule-premise rule) premise)))
  (match p
    [(Node0 rule) p]
    [(Node1 rule p1) (Node1 rule (invert-binary-c p1 premise name))]
    [(Node2 rule p1 p2)
     (cond [(and (check? rule) (string=? name "l")) (invert-binary-c p1 premise name)]
           [(and (check? rule) (string=? name "r")) (invert-binary-c p2 premise name)]
           [else (Node2 rule (invert-binary-c p1 premise name) (invert-binary-c p2 premise name))])]))


(: invert-unary (-> Proof SignedFormula Proof)) ; pre vetvu ktora sa nebude rozvetvovat na viac vetiev pomocou premisy
(define (invert-unary p premise)
  (: check? (-> Rule Boolean))
  (define (check? rule)
    (and (equal? (get-rule-premise rule) premise)))
  (match p
    [(Node0 rule) p]
    [(Node1 rule p1) (if (check? rule) (invert-unary p1 premise)
                         (Node1 rule (invert-unary p1 premise)))]
    [(Node2 rule p1 p2) (Node2 rule (invert-unary p1 premise) (invert-unary p2 premise))]))


(: invert-binary (-> Proof SignedFormula (Values Proof Proof)))
(define (invert-binary p premise)
  (values (invert-binary-c p premise "l") (invert-binary-c p premise "r")))


(: create-cut (-> Formula Proof Proof Proof))
(define (create-cut a p1 p2)
  (define name "Cut")
  (Node2 (Cut name (Goal a) (Asmp a)) p1 p2))


(: reduce (-> SignedFormula Proof Proof Proof))
(define (reduce c p1 p2)
  (match c
    [(Asmp (Af P ts)) (reduce/P p1 p2 (Af P ts))]
    [(Asmp (⊤)) (reduce/⊤ p1 p2)]
    [(Asmp (⊥)) (reduce/⊥ p1 p2)]
    [(Asmp (¬ a)) (reduce/¬ p1 p2 a c)]
    [(Asmp (∧ a b)) (reduce/∧ p1 p2 a b c)]                   
    [(Asmp (∨ a b)) (reduce/∨ p1 p2 a b c)]
    [(Asmp (→ a b)) (reduce/→ p1 p2 a b c)]
    [(Asmp (∃ x b)) (reduce/∃ p1 p2 (∃ x b))]
    [(Asmp (∀ x b)) (reduce/∀ p1 p2 (∀ x b))]
    [_ (error "choose-reduce/" c)]))



(: check-reduction (-> Proof Proof Integer Boolean))
  (define (check-reduction p1 p2 d-A)
    (and (< (cut-rank p1) d-A) (< (cut-rank p2) d-A)))


(: eliminate/rcuts-helper (-> Rule Proof Proof Integer Proof))
(define (eliminate/rcuts-helper rule p1 p2 r)
  (match rule
    [(Cut name conclusion1 conclusion2)
     (define formula-depth (depth/formula (signedformula->formula conclusion2)))     
     (if (= r formula-depth) (if (check-reduction p1 p2 r) (reduce conclusion2 p1 p2)
                                 (reduce conclusion2 (eliminate/rcuts p1 r) (eliminate/rcuts p2 r)))

         (Node2 rule (eliminate/rcuts p1 r) (eliminate/rcuts p2 r)))
     ]
    [(Prule2 _1 _2 _3 _4) (Node2 rule (eliminate/rcuts p1 r) (eliminate/rcuts p2 r))]
    [_ (error "check-rule?")]))

(: eliminate/rcuts (-> Proof Integer Proof))
(define (eliminate/rcuts p r)
  (match p
    [(Node0 rule)  p]
    [(Node1 rule p1)  (Node1 rule (eliminate/rcuts p1 r))]
    [(Node2 rule p1 p2)  (eliminate/rcuts-helper rule p1 p2 r)]))


(: cut-rank (-> Proof Integer))
(define (cut-rank p)
  (: cut-rank-iter (-> Proof Integer Integer))
  (define (cut-rank-iter p cut)   
  (match p
    [(Node0 rule) cut]
    [(Node1 rule p1)  (cut-rank-iter p1 cut)]
    [(Node2 rule p1 p2) (match rule
                          [(Cut _1 conclusion1 conclusion2)
                           (define formula-depth (depth/formula (signedformula->formula conclusion2)))
                           (max (cut-rank-iter p1 formula-depth) (cut-rank-iter p2 formula-depth))]
                          [(Prule2 _1 _2 _3 _4) (max (cut-rank-iter p1 cut) (cut-rank-iter p2 cut))])]))
  (cut-rank-iter p 0))



(: cut-inversion-helper (-> Proof Formula Name Proof))
(define (cut-inversion-helper p f name)
  (match p
    [(Node0 rule) p]
    [(Node1 rule p1) (Node1 rule (cut-inversion-helper p1 f name))]
    [(Node2 rule p1 p2) (match rule
                          [(Cut _1 conclusion1 conclusion2)
                           (define cut-f (signedformula->formula conclusion1))
                           (cond [(equal? cut-f f)  (if (string=? name "l")
                                                                         (cut-inversion-helper p1 f name)
                                                                         (cut-inversion-helper p2 f name))]
                                 [else (Node2 rule (cut-inversion-helper p1 f name) (cut-inversion-helper p2 f name)) ])]
                          [(Prule2 _1 _2 _3 _4) (Node2 rule (cut-inversion-helper p1 f name) (cut-inversion-helper p2 f name))])]))

(: cut-inversion (-> Proof Formula (Values Proof Proof)))
(define (cut-inversion p f)
  (values (cut-inversion-helper p f "l") (cut-inversion-helper p f "r")))

(: cut-inversion-t (-> Proof Formula Proof))
(define (cut-inversion-t p f)
  (Node2 (Cut "Cut" (Goal f) (Asmp f)) (cut-inversion-helper p f "l") (cut-inversion-helper p f "r")))

(: is-qcut (-> SignedFormula Boolean))
(define (is-qcut sf)
  (match sf
    [(Asmp (∃ x a)) #t]
    [(Goal (∃ x a)) #t]
    [(Asmp (∀ x a)) #t]
    [(Goal (∀ x a)) #t]
    [_ #f]))

(: get-rqcuts (-> Proof Natural (Listof Formula)))
(define (get-rqcuts p r)
  (match p
    [(Node0 rule) '()]
    [(Node1 rule p1) (get-rqcuts p1 r)]
    [(Node2 rule p1 p2) (match rule
                          [(Cut _1 conclusion1 conclusion2)
                           (define df (depth/formula (signedformula->formula conclusion2)))
                           (cond [(and (= df r) (is-qcut conclusion2))
                                  (list* (signedformula->formula conclusion2) (append (get-rqcuts p1 r) (get-rqcuts p2 r)))]
                                 [else (append (get-rqcuts p1 r) (get-rqcuts p2 r))])]
                          [(Prule2 _1 _2 _3 _4) (append (get-rqcuts p1 r) (get-rqcuts p2 r))])]))


(: is-formula-in-parameters-iter (-> Terms Formula Boolean))
(define (is-formula-in-parameters-iter ts f)
  (match ts
    ['() #f]
    [(list* t1 ts1) (if (and (Ht? t1) (or (equal? (Ht-index t1) f) (is-formula-in-parameters f (Ht-index t1)))) #t (is-formula-in-parameters-iter ts1 f))]))



(: is-formula-in-parameters (-> Formula Formula Boolean))
(define (is-formula-in-parameters f f-c)
  (match f-c
    [(Af P es) (is-formula-in-parameters-iter es f)]
    [(⊤) #f]
    [(⊥) #f]
    [(¬ b) (is-formula-in-parameters f b)]
    [(∧ b c) (or (is-formula-in-parameters f b) (is-formula-in-parameters f c))]
    [(∨ b c) (or (is-formula-in-parameters f b) (is-formula-in-parameters f c))]
    [(→ b c) (or (is-formula-in-parameters f b) (is-formula-in-parameters f c))]
    [(∃ x b) (is-formula-in-parameters f b)]
    [(∀ x b) (is-formula-in-parameters f b)]))

(: compare (-> Formula Formula Boolean))
(define (compare f1 f2)
  (not (is-formula-in-parameters f1 f2)))

(: add-elem (-> Formula (Listof Formula) (Listof Formula))) ; mozno netreba
(define (add-elem f rs)
  (if (not (member? f rs)) (list* f rs) rs))

(: topological-sort (-> (Listof Formula) (Listof Formula) (Listof Formula)))
(define (topological-sort fs rs)
  (match fs
    ['() (sort rs compare)]
    [(list* f1 fs1) (topological-sort (cdr fs) (add-elem f1 rs))]))



(: quasiregularization-iter (-> Proof Natural (Listof Formula) Proof))
(define (quasiregularization-iter p r fs)
  (cond
    [(not (empty? fs)) (quasiregularization-iter (cut-inversion-t p (car fs)) r (cdr fs))]
    [(empty? fs) p]
    [else p]))

(: quasiregularization (-> Proof Natural Proof))
(define (quasiregularization p r)
 (define as (topological-sort (get-rqcuts p r) '()))
 (match as
   ['() p]
   [_ (define new-p (quasiregularization-iter p r as))
     ; (displayln new-p)
      new-p]))

(: eliminate/all (-> Proof Integer Proof)) 
(define (eliminate/all p r)
  (cond
      [(> r 0)
       (eliminate/all (eliminate/rcuts (quasiregularization p r)  r) (- r 1))]
      [else p]))


(: eliminate/all2 (-> Proof Integer Proof)) 
(define (eliminate/all2 p r)
  (cond
    [(= r 2)
     (eliminate/rcuts p r)]
       ;(eliminate/all (eliminate/rcuts p r) (- r 1))]
      [else p]))



(: eliminate (-> Proof Proof))
(define (eliminate p)
  (eliminate/all p  (cut-rank p)))

; zavola rezovu hodnost dokazu
;hlbka stromu aby naslo cut-rank dokazu
