#lang typed/racket ;#:no-optimize
;#lang typed/racket/no-check

(require "expr.rkt")
(require "proof.rkt")
(require "display.rkt")

(provide sexp->formula
         sexp->signedformula
         sexps->signedformulas
         sexp->proof
         ;sexp->p
         sexp->term
         sexp->ht
         is-in-rules?
         list-refs
         sexp/index?
         sexps->indices
         sexps->vts
         ; sexp->signedformula2
         )

;;; from symbolic expressions to first-order expressions
(define-type ConList (Listof (Pairof Sexp Ht)))
;; symbols
(define-type PTableVt (HashTable Sexp Vt))
(define-type PTableHt (HashTable Sexp Ht))
(define-type PTablef (HashTable Sexp Symbol))
(define-type PTableP (HashTable Sexp Symbol))
;(define-type PTable)
(provide
 PTableVt
 )



(: PT2 PTableVt)
(define PT2 (make-hash (list ; zmenit na parne a neparne cisla parne pre individuove konstanty a neparne pre henkinove konstanty
                        (cons 'a (Vt 0))
                        (cons 'x (Vt 1))
                        (cons 'b (Vt 2))
                        (cons 'y (Vt 3))
                        (cons 'c (Vt 4)) 
                        (cons 'z (Vt 5))
                        (cons 'u (Vt 7))
                        (cons 'v (Vt 9)) ;aj pre henkinove konstanty  parne cisla
                        (cons '1 (Vt 11))
                        (cons '2 (Vt 13))
                        )))


(: PT3 PTablef)
(define PT3 (make-hash (list
                        (cons 'f^0 (cons 0 0))
                        (cons 'f^1 (cons 1 0))
                        (cons 'f^2 (cons 2 0))
                        (cons 'f^3 (cons 3 0))
                        (cons 'f^4 (cons 4 0))
                        (cons 'g^0 (cons 0 1))
                        (cons 'g^1 (cons 1 1))
                        (cons 'g^2 (cons 2 1))
                        (cons 'g^3 (cons 3 1))
                        (cons 'h^0 (cons 0 2))
                        (cons 'h^1 (cons 1 2))
                        (cons 'h^2 (cons 2 2))
                        (cons 'h^3 (cons 3 2)))))
(: PT4 PTableP)
(define PT4 (make-hash (list
                       ; (cons 'P^0 (cons 0 0)) pre jednodusi zapis bez oznacenia 0
                        (cons 'P (cons 0 0))
                        (cons 'P^1 (cons 1 0))
                        (cons 'P^2 (cons 2 0))
                        (cons 'P^3 (cons 3 0))
                        ;(cons 'Q^0 (cons 0 0))
                        (cons 'Q (cons 0 1))
                        (cons 'Q^1 (cons 1 1))
                        (cons 'Q^2 (cons 2 1))
                        (cons 'Q^3 (cons 3 1))
                        ;(cons 'R^0 (cons 0 0))
                        (cons 'R (cons 0 2))
                        (cons 'R^1 (cons 1 2))
                        (cons 'R^2 (cons 2 2))
                        (cons 'R^3 (cons 3 2))
                        (cons 'A (cons 0 3))
                        (cons 'A^1 (cons 1 3))
                        (cons 'A^2 (cons 2 3))
                        (cons 'A^3 (cons 3 3))
                        (cons 'B (cons 0 4))
                        (cons 'C (cons 0 5))
                        (cons 'D (cons 0 6))
                        (cons 'E^1 (cons 1 7))
                        (cons 'E^2 (cons 2 7))
                        (cons 'E^3 (cons 3 7))
                        )))



(: sexp->vt (-> Sexp Vt))
(define (sexp->vt e)
  (if (hash-has-key? PT2 e)
      (hash-ref PT2 e)
      (error "sexp->vt" e)))

(: sexps->vts (->  (Listof Sexp) (Listof Vt)))
(define (sexps->vts es)
  (if (empty? es) es
      (cons (sexp->vt (car es)) (sexps->vts (cdr es)))))

(: sexp->ht (-> Sexp Ht))
(define (sexp->ht e)
  (match e
    [_ (Ht (sexp->formula e))])) ;alebo signedformula->sexp?

(: sexp->symbolf (-> Sexp Symbol))
(define (sexp->symbolf e)
  (if (hash-has-key? PT3 e)
      (hash-ref PT3 e)
      (error "sexp->symbolf" e)))

(: sexp->symbolp (-> Sexp Symbol))
(define (sexp->symbolp e)
  (if (hash-has-key? PT4 e)
      (hash-ref PT4 e)
      (error "sexp->symbolp" e)))

(: sexp/index? (-> Sexp Boolean))
(define (sexp/index? i)
  (natural? i))


(: specialt (-> Sexp Terms))
(define (specialt e)
  (match e
    ['() e]
    [(list* e1 es) (list* (sexp->term e1) (specialt es))]))

(: sexp->term (-> Sexp Term))
(define (sexp->term e)
  (: is-quantifier? (-> Sexp Boolean))
  (define (is-quantifier? e)
    (define Q (sexp->string e))
    (or (string=? Q "∃") (string=? Q "∀")))
  (match e
    [(list* q ts) #:when (is-quantifier? q)
     (sexp->ht e)]
    [(list* f ts)  (At (sexp->symbolf f) (specialt ts))]
    [_ (sexp->vt e)]))

;
;(: sexps->terms (-> Sexp Terms))
;(define (sexps->terms es)
;  (match es
;    ['() es]
;    [(list* f ts)  (list* (At (sexp->symbolf f) (sexps->terms ts) ) (sexps->terms (cdr es)))]
;    [_ (list* (sexp->vt es) (sexps->terms (cdr es)))]))

(: sexp->formula (-> Sexp Formula))
(define (sexp->formula e)
  (match e    
    ['⊤ (⊤)]
    ['⊥ (⊥)]
    [(list '¬ e1) (¬ (sexp->formula e1))]
    [(list '∧ e1 e2) (∧ (sexp->formula e1) (sexp->formula e2))]
    [(list '∨ e1 e2) (∨ (sexp->formula e1) (sexp->formula e2))]
    [(list '→ e1 e2) (→ (sexp->formula e1) (sexp->formula e2))]
    [(list '∃ x e1)  (∃ (sexp->vt x)  (sexp->formula e1))]
    [(list '∀ x e1)  (∀ (sexp->vt x)  (sexp->formula e1))]
    [(list* e1  ts)   (Af (sexp->symbolp e1) (specialt ts))] ;order of conditions matters
    [_ (Af (sexp->symbolp e) '())]))


(: sexp->signedformula (-> Sexp SignedFormula))
(define (sexp->signedformula e)
  (match e
    [(list '* e1) (Goal (sexp->formula e1))]
    [_ (Asmp (sexp->formula e))]))

(: sexps->signedformulas (-> (Listof Sexp) SignedFormulas))
(define (sexps->signedformulas sas)
  (if (empty? sas) sas 
      (cons (sexp->signedformula (car sas))
            (sexps->signedformulas (cdr sas)))))

(: sexp->index (-> Sexp Index))
(define (sexp->index e)
  (if (index? e) e
      (error "sexp->index" e)))


(: sexps->indices (-> (Listof Sexp) Indices))
(define (sexps->indices e)
  (match e
    [(list* i1 i2) (if (index? i1)
                       (list* i1 (sexps->indices i2))
                       (error "sexps->indices " i1))]
    ['() e]))




(: sexps/indices? (-> (Listof Sexp) Boolean))
(define (sexps/indices? is)
  (match is
    [(list* i is1) (if (sexp/index? i) (sexps/indices? is1)
                       (error "sexps/indices?"))]
    ['() #t]
    [_ (error "sexps/indices?/" "wrong format:" is)]))


(: index-of-formula-iter (-> String Index (-> SignedFormula Boolean) SignedFormulas Rules Index))
(define (index-of-formula-iter name i is-premise? sas rs)
  (: check? (-> SignedFormula Boolean))
  (define (check? s-premise)
    (and (is-premise? s-premise)
         (not (is-in-rules? name s-premise rs))))
  (match sas
    ['() (error "signedformula not found in signedformulas")]
    [(list* sf sfs) (if (check? sf) i (index-of-formula-iter name (+ i 1) is-premise? sfs rs))]
    [_ (error "index-of-formula-iter/")]))

;; formulas
(: index-of-formula? (-> String (-> SignedFormula Boolean) SignedFormulas Rules Index))
(define (index-of-formula? name is-premise? sas rs)
  (index-of-formula-iter name 0 is-premise? sas rs))


(: indices-of-formulas-iter (-> String Index Index (-> SignedFormula SignedFormula Boolean) SignedFormulas Rules Indices))
(define (indices-of-formulas-iter name i1 i2 is-premise? sas rs)
  (define n (length sas))
  (define res (if (< n 2) (error "rule can't be used")
                  (iter-and-apply name (car sas) i1 (+ i2 1) is-premise? (cdr sas) rs)))
  (if (empty? res)  (indices-of-formulas-iter name (+ i1 1) (+ i1 1) is-premise? (cdr sas) rs) res))



(: iter-and-apply (-> String SignedFormula Index Index  (-> SignedFormula SignedFormula Boolean) SignedFormulas Rules Indices))
(define (iter-and-apply name premise1 i1 i2 is-premise? sas rs)
  
  (define premise2 (car sas))
  (define n (length sas))

  (: check-premise (-> SignedFormula SignedFormula Boolean))
  (define (check-premise prem1 prem2)
    (and (is-premise? prem1 prem2)
         (not (is-in-rules? name (list prem1 prem2) rs))))
  
  (cond
    [(check-premise premise1 premise2)
     (list i1 i2)]
    [(check-premise premise2 premise1)
     (list i2 i1)]
    [(empty? (cdr sas)) '()]
    [(not (empty? (cdr sas)))
     (iter-and-apply name premise1 i1 (+ i2 1) is-premise? (cdr sas) rs)]
    [else (error "iter-and-apply/" name)]))

(: indices-of-formulas? (-> Name (-> SignedFormula SignedFormula Boolean) SignedFormulas Rules Indices))
(define (indices-of-formulas? name is-premise? sas rs)
  (indices-of-formulas-iter name 0 0 is-premise? sas rs)) 



(: is-in-rules? (-> Name (U SignedFormula SignedFormulas) Rules Boolean))
(define (is-in-rules? s-name s-premise  rs)
  (: check? (-> String  (U SignedFormula SignedFormulas) Boolean))
  (define (check? name  premise)
    (and (string=? name s-name)
         (equal? premise s-premise)))
  (if (empty? rs) #f
      (match (car rs)
        [(Axiom name premises)
         (if (check? name premises) #t (is-in-rules? s-name s-premise (cdr rs)))]
        [(Prule1 name premise conclusion)
         (if (check? name premise) #t (is-in-rules? s-name s-premise (cdr rs)))]
        [(Qrule name premise term conclusion)
         (if (check? name premise) #t (is-in-rules? s-name s-premise (cdr rs)))]
        [(Prule2 name premise conclusion1 conclusion2)
         (if (check? name premise) #t (is-in-rules? s-name s-premise (cdr rs)))]
        [(Cut name conclusion1 conclusion2)
         (if (check? name conclusion1)#t (is-in-rules? s-name s-premise (cdr rs)))]       
        [_ (error "is-in-rules?/" s-name "/" rs)])))



(: list-refs (-> SignedFormulas Indices  SignedFormulas)) ;Indices
(define (list-refs sas is)
  (match is
    [(list* i is1)
     (define sfs (list (list-ref sas i)))
     (append sfs (list-refs sas (cdr is)))]
    ['() is]
    [_ (error "list-refs ")]))

  

(: sexp->proof/prule1 (-> Name (-> SignedFormula Boolean) (-> SignedFormula SignedFormula)
                          Sexp SignedFormulas Rules Proof))
(define (sexp->proof/prule1 name is-premise? make-conclusion
                            e sas rs)
  (match e
    [(list e5)
     (define i (index-of-formula? name is-premise? sas rs))
     (define premise (list-ref sas i))
     (define conclusion (make-conclusion premise))
     (define rule (Prule1 name premise conclusion))
     (define subproof (sexp-w/rules->proof e5 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    
    [(list e4 e5)#:when (sexp/index? e4)
     (define i (sexp->index e4))
     (define premise (list-ref sas i))
     (define conclusion (make-conclusion premise))
     (define rule (Prule1 name premise conclusion))
     (define subproof (sexp-w/rules->proof e5 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    
    [(list e4 e5) 
     (define premise (sexp->signedformula e4))
     (define conclusion (make-conclusion premise))
     (define rule (Prule1 name premise conclusion))
     (define subproof (sexp-w/rules->proof e5 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    [(list e2 e3 e4) #:when (sexp/index? e2)
     (define i (sexp->index e2))
     (define premise (list-ref sas i))
     (define conclusion (sexp->signedformula e3))
     (define rule (Prule1 name premise conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]    

    [(list e2 e3 e4)
     (define premise (sexp->signedformula e2))
     (define conclusion (sexp->signedformula e3))
     (define rule (Prule1 name premise conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]    
    [_ (error (string-append "sexp->proof/prule1/" name) e)])) 




(: sexp->proof/prule2 (-> Name (-> SignedFormula Boolean) (-> SignedFormula (Values SignedFormula SignedFormula))
                          Sexp SignedFormulas Rules Proof))
(define (sexp->proof/prule2 name is-premise? make-conclusion
                            e sas rs)
  (match e
    [(list e6 e7)
     (define i (index-of-formula? name is-premise? sas rs))
     (define premise (list-ref sas i))
     (define-values (conclusion1 conclusion2) (make-conclusion premise))
     (define rule (Prule2 name premise conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e6 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e7 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]
    
    [(list e5 e6 e7) #:when (sexp/index? e5)
     (define i (sexp->index e5))
     (define premise (list-ref sas i))
     (define-values (conclusion1 conclusion2) (make-conclusion premise))
     (define rule (Prule2 name premise conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e6 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e7 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]
    
    [(list e5 e6 e7)
     (define premise (sexp->signedformula e5))
     (define-values (conclusion1 conclusion2) (make-conclusion premise))
     (define rule (Prule2 name premise conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e6 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e7 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]



    [(list e2 e3 e4 e5 e6) #:when (sexp/index? e2)
     (define i (sexp->index e2))
     (define premise (list-ref sas i))
     (define conclusion1 (sexp->signedformula e3))
     (define conclusion2 (sexp->signedformula e4))
     (define rule (Prule2 name premise conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e5 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e6 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]

    
    [(list e2 e3 e4 e5 e6)
     (define premise (sexp->signedformula e2))
     (define conclusion1 (sexp->signedformula e3))
     (define conclusion2 (sexp->signedformula e4))
     (define rule (Prule2 name premise conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e5 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e6 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]
   
    [_ (error (string-append "sexp->proof/prule2/" name) e)])) 

(: sexp->proof/¬a (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/¬a e sas rs)
  (define name "¬a")
  (define (is-premise? sa)
    (and (Asmp? sa) (¬? (Asmp-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Goal (¬-subformula (Asmp-formula sa)))
        (error "sexp->proof/¬a:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))


(: sexp->proof/¬g (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/¬g e sas rs)
  (define name "¬g")
  (define (is-premise? sa)
    (and (Goal? sa) (¬? (Goal-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Asmp (¬-subformula (Goal-formula sa)))
        (error "sexp->proof/¬g:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))



(: sexp->proof/∧a1 (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∧a1 e sas rs)
  (define name "∧a1")
  (define (is-premise? sa)
    (and (Asmp? sa) (∧? (Asmp-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Asmp (∧-subformula1 (Asmp-formula sa)))
        (error "sexp->proof/∧a1:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))

(: sexp->proof/∧a2 (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∧a2 e sas rs)
  (define name "∧a2")
  (define (is-premise? sa)
    (and (Asmp? sa) (∧? (Asmp-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Asmp (∧-subformula2 (Asmp-formula sa)))
        (error "sexp->proof/∧a2:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))



(: sexp->proof/∨g1 (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∨g1 e sas rs)
  (define name "∨g1")
  (define (is-premise? sa)
    (and (Goal? sa) (∨? (Goal-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Goal (∨-subformula1 (Goal-formula sa)))
        (error "sexp->proof/∨g1:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))


(: sexp->proof/∨g2 (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∨g2 e sas rs)
  (define name "∨g2")
  (define (is-premise? sa)
    (and (Goal? sa) (∨? (Goal-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Goal (∨-subformula2 (Goal-formula sa)))
        (error "sexp->proof/¬a:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))


(: sexp->proof/→g1 (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/→g1 e sas rs)
  (define name "→g1")
  (define (is-premise? sa)
    (and (Goal? sa) (→? (Goal-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Asmp (→-subformula1 (Goal-formula sa)))
        (error "sexp->proof/→g1:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))



(: sexp->proof/→g2 (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/→g2 e sas rs)
  (define name "→g2")
  (define (is-premise? sa)
    (and (Goal? sa) (→? (Goal-formula sa))))
  (: make-conclusion (-> SignedFormula SignedFormula))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (Goal (→-subformula2 (Goal-formula sa)))
        (error "sexp->proof/→g2:make-conclusion" sa)))
  (sexp->proof/prule1 name is-premise? make-conclusion e sas rs))


(: sexp->proof/∧g (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∧g e sas rs)
  (define name "∧g")
  (define (is-premise? sa)
    (and (Goal? sa) (∧? (Goal-formula sa))))
  (: make-conclusion (-> SignedFormula (Values SignedFormula SignedFormula)))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (values (Goal (∧-subformula1 (Goal-formula sa))) (Goal (∧-subformula2 (Goal-formula sa))))
        (error "sexp->proof/∧g:make-conclusion" sa)))
  (sexp->proof/prule2 name is-premise? make-conclusion e sas rs))



(: sexp->proof/∨a (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∨a e sas rs)
  (define name "∨a")
  (define (is-premise? sa)
    (and (Asmp? sa) (∨? (Asmp-formula sa))))
  (: make-conclusion (-> SignedFormula (Values SignedFormula SignedFormula)))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (values (Asmp (∨-subformula1 (Asmp-formula sa))) (Asmp (∨-subformula2 (Asmp-formula sa))))
        (error "sexp->proof/∨a:make-conclusion" sa)))
  (sexp->proof/prule2 name is-premise? make-conclusion e sas rs))


(: sexp->proof/→a (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/→a e sas rs)
  (define name "→a")
  (define (is-premise? sa)
    (and (Asmp? sa) (→? (Asmp-formula sa))))
  (: make-conclusion (-> SignedFormula (Values SignedFormula SignedFormula)))
  (define (make-conclusion sa)
    (if (is-premise? sa)
        (values (Goal (→-subformula1 (Asmp-formula sa)))
                (Asmp (→-subformula2 (Asmp-formula sa))))
        (error "sexp->proof/→a:make-conclusion" sa)))
  (sexp->proof/prule2 name is-premise? make-conclusion e sas rs))


(: convert-sf (-> SignedFormula SignedFormula))
(define (convert-sf sf)
  (cond
    [(Asmp? sf) (Goal (Asmp-formula sf))]
    [(Goal? sf) (Asmp (Goal-formula sf))]
    [else (error "convert-sf")]))


(: sexp->proof/■ (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/■ e sas rs)
  (define name ■)
  (Node0 (name)))

(: sexp->proof/□ (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/□ e sas rs)
  
  (define name "□")
  (define (is-premise? sa sa2)
    (cond
      [(and (Goal? sa) (Asmp? sa2)) (equal? (Goal-formula sa) (Asmp-formula sa2))]
      [else #f]))
  
  (match e
    ['()
     (define is (indices-of-formulas? name is-premise? sas rs))
     (define premises (list-refs sas is))
     (define rule (Axiom name premises))
     (Node0 rule)]
    
    [(list e4 e5) #:when (and (natural? e4) (natural? e5))
     (define indices (sexps->indices e))
     (define premises (list-refs sas indices))
     (define rule (Axiom name  premises))
     (Node0 rule)]
    
    [(list  e4 e5)   
     (define premises (sexps->signedformulas e))
     (define rule (Axiom name  premises))
     (Node0 rule)]
    [_ (error "sexp->proof/□ " name)]))


(: sexp->proof/□⊤ (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/□⊤ e sas rs)
  (define name "□⊤")
  (define sf (Goal (⊤)))
  (define (is-premise? sa) (equal? sa sf))
  (match e
    ['()
     (define i (index-of-formula? name is-premise? sas rs))
     (define premise (list-ref sas i))
     (define premises (list premise))
     (define rule (Axiom name premises))
     (Node0 rule)]
    
    
    [(list e3) #:when (sexp/index? e3)
     (define i (sexp->index e3))
     (define premise (list-ref sas i))
     (define premises (list premise))
     (define rule (Axiom name premises))
     (Node0 rule)]

    
    [(list  e3)
     ;  (define premise (sexp->signedformula e3))
     (define premises (sexps->signedformulas e))
     (define rule (Axiom name premises))
     (Node0 rule)]  
    [_ (error "sexp->proof/□⊤/" e)]))



(: sexp->proof/□⊥ (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/□⊥ e sas rs)
  (define name "□⊥")
  (define sf (Asmp (⊥)))
  (define (is-premise? sa) (equal? sa sf))
  (match e
    ['()
     (define i (index-of-formula? name  is-premise? sas   rs))
     (define premise (list-ref sas i))
     (define premises (list premise))
     (define rule (Axiom name premises))
     (Node0 rule)]
    
    [(list e3) #:when (sexp/index? e3)
     (define i (sexp->index e3))
     (define premise (list-ref sas i))
     (define premises (list premise))
     (define rule (Axiom name premises))
     (Node0 rule)]
    
    [(list e3)
     (define premises (sexps->signedformulas e))
     (define rule (Axiom name premises))
     (Node0 rule)]
    [_ (error "sexp->proof/□⊥/" e)]))

(: sexp->proof/Cut (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/Cut e sas rs)
  (define name "Cut")
  (match e
    
    [(list e1 e3 e4) #:when (sexp/index? e1)
     (define i1 (sexp->index e1))
     (define conclusion1 (list-ref sas i1))
     (define conclusion2 (convert-sf conclusion1))
     (define rule (Cut name conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e3 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e4 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]
    
    [(list e1 e3 e4)
     (define conclusion1 (sexp->signedformula e1))
     (define conclusion2 (convert-sf conclusion1))
     (define rule (Cut name conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e3 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e4 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]
    
    [(list e1 e2 e3 e4) #:when (and (sexp/index? e1) (sexp/index? e2))
     (define i1 (sexp->index e1))
     (define i2 (sexp->index e2))
     (define conclusion1 (list-ref sas i1))
     (define conclusion2 (list-ref sas i2))
     (define rule (Cut name conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e3 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e4 (list* conclusion2 sas) (list* rule rs)))
     (Node2 rule subproof1 subproof2)]

    
    [(list e1 e2 e3 e4)
     (define conclusion1 (sexp->signedformula e1))
     (define conclusion2 (sexp->signedformula e2))
     (define rule (Cut name conclusion1 conclusion2))
     (define subproof1 (sexp-w/rules->proof e3 (list* conclusion1 sas) (list* rule rs)))
     (define subproof2 (sexp-w/rules->proof e4 (list* conclusion2 sas) (list* rule rs))) 
     (Node2 rule subproof1 subproof2)]
    
    [_ (error "sexp->proof/cut/" e)]))



(: sexp->proof/∀a (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∀a e sas rs)
  (define name "∀a")

  (: get-variable/∀a (-> SignedFormula Term))
  (define (get-variable/∀a sf)
    (match sf
      [(Asmp a) (match a
                  [(∀ x b) x]
                  [_ (error "get-variable/∀a/" a)])]))
  
  (: is-premise? (-> SignedFormula Boolean))
  (define (is-premise? sf)
    (match sf
      [(Asmp a) (∀? a)]
      [_ #f]))

  
  (: make-conclusion (-> SignedFormula Term Term SignedFormula))
  (define (make-conclusion premise r s)
    (match premise
      [(Asmp sf)
       (define new (if (and (∀? sf) (equal? r (∀-variable sf)))  (∀-subformula sf) (error "make-conclusion/not" ∀)))
       (Asmp (substitute/formula new r s))]
      [_ (error "make-conclusion/")]))

  (match e

    
    [(list e1 e3 e4) #:when (sexp/index? e1)
     (define i (sexp->index e1))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∀a premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise  new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    [(list e1 e3 e4)
     (define premise (sexp->signedformula e1))     
     (define old-term (get-variable/∀a premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term  conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

     [(list e1 e2 e3 e4) #:when (sexp/index? e1)
     (define i (sexp->index e1))
     (define premise (list-ref sas i))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term  conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    
    [(list e1 e2 e3 e4)
     (define premise (sexp->signedformula e1))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term  conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    
    [_ (error "sexp->proof/∀a/" e)]))



(: sexp->proof/∃a (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∃a e sas rs)
  (define name "∃a")


 (: get-variable/∃a (-> SignedFormula Term))
  (define (get-variable/∃a sf)
    (match sf      
      [(Asmp a) (match a
                  [(∃ x b) x]
                  [_ (error "get-variable/a/" a)])]))

  
  (: is-premise? (-> SignedFormula Boolean))
  (define (is-premise? sf)
    (match sf
      [(Asmp sf) (∃? sf)]
      [_ #f]))

  
  (: make-conclusion (-> SignedFormula Term Term SignedFormula))
  (define (make-conclusion premise r s)
    (match premise
      [(Asmp sf)  (if (∃? sf) (Asmp (substitute/formula (∃-subformula sf) r s)) (error "make-conclusion/not" ∃))]
      [_ (error "make-conclusion/")]))
  
 
  (match e
     [(list e4)
     (define i (index-of-formula? name is-premise? sas rs))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∃a premise))
     (define new-term (Ht (signedformula->formula premise)))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    
;    [(list e3 e4) ; TODO maybe
;     (define i (index-of-formula? name  is-premise? sas  rs))
;     (define premise (list-ref sas i))
;     (define old-term (get-variable/∃a premise))
;     (define new-term (sexp->term e3))
;     (define conclusion (make-conclusion premise old-term new-term))
;     (define rule (Qrule name  premise new-term conclusion))
;     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
;     (Node1 rule subproof)]
    
;
    [(list e1 e3 e4) #:when (sexp/index? e1)
     (define i (sexp->index e1))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∃a premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term  conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    [(list e1 e3 e4)
     (define premise (sexp->signedformula e1))     
     (define old-term (get-variable/∃a premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]


    [(list e1 e2 e3 e4) #:when (sexp/index? e1)
     (define i (sexp->index e1))
     (define premise (list-ref sas i))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]


    [(list e1 e2 e3 e4)
     (define premise (sexp->signedformula e1))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    
    [_ (error "sexp->proof/∃a/" e)]))




(: sexp->proof/∀g (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∀g e sas rs)
  (define name "∀g")

  
 (: get-variable/∀g (-> SignedFormula Term))
  (define (get-variable/∀g sf)
    (match sf
      [(Goal a) (match a
                  [(∀ x b) x]
                  [_ (error "get-variable/∀g/" a)])]))
     
  
  (: is-premise? (-> SignedFormula Boolean))
  (define (is-premise? sf)
    (match sf
      [(Goal a) (∀? a)]
      [_ #f]))
  
  (: make-conclusion (-> SignedFormula Term Term SignedFormula))
  (define (make-conclusion premise r s)
    (match premise
      [(Goal sf)  (if (∀? sf) (Goal (substitute/formula (∀-subformula sf) r s)) (error "make-conclusion/not" ∀))]
      [_ (error "make-conclusion/")]))

  (match e
    [(list e4)
     (define i (index-of-formula? name is-premise? sas rs))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∀g premise))
     (define new-term (Ht (signedformula->formula premise)))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    
    [(list e3 e4) #:when (sexp/index? e3)
     (define i (sexp->index e3))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∀g premise))
     (define new-term (Ht (signedformula->formula premise)))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    
    [(list e3 e4) 
     (define premise (sexp->signedformula e3))
     (define old-term (get-variable/∀g premise))
     (define new-term (Ht (signedformula->formula premise)))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    
    [(list e1 e3 e4) #:when (sexp/index? e1)
     (define i (sexp->index e1))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∀g premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    [(list e1 e3 e4)
     (define premise (sexp->signedformula e1))     
     (define old-term (get-variable/∀g premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term  conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    [(list e1 e2 e3 e4) #:when (sexp/index? e1)
     (define i (sexp->index e1))
     (define premise (list-ref sas i))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    
    [(list e1 e2 e3 e4)
     (define premise (sexp->signedformula e1))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    [_ (error "sexp->proof/∀g/" e)]))


(: sexp->proof/∃g (-> Sexp SignedFormulas Rules Proof))
(define (sexp->proof/∃g e sas rs)
  (define name "∃g")

  
 (: get-variable/∃g (-> SignedFormula Term))
  (define (get-variable/∃g sf)
    (match sf
      [(Goal a) (match a
                  [(∃ x b) x]
                  [_ (error "get-variable/g/" a)])]))

  
  (: is-premise? (-> SignedFormula Boolean))
  (define (is-premise? sf)
    (match sf
      [(Goal sf) (∃? sf)]
      [_ #f]))

  
  (: make-conclusion (-> SignedFormula Term Term SignedFormula))
  (define (make-conclusion premise r s)
    (match premise
      [(Goal sf)
       (define new (if (and (∃? sf) (equal? r (∃-variable sf)))  (∃-subformula sf) (error "make-conclusion/not" ∀)))
       (Goal (substitute/formula new r s))]
      [_ (error "make-conclusion/")]))
  
  (match e

    [(list e3 e4)
     (define i (index-of-formula? name is-premise? sas rs))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∃g premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term  conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
;
;
    [(list e2 e3 e4)  #:when (sexp/index? e2)   
     (define i (sexp->index e2))
     (define premise (list-ref sas i))
     (define old-term (get-variable/∃g premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    
;    
    [(list e2 e3 e4)     
     (define premise (sexp->signedformula e2))
     (define old-term (get-variable/∃g premise))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term  conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    [(list e1 e2 e3 e4) #:when (sexp/index? e1)
     (define i (sexp->index e1))
     (define premise (list-ref sas i))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name  premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]

    
    [(list e1 e2 e3 e4)
     (define premise (sexp->signedformula e1))
     (define old-term (sexp->term e2))
     (define new-term (sexp->term e3))
     (define conclusion (make-conclusion premise old-term new-term))
     (define rule (Qrule name premise new-term conclusion))
     (define subproof (sexp-w/rules->proof e4 (list* conclusion sas) (list* rule rs)))
     (Node1 rule subproof)]
    [_ (error "sexp->proof/∃g/" e)]))




(: sexp-w/rules->proof (-> Sexp SignedFormulas Rules Proof)) ; UNFIN smart-sexp->proof
(define (sexp-w/rules->proof e sas rs)
  (match e
    ['■ (sexp->proof/■ '() sas rs)]
    [(list* '□ es) (sexp->proof/□ es sas rs)]
    [(list* '□⊤ es) (sexp->proof/□⊤ es sas rs)]
    [(list* '□⊥ es) (sexp->proof/□⊥ es sas rs)]
    [(list* '¬a es) (sexp->proof/¬a es sas rs)]
    [(list* '¬g es) (sexp->proof/¬g es sas rs)]
    [(list* '∧a1 es) (sexp->proof/∧a1 es sas rs)]
    [(list* '∧a2 es) (sexp->proof/∧a2 es sas rs)]
    [(list* '∧g es) (sexp->proof/∧g es sas rs)]
    [(list* '∨g1 es)(sexp->proof/∨g1 es sas rs)]
    [(list* '∨g2 es) (sexp->proof/∨g2 es sas rs)]
    [(list* '∨a es) (sexp->proof/∨a es sas rs)]
    [(list* '→g1 es) (sexp->proof/→g1 es sas rs)]
    [(list* '→g2 es) (sexp->proof/→g2 es sas rs)]
    [(list* '→a es) (sexp->proof/→a es sas rs)]
    [(list 'Cut es) (sexp->proof/Cut es sas rs)]
    [(list* '∀a es)  (sexp->proof/∀a es sas rs)]
    [(list* '∃a es)  (sexp->proof/∃a es sas rs)]
    [(list* '∀g es)  (sexp->proof/∀g es sas rs)]
    [(list* '∃g es)  (sexp->proof/∃g es sas rs)]
    ;   [(list* 'a es) (sexp->proof/a es sas rs)]
    ;  [(list* 'g es) (sexp->proof/g es sas rs)]
    [_ (error "sexp-w/rules->proof/" e)]))
    
(: sexp->proof (-> Sexp SignedFormulas Proof))
(define (sexp->proof e sas)
  (sexp-w/rules->proof e sas '()))
;symbolicky vyraz bude obsahovat len cast veci meno pravidla a index napr