#lang typed/racket ;#:no-optimize
;#lang typed/racket/no-check

(provide Index
         Indices        
         Arity
         Symbol
         )
(provide Term
         (struct-out Vt)
         (struct-out At)
         (struct-out Ht))

(provide Formula
         (struct-out Af)
         (struct-out ⊤)
         (struct-out ⊥)
         (struct-out ¬)
         (struct-out ∧)
         (struct-out ∨)
         (struct-out →)
         (struct-out ∃)
         (struct-out ∀))

(provide Terms
         is-formula?
         is-semiformula?
         is-semiterm?
         are-semiterms?
         is-term?)
;; symbols


(provide ;substitute
         is-henkin?
         depth/formula
         substitute/terms
         substitute/formula
         ;dr/formulas
         )


(define-type Arity Natural)
(define-type Index Natural)

(define-type Indices (Listof Index))
(define-type Symbol (Pairof Arity Index))

(: arity (-> Symbol Arity))
(define (arity symbol) (car symbol))


(define-type Term (U Vt At Ht))
(struct Vt ([index : Natural]) #:transparent)
(struct At ([function : Symbol] [arguments : Terms]) #:transparent) ; funkcia s n termami
(struct Ht ([index : Formula]) #:transparent) ; Henkin's constant


(define-type Terms (Listof Term))
;; formulas

(define-type Formula (U Af ⊤ ⊥ ¬ ∧ ∨ → ∃ ∀))
(struct Af ([predicate : Symbol] [arguments : Terms]) #:transparent)
(struct ⊤ () #:transparent)
(struct ⊥ () #:transparent)
(struct ¬ ([subformula : Formula]) #:transparent)
(struct ∧ ([subformula1 : Formula] [subformula2 : Formula]) #:transparent)
(struct ∨ ([subformula1 : Formula] [subformula2 : Formula]) #:transparent)
(struct → ([subformula1 : Formula] [subformula2 : Formula]) #:transparent)
(struct ∃ ([variable : Vt] [subformula : Formula]) #:transparent)
(struct ∀ ([variable : Vt] [subformula : Formula])  #:transparent)



;; size

(: is-quantifier-formula? (-> Formula Boolean))
(define (is-quantifier-formula? a)
  (or (∀? a) (∃? a)))

(: is-formula? (-> Formula Boolean)) ; semiformula so vsetkymi viazanymi premennymi
(define (is-formula? a)
  (is-closed-semiformula? a '()))

(: member? (-> Term Terms Boolean))
(define (member? t ts)
  (match ts
    ['() #f]
    [(list* t1 ts1) (if (equal? t t1) #t  (member? t (cdr ts)))]
    [_ (error "member?")]))

(: members? (-> Terms Terms Boolean))
(define (members? ts ts1)
  (match ts
    ['() #t]
    [(list t1) (member? t1 ts1)]
    [(list* t1 ts2) (and (member? t1 ts1) (members? (cdr ts) ts2))]
    [_ (error "members?")]))

(: is-henkin? (-> Term Boolean))
(define (is-henkin? t)
  (match t
    [(Ht _) #t]
    [_ #f]))


(: is-closed-semiformula? (-> Formula (Listof Vt) Boolean))
(define (is-closed-semiformula? a vars)
  (match a
    [(Af p ts) (not (members? ts vars))] ; even predicate symbol with arity 0 is formula
    [(⊤) #t]
    [(⊥) #t]
    [(¬ b) (is-closed-semiformula? b vars)]
    [(∧ b c) (and (is-closed-semiformula? b vars) (is-closed-semiformula? c vars))]
    [(∨ b c) (and (is-closed-semiformula? b vars) (is-closed-semiformula? c vars))]
    [(→ b c) (and (is-closed-semiformula? b vars) (is-closed-semiformula? c vars))]
    [(∃ x b) (is-closed-semiformula? b (list* x vars))]
    [(∀ x b) (is-closed-semiformula? b (list* x vars))]
    [_ #f]))


(: is-semiformula? (-> Formula Boolean))
(define (is-semiformula? a)
  (match a
    [(Af p ts)
     (define n (length ts))
     (and (= (arity p) n) (are-semiterms? ts))]
    [(⊤) #t]
    [(⊥) #t]
    [(¬ b) (is-semiformula? b)]
    [(∧ b c) (are-semiformulas? (list b c))]
    [(∨ b c)  (are-semiformulas? (list b c))]
    [(→ b c) (are-semiformulas? (list b c))]
    [(∃ x b) (is-semiformula? b)]
    [(∀ x b) (is-semiformula? b)]    
    [_ #f]))


(: are-semiformulas? (-> (Listof Formula) Boolean))
(define (are-semiformulas? sfs)
  (match sfs
    ['() #t]
    [(list* sf sfs1) (is-semiformula? sf) (are-semiformulas? sfs1)]))


(: are-semiterms? (-> Terms Boolean))
(define (are-semiterms? ts)
  (match ts
    ['() #t]
    [(list* t ts1) (is-semiterm? t) (are-semiterms? ts1)]))

(: is-semiterm? (-> Term Boolean))
(define (is-semiterm? t)
  (match t
    [(Vt _) #t]
    [(At f ts)
     (define n (length ts))
     (and (= (arity f) n) (are-semiterms? ts) )]
    [(Ht a) (and (is-quantifier-formula? a) (is-formula? a))]
    [_ (error "is-semiterm?")]))

(: is-term? (-> Term Boolean))
(define (is-term? t)
  (is-closed-semiterm? t))

(: is-closed-semiterm? (-> Term Boolean))
(define (is-closed-semiterm? t)
  (match t
    [(Vt _) #t]
    [(Af f ts) (empty? ts)]
    [(Ht a) (is-formula? a)]
    [_ #f]))


(: size/formula (-> Formula Natural))
(define (size/formula a)
  (match a
    [(At f ts) 1]
    [(⊤) 1]
    [(⊥) 1]
    [(¬ b) (+ (size/formula b) 1)]
    [(∧ b c) (+ (size/formula b) (size/formula c))]
    [(∨ b c) (+ (size/formula b) (size/formula c))]
    [(→ b c) (+ (size/formula b) (size/formula c))]
    [(∃ x b) (size/formula b)]
    [(∀ x b) (size/formula b)]))




(: substitute/terms (-> Terms Term Term Terms))
(define (substitute/terms ts r s)
  (match ts
    ['() ts]
    [(list* t ts1)
     (define new-term (if (equal? t r) s t))
     (list* new-term (substitute/terms ts1 r s))]
    [_ (error "replaceterm/")]))

(: substitute/formula (-> Formula Term Term Formula))
(define (substitute/formula a r s)
  (match a
    [(Af p ts)  (Af p (substitute/terms ts r s))]
    [(¬ b) (¬ (substitute/formula b r s))]
    [(∧ b c) (∧ (substitute/formula b r s) (substitute/formula c r s))]
    [(∨ b c) (∨ (substitute/formula b r s) (substitute/formula c r s))]
    [(→ b c)  (→ (substitute/formula b r s) (substitute/formula c r s)) ]
    [(∃ x b) (∃ x (substitute/formula b r s))]
    [(∀ x b) (∀ x (substitute/formula b r s))]
    [_ (error "substitute/formula/" a "/" "E{" r "/" s "}")]))


(: depth/formula (-> Formula Natural))
(define (depth/formula a)
  (match a
    [(Af _ _) 1]
    [(⊤) 1]
    [(⊥) 1]
    [(¬ b) (+ (depth/formula b) 1)]
    [(∧ b c) (max (+ (depth/formula b) (depth/formula c)) 1)]
    [(∨ b c) (max (+ (depth/formula b) (depth/formula c)) 1)]
    [(→ b c) (max (+ (depth/formula b) (depth/formula c)) 1)]    
    [(∃ x b) (+ (depth/formula b) 1)]
    [(∀ x b) (+ (depth/formula b) 1)]    
    [_ (error "depth/formula")]))



;(size/formula A1)

;; the depth of a formula

;(: depth/formula (-> Formula Natural))
;(define (depth/formula a)
;  999)
