#lang typed/racket ;#:no-optimize
;#lang typed/racket/no-check


(require "expr.rkt")

(provide SignedFormula SignedFormulas
         (struct-out Asmp)
         (struct-out Goal))

(provide Rule Rules
         Name
         (struct-out ■)
         (struct-out Axiom)
         (struct-out Prule1)
         (struct-out Qrule)
         (struct-out Prule2)
         (struct-out Cut))

(provide Proof
         (struct-out Node0)
         (struct-out Node1)
         (struct-out Node2))

(provide is-proof?
         member?
         members?
         is-signedformula?
         signedformula->formula
         dr/signedformulas
         dr/signedformula
         dr/formula
         dr/proof
         )
;; signed formulas

(define-type SignedFormula (U Asmp Goal))
(struct Asmp ([formula : Formula]) #:transparent ) 
(struct Goal ([formula : Formula]) #:transparent )  

(define-type SignedFormulas (Listof SignedFormula))
;aj bez pattern matchingu sa da

(: signedformula->formula (-> SignedFormula Formula))
(define (signedformula->formula sf)
  (match sf
    [(Asmp a) a]
    [(Goal a) a]))

;; rules
(: is-signedformula? (-> SignedFormula Boolean))
(define (is-signedformula? sf)
  (match sf
    [(Asmp a)  (is-formula? a)]
    [(Goal a) (is-formula? a)]))

(: are-signedformulas? (-> SignedFormulas Boolean))
(define (are-signedformulas? sfs)
  (match sfs
    ['() #t]
    [(list sf)  (is-signedformula? sf)]
    [(list* sf sfs1) (and (is-signedformula? sf) (are-signedformulas? sfs1))]))

;pripocitavame pri indexe

(define-type Rule (U ■ Axiom Prule1 Qrule Prule2 Cut))
(define-type Rules (Listof Rule))
(define-type Name String);pravidlo premisa zaver a meno
(struct ■ () #:transparent)
(struct Axiom ([name : Name]
               [premises : SignedFormulas])
  #:transparent);pravidlo uzaveru
(struct Prule1 ([name : Name]
                [premise : SignedFormula] ; z jednej formuly vznikne 1 formula
                [conclusion : SignedFormula])
  #:transparent)
(struct Prule2 ([name : Name]
                [premise : SignedFormula]
                [conclusion1 : SignedFormula]
                [conclusion2 : SignedFormula]) ;z jednej formuly vzniknu 2 formuly
  #:transparent)



(struct Qrule ([name : Name] ;kvantifikacne pravidlo
               [premise : SignedFormula]
               [term : Term]
               [conclusion : SignedFormula])
  #:transparent)


(struct Cut ([name : Name] ; strukturalne pravidlo 
             [conclusion1 : SignedFormula]
             [conclusion2 : SignedFormula]) ; mozno aj meno pridat 
  #:transparent)


(: member? (-> Any (Listof Any) Boolean))
(define (member? sf sas)
  (match sas
    [(list* sf1 sfs) (if (equal? sf1 sf) #t (member? sf (cdr sas)))]
    [_ #f]))

(: members?(-> (Listof Any) (Listof Any) Boolean))
(define (members? sfs sas)
  (if (empty? sfs) #t
      (and (member? (car sfs) sas) (members? (cdr sfs) sas))))


(: is-rule/□? (-> SignedFormulas Boolean))
(define (is-rule/□? premises) 
;(displayln "□")
  (and (are-signedformulas? premises)
  (match premises  
    [(list (Asmp a) (Goal a)) #t]
    [_ #f])))
;
(: is-rule/□⊤? (-> SignedFormulas Boolean))
(define (is-rule/□⊤? premises)
 ; (displayln "□⊤")
  (and (are-signedformulas? premises)
  (match premises
    [(list (Goal (⊤))) #t]
    [_ #f])))
;
(: is-rule/□⊥? (-> SignedFormulas Boolean))
(define (is-rule/□⊥? premises)
;(displayln "□⊥")
  (and (are-signedformulas? premises)
  (match premises
    [(list (Asmp  (⊥)))  #t]
    [_ #f])))


(: is-rule/¬a? (-> SignedFormula SignedFormula Boolean))
(define (is-rule/¬a? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Asmp (¬ a))
     (equal? conclusion (Goal a))]
    [_ #f])))
;
(: is-rule/¬g? (-> SignedFormula SignedFormula Boolean))
(define (is-rule/¬g? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Goal (¬ a))
     (equal? conclusion (Asmp a))]
    [_ #f])))

(: is-rule/∧a1? (->  SignedFormula SignedFormula Boolean))
(define (is-rule/∧a1? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Asmp (∧ a b))
     (equal? conclusion (Asmp a))] 
    [_ #f])))
;
(: is-rule/∧a2? (->  SignedFormula SignedFormula Boolean))
(define (is-rule/∧a2? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Asmp (∧ a b))
     (define subformula2 (Asmp b))
     (equal? conclusion (Asmp b))]
    [_ #f])))

(: is-rule/∧g? (-> SignedFormula SignedFormula SignedFormula Boolean))
(define (is-rule/∧g? premise conclusion1 conclusion2)
  (and (is-signedformula? premise)
  (match premise
    [(Goal (∧ a b))
     (and (equal? conclusion1 (Goal a))
          (equal? conclusion2 (Goal b)))]
    [_ #f])))

(: is-rule/∨a? (-> SignedFormula SignedFormula SignedFormula Boolean))
(define (is-rule/∨a? premise conclusion1 conclusion2)
  (and (is-signedformula? premise)
  (match premise
    [(Asmp (∨ a b))
     (and (equal? conclusion1 (Asmp a))
          (equal? conclusion2 (Asmp b)))]
    [_ #f])))
;
(: is-rule/∨g1? (-> SignedFormula SignedFormula Boolean))
(define (is-rule/∨g1? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Goal (∨ a b)) (equal? conclusion (Goal a))] 
    [_ #f])))
;
(: is-rule/∨g2? (-> SignedFormula SignedFormula Boolean))
(define (is-rule/∨g2? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Goal (∨ a b)) (equal? conclusion (Goal b))] 
    [_ #f])))

(: is-rule/→a? (-> SignedFormula SignedFormula SignedFormula Boolean))
(define (is-rule/→a? premise conclusion1 conclusion2)
  (and (is-signedformula? premise)
  (match premise
    [(Asmp (→ a b))
     (and (equal? conclusion1 (Goal a))
          (equal? conclusion2 (Asmp b)))]
    [_ #f])))

(: is-rule/→g1? (-> SignedFormula SignedFormula Boolean)) 
(define (is-rule/→g1? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Goal (→ a b)) (equal? conclusion (Asmp a))] 
    [_ #f])))
;
(: is-rule/→g2? (-> SignedFormula SignedFormula Boolean))
(define (is-rule/→g2? premise conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Goal (→ a b)) (equal? conclusion (Goal b))] 
    [_ #f])))


;rules without henkin constants

(: dr/terms (-> Terms Term Term Terms))
(define (dr/terms ts r s)
  (match ts    
    ['() ts]
    [(list* (Ht f) ts1)   (list* (Ht (dr/formula f r s)) (dr/terms ts1 r s))]
    [(list* t ts1)
     (define new-term (if (equal? t r) s t))
     (list* new-term (dr/terms ts1 r s))]
    [_ (error "dr/terms/" "/" "E{" r "/" s "}")]))


(: dr/formula (-> Formula Term Term Formula))
(define (dr/formula a r s)
  (match a
    [(Af p ts) 
     (Af p (dr/terms ts r s))]
    [(¬ b) (¬ (dr/formula b r s))]
    [(∧ b c) (∧ (dr/formula b r s) (dr/formula c r s))]
    [(∨ b c) (∨ (dr/formula b r s) (dr/formula c r s))]
    [(→ b c)  (→ (dr/formula b r s) (dr/formula c r s))]
    [(∃ x b) (∃ x (dr/formula b r s))]
    [(∀ x b) (∀ x (dr/formula b r s))]
    [_ (error "dr/formula/" a "/" "E{" r "/" s "}")]))




(: dr/formulas (-> (Listof Formula) Term Term (Listof Formula)))
(define (dr/formulas sfs r s)
  (match sfs
    ['() sfs]
    [(list* sf sfs1) (list* (dr/formula sf r s) (dr/formulas sfs1 r s))]
    [_ (error "dr/formulas")]))

(: dr/signedformula (-> SignedFormula Term Term SignedFormula))
(define (dr/signedformula sf r s)
  (match sf
    [(Goal a) (Goal (dr/formula a r s))]
    [(Asmp a) (Asmp (dr/formula a r s))]
    [_ (error "dr/signedformula")] ))

(: dr/signedformulas (-> (Listof SignedFormula) Term Term (Listof SignedFormula)))
(define (dr/signedformulas sfs r s)
  (match sfs
    ['() sfs]
    [(list* sf sfs1) (list* (dr/signedformula sf r s) (dr/signedformulas sfs1 r s))]
    [_ (error "dr/formulas")]))




(: dr/rule (-> Rule Term Term Rule))
(define (dr/rule rule r s)
  (match rule
    [(■) rule]
    [(Axiom name premises) (Axiom name (dr/signedformulas premises r s))]
    [(Prule1 name premise conclusion) (Prule1 name (dr/signedformula premise r s) (dr/signedformula conclusion r s))]
    [(Qrule name premise term conclusion) (Qrule name
                                                 (dr/signedformula premise r s)
                                                 (if (equal? term s) s term)
                                                 (dr/signedformula conclusion r s))]
    [(Prule2 name premise conclusion1 conclusion2) (Prule2 name
                                                           (dr/signedformula premise r s)
                                                           (dr/signedformula conclusion1 r s)
                                                           (dr/signedformula conclusion2 r s))]
    [_ (error "dr/rule")]))


(: dr/proof (-> Proof Term Term Proof))
(define (dr/proof p r s)
 (match p
   [(Node0 rule) (Node0 (dr/rule rule r s))]
   [(Node1 rule p1) (Node1 (dr/rule rule r s) (dr/proof p1 r s))]
   [(Node2 rule p1 p2) (Node2 (dr/rule rule r s) (dr/proof p1 r s) (dr/proof p2 r s))]
   [_ (error "dr/proof")]))





(: is-rule/∃a? (-> SignedFormula Term SignedFormula Boolean))
(define (is-rule/∃a? premise t conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Asmp a) (match a
                [(∃ x b) (equal? (substitute/formula b x t) conclusion)];(equal? (dr/formula b x t) conclusion)]
                [_ #f])]
    [_ #f])))


(: is-rule/∀g? (-> SignedFormula Term SignedFormula Boolean))
(define (is-rule/∀g? premise t conclusion)
  (and (is-signedformula? premise)
  (match premise
    [(Goal a) (match a
                [(∀ x b) (equal? (substitute/formula b x t) conclusion)];(equal? (dr/formula b x t) conclusion)]
                [_ #f])]
    [_ #f])))


;rules with henkin constants
(: is-rule/∃g? (-> SignedFormula Term SignedFormula Boolean))
(define (is-rule/∃g? premise t conclusion)
  (and (is-signedformula? premise) (is-henkin? t)
  (match premise
    [(Goal a) (match a
                [(∃ x b) (equal? (substitute/formula b x t) conclusion)]
                [_ #f])];(equal? (dr/formula b x t) conclusion)])]
    [_ #f])))


(: is-rule/∀a? (-> SignedFormula Term SignedFormula Boolean))
(define (is-rule/∀a? premise t conclusion)
  (and (is-signedformula? premise) (is-henkin? t)
  (match premise
    [(Asmp a) (match a
                [(∀ x b) (equal? (substitute/formula b x t) conclusion)];(equal? (dr/formula b x t) conclusion)]
                [_ #f])]
    [_ #f])))





;cut rule
(: is-rule/Cut? (-> SignedFormula SignedFormula Boolean))
(define (is-rule/Cut? conclusion1 conclusion2)
 (and (Goal? conclusion1) (Asmp? conclusion2) (equal? (Goal-formula conclusion1) (Asmp-formula conclusion2))))

(: is-axiom?
   (-> Name SignedFormulas SignedFormulas
       Boolean))
(define (is-axiom? name  premises sas)
  (define n (length sas))
  (: check? (-> (-> SignedFormulas Boolean) Boolean))
  (define (check? is-rule/*?)
    (and (is-rule/*? premises)
         (members? premises sas)))
  
  (match name
    ["□" (check? is-rule/□?)]
    ["□⊤" (check? is-rule/□⊤?)]
    ["□⊥" (check? is-rule/□⊥?)]
    [_ (error "axiom? " name)]))

(: is-prule1? ; nevetvi pravidlo
   (-> Name SignedFormula SignedFormula SignedFormulas
       Boolean))
(define (is-prule1? name premise conclusion sas)
  (: check? (-> (-> SignedFormula SignedFormula Boolean) Boolean))
  (define n (length sas))
  (define (check? is-rule/*? )
    (and (is-rule/*? premise conclusion)
         (member? premise sas)))
  (match name
    ["¬a" ;(displayln "¬a")       
          (check? is-rule/¬a?)]
    ["¬g" ;(displayln "¬g")
          (check? is-rule/¬g? )]
    ["∧a1" ;(displayln "∧a1")
           (check? is-rule/∧a1?)]
    ["∧a2" ;(displayln "∧a2")
           (check? is-rule/∧a2?)]
    ["∨g1" ;(displayln "∨g1")
           (check? is-rule/∨g1?)]
    ["∨g2" ;(displayln "∨g2")
           (check? is-rule/∨g2?)]
    ["→g1" ;(displayln "→g1")
           (check? is-rule/→g1?)]
    ["→g2" ;(displayln "→g2")
           (check? is-rule/→g2?)]
    [_ (error "prule1? " name)]))

(: is-prule2? ; ci vetvi pravidlo 
   (-> Name SignedFormula SignedFormula SignedFormula SignedFormulas
       Boolean))
(define (is-prule2? name premise conclusion1 conclusion2 sas)
  (: check? (-> (-> SignedFormula SignedFormula SignedFormula Boolean) Boolean))
  (define n (length sas))
  (define (check? is-rule/*? )
    (and (is-rule/*? premise conclusion1 conclusion2)
         (member? premise sas)))
  (match name
    ["∧g" ;(displayln "∧g")
          (check? is-rule/∧g?)]
    ["∨a" ;(displayln "∨a")
          (check? is-rule/∨a?)]
    ["→a" 
          (check? is-rule/→a?)]
    [_ (error  "is-binary-propositional-rule?" name)]))


(: is-qrule? (-> Name SignedFormula Term SignedFormula SignedFormulas Boolean))
(define (is-qrule? name premise t conclusion sas)
  (: check? (-> (-> SignedFormula Term SignedFormula Boolean) Boolean))
  (define (check? is-rule/*?)
    (and (is-rule/*? premise t conclusion)
     (member? premise sas)))
  (match name
    ["∃a" (check? is-rule/∃a?)]
    ["∀g" (check? is-rule/∀g?)]
    ["∀a" (check? is-rule/∀a?)]
    ["∃g" (check? is-rule/∃g?)]    
    [_ #f]))


(: is-cut? (-> Name SignedFormula SignedFormula SignedFormulas Boolean))
(define (is-cut? name conclusion1 conclusion2 sas)
  (: check? (-> (-> SignedFormula SignedFormula Boolean) Boolean))
  (define n (length sas))
  (define (check? is-rule/*?)
    (and (is-rule/*? conclusion1 conclusion2)
       ;  (member? conclusion1 sas)
         ))
  (match name
    ["Cut" (check?  is-rule/Cut?)]
    [_ (error "is-cut?" name)]))
;; proofs

(define-type Proof (U Node0 Node1 Node2))
(struct Node0 ([rule : Rule]) #:transparent)
(struct Node1 ([rule : Rule] [subproof : Proof]) #:transparent)
(struct Node2 ([rule : Rule] [subproof1 : Proof] [subproof2 : Proof]) #:transparent)

(Node0? 'a)


(: is-node0-rule? (-> Rule SignedFormulas Boolean))
(define (is-node0-rule? rule sas)
  (match rule
    [(■) #t]
    [(Axiom name premises)
     (is-axiom? name  premises sas)]
    [_ (error "is-node0-rule?" rule)]))

(: is-node1-rule? (-> Rule SignedFormulas Boolean))
(define (is-node1-rule? rule sas)
  (match rule
    [(Prule1 name premise conclusion)
     (is-prule1? name  premise conclusion sas)]; is-prule1?
    [(Qrule name premise term conclusion)
     (is-qrule? name premise term conclusion sas)]
    [_ (error "is-node1-rule?" rule)]))

(: node1-rule->conclusion (-> Rule SignedFormula))
(define (node1-rule->conclusion rule)
  (match rule
    [(Prule1 _1 _2  conclusion) conclusion]
    [_ (error "node1-rule->conclusion" rule)]))

(: is-node2-rule? (-> Rule SignedFormulas Boolean))
(define (is-node2-rule? rule sas)
  (match rule
    [(Prule2 name  premise conclusion1 conclusion2)
     (is-prule2? name  premise conclusion1 conclusion2 sas)]
    [(Cut name conclusion1 conclusion2)
     (is-cut? name conclusion1 conclusion2 sas)]
    [_ (error "is-node2-rule?" rule)]))

(: node2-rule->conclusions (-> Rule (Values SignedFormula SignedFormula)))
(define (node2-rule->conclusions rule)
  (match rule
    [(Prule2 _1 _2  conclusion1 conclusion2) (values conclusion1 conclusion2)]
    [(Cut _2 conclusion1 conclusion2) (values conclusion1 conclusion2)]
    [_ (error "node2-rule->conclusions" rule)]))

(: is-proof? (-> Proof SignedFormulas Boolean))
(define (is-proof? p sas)
  (match p
    [(Node0 rule)
     (is-node0-rule? rule sas)]
    [(Node1 rule p1)
     (and (is-node1-rule? rule sas)
          (is-proof? p1 (list* (node1-rule->conclusion rule) sas)))]
    [(Node2 rule p1 p2)
     (and (is-node2-rule? rule sas)
          (let-values ([(conclusion1 conclusion2) (node2-rule->conclusions rule)])
            (is-proof? p1 (list* conclusion1 sas))
            (is-proof? p2 (list* conclusion2 sas))))]))


