#ifndef FORD_FULKERSON
#define FORD_FULKERSON

#include <iostream> 
#include <limits.h> 
#include <string.h> 
#include <queue> 
#include <vector>
#include <chrono>
using namespace std;
using namespace std::chrono;


/// <summary>
/// Najde cestu zo zdroja - 0, do ustia - graph.size() - 1, pricom naplni cestu parent,
/// ktora kazdemu vrcholu hovori, kto je jeho rodic.
/// </summary>
/// <param name="graph">Graf na ktorom ma byt spustene bfs</param>
/// <param name="parent">Premenna do ktorej sa vpisu rodicia</param>
/// <returns>Ci existuje cesta zo zaciatku az na koniec</returns>
bool bfs_ff(std::vector < std::vector<pair<int, int>>> graph, std::vector<int>  &parent) {
    
    std::vector<bool> visited;
    visited.assign(graph.size(), false);
    std::queue<int> fifo;
    fifo.push(0);//predpokladame, ze graf ma aspon jeden vrchol
    visited.at(0) = true;

    while (!fifo.empty()) {
        int vertex = fifo.front();
        fifo.pop();
        for (int i = 0; i < graph.at(vertex).size(); i++) {
            if (!visited.at(graph.at(vertex).at(i).first) && (graph.at(vertex).at(i).second > 0)) {
                fifo.push(graph.at(vertex).at(i).first);
                parent.at(graph.at(vertex).at(i).first) = vertex;
                visited.at(graph.at(vertex).at(i).first) = true;
            }
        }
    }

    return visited.at(graph.size()-1);
}

/// <summary>
/// Spusti Ford-Fulkersonov algoritmus na vstupnom grafe.
/// </summary>
/// <param name="graph">Graf na ktorm ma byt spusteny Fros-Fulkersonov algoritmus</param>
/// <returns>Hodnotu maximalneho toku</returns>
int ford_fulkerson_max_flown(std::vector<std::vector<pair<int,int>>> graph) {

    std::vector<int> parent;
    parent.assign(graph.size(), -1);
    int overall_max_flow = 0; 

    //budeme robit cyklus dokedy bude existovat najaka cesta zo zdroja do ustia
    while (bfs_ff(graph, parent)) { 
        int path_flow = INT_MAX;
        int i = parent.size() - 1;
        //najde sa v grafe pomocou rodicov na ceste ktoru naslo bfs hrana s najnizsou priepustnostou
        while (i != 0) {
            for (int j = 0; j < graph.at(parent.at(i)).size(); j++) {
                if (graph.at(parent.at(i)).at(j).first == i) {
                    path_flow = min(path_flow, graph.at(parent.at(i)).at(j).second);
                    i = parent.at(i);
                    break;
                }
            }
        }
        //pomocou najdenej priepustinosti sa znizi na kazdej hrane na najdenej ceste
        //a zaroven sa na opacnej hrane na tejto ceste o path_flow
        i = parent.size() - 1;
        while (i != 0) {
            int new_i = 0;
            for (int j = 0; j < graph.at(parent.at(i)).size(); j++) {
                if (graph.at(parent.at(i)).at(j).first == i) {
                    
                    if (graph.at(parent.at(i)).at(j).second == path_flow) {
                        graph.at(parent.at(i)).erase(graph.at(parent.at(i)).begin() + j);
                    }
                    else {
                        graph.at(parent.at(i)).at(j).second -= path_flow;
                    }
                    new_i = parent.at(i);
                    break;
                }
            }

            bool changed_reversed = false;
            for (int j = 0; j < graph.at(i).size(); j++) {
                if (graph.at(i).at(j).first == parent.at(i)) {
                    graph.at(i).at(j).second += path_flow;
                    changed_reversed = true;
                    break;
                }
            }
            if (!changed_reversed) {
                graph.at(i).push_back(pair<int, int>(parent.at(i), path_flow));
            }
            i = new_i;
        }

        // pridat tok tejto cesty k celkovemu toku
        overall_max_flow += path_flow;
    }

    return overall_max_flow;
}

/// <summary>
/// Spusti Ford-Fulkersonov algoritmus, a zisti aky dlhy cas trval
/// </summary>
/// <param name="graph">Graf na ktorom ma byt spusteny</param>
/// <returns>Cas v mikrosekundach, kolko trval tento algoritmus</returns>
long long ford_fulkerson_max_flow_time(std::vector<std::vector<pair<int, int>>> graph) {
    std::vector<int> parent;
    parent.assign(graph.size(), -1);
    int overall_max_flow = 0;

    auto time_start = high_resolution_clock::now();

    while (bfs_ff(graph, parent)) {
        int path_flow = INT_MAX;
        int i = parent.size() - 1;
        while (i != 0) {
            for (int j = 0; j < graph.at(parent.at(i)).size(); j++) {
                if (graph.at(parent.at(i)).at(j).first == i) {
                    path_flow = min(path_flow, graph.at(parent.at(i)).at(j).second);
                    i = parent.at(i);
                    break;
                }
            }
        }
        i = parent.size() - 1;
        while (i != 0) {
            int new_i = 0;
            for (int j = 0; j < graph.at(parent.at(i)).size(); j++) {
                if (graph.at(parent.at(i)).at(j).first == i) {
                    if (graph.at(parent.at(i)).at(j).second == path_flow) {
                        graph.at(parent.at(i)).erase(graph.at(parent.at(i)).begin() + j);
                    }
                    else {
                        graph.at(parent.at(i)).at(j).second -= path_flow;
                    }
                    new_i = parent.at(i);
                    break;
                }
            }
            bool changed_reversed = false;
            for (int j = 0; j < graph.at(i).size(); j++) {
                if (graph.at(i).at(j).first == parent.at(i)) {
                    graph.at(i).at(j).second += path_flow;
                    changed_reversed = true;
                    break;
                }
            }
            if (!changed_reversed) {
                graph.at(i).push_back(pair<int, int>(parent.at(i), path_flow));
            }
            i = new_i;
        }
        overall_max_flow += path_flow;
    }
    auto time_stop = high_resolution_clock::now();
    auto duration = duration_cast<microseconds>(time_stop - time_start);
    return duration.count();
}

#endif // !FORD_FULKERSON




