#ifndef GRAPH_TESTER
#define GRAPH_TESTER

#include "ford_fulkerson.hpp"
//#include "dinic.hpp"
//#include "malhotra_pramodh-kumar_maheshwari.hpp"
#include "lp_solver_max_flow.hpp"
#include <string>
#include <iostream>
#include <fstream>
using namespace std;

long long whole_time = 0;
long long lp_time = 0;

/// <summary>
/// V otvorenom subore precita vsetky grafy a vyskusa ich zdanym algoritmom
/// </summary>
/// <param name="type">Typ algoritmu</param>
/// <param name="filename">Nazov suboru</param>
void test_file_type(string type, string filename) {
	
	whole_time = 0;
	lp_time = 0;
	
	ifstream graph_file(filename);
	int graph_num = -1;
	graph_file >> graph_num;
	for (int i = 0; i < graph_num; i++) {
		int graph_size;
		graph_file >> graph_size;
		std::vector<std::vector<std::pair<int, int>>> graph;
		graph.resize(graph_size, std::vector<std::pair<int, int>>());
		for (int j = 0; j < graph_size; j++) {
			int vector_edges;
			graph_file >> vector_edges;
			for (int k = 0; k < vector_edges; k++) {
				int edge_end, edge_capacity;
				graph_file >> edge_end;
				graph_file >> edge_capacity;
				graph.at(j).push_back({ edge_end,edge_capacity });
			}
		}
		if (type.compare("ff") == 0) {
			//whole_time += ford_fulkerson_max_flow_time(graph);
			cout << ford_fulkerson_max_flown(graph) << endl;
		}
		else if (type.compare("d") == 0) {
			//whole_time += dinic_max_flow_time(graph);
		}
		else if (type.compare("mpm") == 0) {
			//whole_time += malhotra_ramodhkumar_maheshwari_max_flow_time(graph);
		}
		else if (type.compare("lp") == 0){
			std::pair<long, long> t = lp_solver_max_flow_time(graph);
			whole_time += t.first;
			lp_time += t.second;
		}
		else {
			//chyba
		}
	}
	if (type.compare("lp") == 0) {
		std::cout << "[" << whole_time << "," << lp_time << "] ";
	}
	else {
		std::cout << whole_time << " ";
	}
	graph_file.close();
}

/// <summary>
/// Ak uz boli vytvorene subory s grafmi, tak vyskusa na nich dany algoritmus
/// </summary>
/// <param name="alg_type">Typ algoritmu</param>
void test_alg_type(string alg_type) {
	ofstream result_file("vysledok");
	
	std::cout << "random_sparsity_edges_graphs" << endl;
	string rseg = "rseg5-___";
	for (int vert_num = 50; vert_num <= 100; vert_num++) {
		rseg[6] = (vert_num / 100) + '0';
		rseg[7] = ((vert_num % 100) / 10) + '0';
		rseg[8] = (vert_num % 10) + '0';
		test_file_type(alg_type, rseg);
		result_file << " [" << whole_time << "," << lp_time << "]" << endl;
		
		std::cout << endl;
	}
	
	
	std::cout << "random_sparsity_graphs" << endl;
	string rsg = "rsg__-___";
	for (int sparsity = 3; sparsity <= 9; sparsity++) {
		rsg[3] = (sparsity / 10) + '0';
		rsg[4] = (sparsity % 10) + '0';
		for (int vert_num = 50; vert_num <= 100; vert_num += 5) {
			rsg[6] = (vert_num / 100) + '0';
			rsg[7] = ((vert_num % 100) / 10) + '0';
			rsg[8] = (vert_num % 10) + '0';
			test_file_type(alg_type, rsg);
			result_file << " [" << whole_time << "," << lp_time << "]";
		}
		std::cout << endl;
		result_file << endl;
	}
	
	result_file.close();
}


#endif // !GRAPH_TESTER