#ifndef LP_SOLVER_MAX_FLOW
#define LP_SOLVER_MAX_FLOW

#include <iostream> 
#include <limits.h> 
#include <string.h> 
#include <queue> 
#include <vector>
#include <utility>
#include <map>
#include <chrono>
#include "lphelper.hpp"

using namespace std;
using namespace std::chrono;

/// <summary>
/// Na danom grafe najde vsetky cesty, a pomocou nich vytvori obmedzenia pre LP.
/// Vrati maximalny tok na danom grafe.
/// </summary>
/// <param name="graph">Graf na ktorom sa ma spustit dany algoritmus</param>
/// <returns>Maximalny tok</returns>
int lp_solver_max_flow(std::vector<std::vector<pair<int,int>>> graph) { 

	//na prvom mieste je  min na ceste, na druhej je cela cesta
	std::queue <std::vector<int>> fifo; //pre bfs

	std::vector<int> source_path;
	source_path.push_back(0);
	std::vector<int> source;
	source.push_back(0);
	fifo.push(source);

	//v tomto su zapamatane vsetky cesty ktore sa dostali do ustia
	std::vector<std::vector<int>> finished_paths;
	//tu je zapamatane ake su ohranicenia ciest - najmenej priespustna hrana na danej ceste
	std::vector<int> min_constraint_finished_paths;

	while (!fifo.empty()) {
		std::vector<int> vertex = fifo.front();
		fifo.pop();
		for (int i = 0; i < graph.at(vertex.at(vertex.size()-1)).size(); i++) {
			std::vector<int> new_vertex(vertex);
			new_vertex.push_back(graph.at(vertex.at(vertex.size()-1)).at(i).first);
			fifo.push(new_vertex);
		}

		//prave sme sa dostali do ustia, zapamatame si danu cestu
		if (vertex.at(vertex.size()-1) == (graph.size() - 1)) {
			finished_paths.push_back(vertex);
			//if (finished_paths.size() > 1000000) {
			//	//alebo nejake ine cislo, jednoducho ked to uz bude priamo na solver - 
			//	return -2;
			//}
		}
	}
	//v tomto si pamatame ktore cesti isli cez ktoru hranu - len z tych, ktore sa dostali do ustia
	//		 hrana od  do    cesty cez nu
	std::map<pair<int, int>, vector<int>> visited_edges_by;

	//ak je skoncenych ciest 0, tak to treba hned ukoncit -> neda sa vlozit 0 stlcov do ilp (resp. sa neda s tym nic maximalizovat)
	if (finished_paths.empty()) {
		return 0;
	}

	//najskor je potrebne pre  kazdu pouzitu hranu zistit vsetky cesty ktore cez nu isli
	for (int i = 0; i < finished_paths.size(); i++) {
		int min = INT_MAX;
		for (int j = 1; j < finished_paths.at(i).size(); j++) {

			pair<int, int> edge(finished_paths.at(i).at(j-1), finished_paths.at(i).at(j));

			if (visited_edges_by.find(edge) == visited_edges_by.end()) {//pridat vector (este tam nebol pre sanu hranu vlozeny vector)
				std::vector<int> paths_through;
				paths_through.push_back(i + 1);//cesty si pamatame o jedno vacsie, kvoli indexacii ilp solveru
				visited_edges_by.emplace(edge, paths_through);
			}
			else {// zmenit vector pridanim aj tejto cesty (bol uz vlozeny neprazdny vector)
				visited_edges_by.find(edge)->second.push_back(i + 1); //cesty si pamatame o jedno vacsie, kvoli indexacii ilp solveru
			}
		}
	}
	//teraz je vo visited_edges_by pre kazdu pouzitu cestu v jej value vector vsetkych ciest ktore cez nu isli

	//vytvorenie solvera s premennymi pre kazdu cestu ktora ide zo zdroja od ustia
	std::vector<std::string> vrcholyS;
	for (int i = 0; i < finished_paths.size(); i++) {
		vrcholyS.push_back(std::to_string(i+1));
	}
	LPHelper lp{ vrcholyS };
	//zabezpecenie aby kazda cesta mala celociselne hodnoty -> vsetky hrany su celociselne
	for (int i = 1; i <= finished_paths.size(); i++) {
		lp.set_int(i, TRUE);
	}

	lp.set_add_rowmode(TRUE);
	//obmedzenia pre kazdu pouzitu hranu, ze jej spolocna priepustnost moze byt najviac jej priepustnost
	std::map<pair<int, int>, vector<int>>::iterator it;
	for (it = visited_edges_by.begin(); it != visited_edges_by.end(); it++) {
		//tu teraz treba prejst graf na danom mieste - kvoli tomuto to nebude fungovat na nasobnych hranach
		int flow = 0;
		for (int i = 0; i < graph.at(it->first.first).size(); i++) {
			if (graph.at(it->first.first).at(i).first == it->first.second) {
				flow = graph.at(it->first.first).at(i).second;
				break;
			}
		}
		std::vector<int> vrcholy_i_obmedzenia (it->second);		//cisla stlpcov ktore maju byt v obmedzeni
		std::vector<double> vrcholy_d_obmedzenia;	//koeficient pri tom ktorom stlpci - v nasom pripade to bude vzdy 1
		vrcholy_d_obmedzenia.assign(it->second.size(), 1);
		lp.add_constraint(vrcholy_d_obmedzenia, vrcholy_i_obmedzenia, LE, flow);
	}
	lp.set_add_rowmode(FALSE);

	std::vector<int> vrcholy_i;
	std::vector<double> vrcholy_d;

	for (int i = 0; i < finished_paths.size(); i++) {
		vrcholy_i.push_back(i + 1);
		vrcholy_d.push_back(1);
	}

	lp.set_obj_fn(vrcholy_d, vrcholy_i);
	lp.set_maxim();

	int res = lp.solve();

	if (res != OPTIMAL) { //ak sa to neda - pri zadavani urcitych vrcholov
		return -1;
	}
	return (int)lp.get_objective();

	return 0;
}

/// <summary>
/// Na danom grafe najde vsetky cesty, a pomocou nich vytvori obmedzenia pre LP,
/// a zisti kolko toto trvalo - aj kolko trval samotny LP, aj kolko aj dokopy,
/// s prevodom na tvar pre LP
/// </summary>
/// <param name="graph">Graf na ktorokm sa maspustit dany algoritmus</param>
/// <returns>Celkovy cas, Cas potrebny pre LP solver</returns>
std::pair<long long,long long> lp_solver_max_flow_time(std::vector<std::vector<pair<int, int>>> graph) {

	auto time_start_whole = high_resolution_clock::now();
	//na prvom mieste je  min na ceste, na druhej je cela cesta
	std::queue <std::vector<int>> fifo; //pre bfs

	std::vector<int> source_path;
	source_path.push_back(0);
	std::vector<int> source;
	source.push_back(0);
	fifo.push(source);

	//v tomto su zapamatane vsetky cesty ktore sa dostali do ustia
	std::vector<std::vector<int>> finished_paths;
	//tu je zapamatane ake su ohranicenia ciest - najmenej priespustna hrana na danej ceste
	std::vector<int> min_constraint_finished_paths;

	while (!fifo.empty()) {
		std::vector<int> vertex = fifo.front();
		fifo.pop();
		for (int i = 0; i < graph.at(vertex.at(vertex.size() - 1)).size(); i++) {
			std::vector<int> new_vertex(vertex);
			new_vertex.push_back(graph.at(vertex.at(vertex.size() - 1)).at(i).first);
			fifo.push(new_vertex);
		}

		//prave sme sa dostali do ustia, zapamatame si danu cestu
		if (vertex.at(vertex.size() - 1) == (graph.size() - 1)) {
			finished_paths.push_back(vertex);
			//if (finished_paths.size() > 1000000) {
			//	//alebo nejake ine cislo, jednoducho ked to uz bude priamo na solver - 
			//	return -2;
			//}
		}
	}
	//v tomto si pamatame ktore cesti isli cez ktoru hranu - len z tych, ktore sa dostali do ustia
	//		 hrana od  do    cesty cez nu
	std::map<pair<int, int>, vector<int>> visited_edges_by;

	//ak je skoncenych ciest 0, tak to treba hned ukoncit -> neda sa vlozit 0 stlcov do ilp (resp. sa neda s tym nic maximalizovat)
	if (finished_paths.empty()) {
		auto time_fast_stop = high_resolution_clock::now();
		auto duration = duration_cast<microseconds>(time_fast_stop - time_start_whole);
		return { duration.count(),0 };
	}

	//najskor je potrebne pre  kazdu pouzitu hranu zistit vsetky cesty ktore cez nu isli
	for (int i = 0; i < finished_paths.size(); i++) {
		int min = INT_MAX;
		for (int j = 1; j < finished_paths.at(i).size(); j++) {

			pair<int, int> edge(finished_paths.at(i).at(j - 1), finished_paths.at(i).at(j));

			if (visited_edges_by.find(edge) == visited_edges_by.end()) {//pridat vector (este tam nebol pre sanu hranu vlozeny vector)
				std::vector<int> paths_through;
				paths_through.push_back(i + 1);//cesty si pamatame o jedno vacsie, kvoli indexacii ilp solveru
				visited_edges_by.emplace(edge, paths_through);
			}
			else {// zmenit vector pridanim aj tejto cesty (bol uz vlozeny neprazdny vector)
				visited_edges_by.find(edge)->second.push_back(i + 1); //cesty si pamatame o jedno vacsie, kvoli indexacii ilp solveru
			}
		}
	}
	//teraz je vo visited_edges_by pre kazdu pouzitu cestu v jej value vector vsetkych ciest ktore cez nu isli

	//vytvorenie solvera s premennymi pre kazdu cestu ktora ide zo zdroja od ustia
	std::vector<std::string> vrcholyS;
	for (int i = 0; i < finished_paths.size(); i++) {
		vrcholyS.push_back(std::to_string(i + 1));
	}
	LPHelper lp{ vrcholyS };
	//zabezpecenie aby kazda cesta mala celociselne hodnoty -> vsetky hrany su celociselne
	for (int i = 1; i <= finished_paths.size(); i++) {
		lp.set_int(i, TRUE);
	}

	lp.set_add_rowmode(TRUE);
	//obmedzenia pre kazdu pouzitu hranu, ze jej spolocna priepustnost moze byt najviac jej priepustnost
	std::map<pair<int, int>, vector<int>>::iterator it;
	for (it = visited_edges_by.begin(); it != visited_edges_by.end(); it++) {
		//tu teraz treba prejst graf na danom mieste - kvoli tomuto to nebude fungovat na nasobnych hranach
		int flow = 0;
		for (int i = 0; i < graph.at(it->first.first).size(); i++) {
			if (graph.at(it->first.first).at(i).first == it->first.second) {
				flow = graph.at(it->first.first).at(i).second;
				break;
			}
		}
		std::vector<int> vrcholy_i_obmedzenia(it->second);		//cisla stlpcov ktore maju byt v obmedzeni
		std::vector<double> vrcholy_d_obmedzenia;	//koeficient pri tom ktorom stlpci - v nasom pripade to bude vzdy 1
		vrcholy_d_obmedzenia.assign(it->second.size(), 1);
		lp.add_constraint(vrcholy_d_obmedzenia, vrcholy_i_obmedzenia, LE, flow);
	}
	lp.set_add_rowmode(FALSE);

	std::vector<int> vrcholy_i;
	std::vector<double> vrcholy_d;

	for (int i = 0; i < finished_paths.size(); i++) {
		vrcholy_i.push_back(i + 1);
		vrcholy_d.push_back(1);
	}

	lp.set_obj_fn(vrcholy_d, vrcholy_i);
	lp.set_maxim();

	auto time_start_lp = high_resolution_clock::now();
	int res = lp.solve();
	auto time_stop_whole = high_resolution_clock::now();
	auto duration_whole = duration_cast<microseconds>(time_stop_whole - time_start_whole);
	auto duration_lp = duration_cast<microseconds>(time_stop_whole - time_start_lp);
	return { duration_whole.count(), duration_lp.count() };
}

#endif // !LP_SOLVER_MAX_FLOW
