from __future__ import print_function
from ortools.graph import pywrapgraph
import time

def test_file(filename):
    whole_time = 0
    
    with open(filename) as f:
        content = f.readlines()

    graph_num = -1
    graph_size = -1
    vector_size = 0
    vector_index = 0
    vector_edge_index = 0
    max_flow = pywrapgraph.SimpleMaxFlow()
    
    for line in content:
        #teraz je v line ulozeny riadok zo suboru
        if(graph_num == -1):
            #teraz sme na 1. riadku - nacitavame pocet grafov
            graph_num = int(line)
        elif(graph_size == -1):
            #teraz sme na nacitavani velkosti noveho grafu
            graph_size = int(line)
            vector_index = 0
            #vytvori sa novy solver
            max_flow = pywrapgraph.SimpleMaxFlow()            
        elif(vector_size == 0):
            #teraz sme na velkosti vektora
            vector_size = int(line)
            vector_edge_index = 0
            vector_index += 1
            
        else:
            #teraz sa nacitava hrana
            edge_s = line.split()
            edge_end = int(edge_s[0])
            edge_capacity = int(edge_s[1])
            vector_edge_index += 1
            max_flow.AddArcWithCapacity(vector_index - 1, edge_end, edge_capacity)
            #print(vector_index - 1, edge_end, edge_capacity)
        if(vector_edge_index == vector_size):
            #toto bola posledna hrana tohto vrcholu
            vector_size = 0
            if(vector_index == graph_size):
                #toto bol posledny vrchol
                time_start = time.time()
                max_flow.Solve(0, graph_size -1)
                time_stop = time.time()
                whole_time += (time_stop - time_start)
                graph_size = -1
                    
        #zvysok su uz iba hrany
    print(int(whole_time*1000000), end =" ")
    




for sparsity in range(3,10):
    for v in range(11):
        vert_num = 50 + v*5;
        filename = "rsg"+str(sparsity//10)+str(sparsity % 10)+"-"+str(vert_num//100)+str((vert_num%100)//10)+str(vert_num%10)
        test_file(filename)
    print()


for vert_num in range(50,101):
    filename = "rseg5-" + str(vert_num // 100) + str((vert_num % 100) // 10) + str(vert_num % 10)
    test_file(filename)
    print()








