import java.util.Objects;

public class Chord {
    private final Note chordRoot;
    private final ChordType chordType;
    private final String inNotation;

    public Chord(Note chordRoot, ChordType chordType){
        this.chordRoot = chordRoot;
        this.chordType = chordType;

        String inNotationTemp = chordRoot.toString();
        switch(this.chordType){
            case MINOR_TRIAD:
                inNotationTemp+="m";
                break;
            case AUGMENTED_TRIAD:
                inNotationTemp+="+";
                break;
            case DIMINISHED_TRIAD:
                inNotationTemp+="0";
                break;
            case DOMINANT_SEVENTH:
                inNotationTemp+="7";
                break;
            case DIMINISHED_MINOR_SEVENTH:
                inNotationTemp+="m07";
                break;
            case MAJOR_SEVENTH:
                inNotationTemp+="M7";
                break;
            case MINOR_SEVENTH:
                inNotationTemp+="m7";
                break;
            case AUGMENTED_SEVENTH:
                inNotationTemp+="+7";
                break;
            case MINOR_MAJOR_SEVENTH:
                inNotationTemp+="mM7";
                break;
            case DOMINANT_SEVENTH_INCOMPLETE:
                inNotationTemp+="7i";
                break;
            case DOMINANT_SEVENTH_ALT_INCOMPLETE:
                inNotationTemp+="7ai";
                break;
            case MAJOR_SEVENTH_INCOMPLETE:
                inNotationTemp+="M7i";
                break;
            case DIMINISHED_SEVENTH_INCOMPLETE:
                inNotationTemp+="07i";
                break;
            case DIMINISHED_MINOR_SEVENTH_INCOMPLETE:
                inNotationTemp+="m07i";
                break;
            case MINOR_MAJOR_SEVENTH_INCOMPLETE:
                inNotationTemp+="mM7i";
                break;
        }
        inNotation = inNotationTemp;
    }

    public String getInNotation(){
        return inNotation;
    }

    @Override
    public String toString() {
        return chordRoot.toString() +" "+ chordType.name();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Chord chord = (Chord) o;
        return Objects.equals(chordRoot, chord.chordRoot) && chordType == chord.chordType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(chordRoot, chordType);
    }

}
