import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;
import java.util.TreeMap;

public class MyPanel extends JPanel {
    private Graphics2D g2d;
    private final TreeMap<Integer, ArrayList<Section>> measures;
    private final int panelWidth = 1400;
    private final int panelHeight = 750;
    private final int measureWidth = panelWidth/9;
    private final int measureHeight = panelHeight/12;

    MyPanel(TreeMap<Integer, ArrayList<Section>> measures){
        this.setPreferredSize(new Dimension(panelWidth,panelHeight));
        this.measures = measures;
    }

    private void drawChordName(int x, int y,Chord chord){
        g2d.setColor(Color.BLACK);
        if(chord == null){
            g2d.setFont(new Font("Arial", Font.PLAIN, 9));
            g2d.drawString("n/a",x,y);
        }else {
            g2d.setFont(new Font("Arial", Font.BOLD, 9));
            g2d.drawString(chord.getInNotation(), x, y);
        }
    }

    private void drawSection(int x, int y, int length, Section section){
        g2d.setStroke(new BasicStroke(1));

        //chord above section

        drawChordName(x,y,section.getChord());

        //borders and color of the section

        g2d.drawRect(x,y+5,length,measureHeight);
        Color sectionColor = new Color(175,175,175);
        if(section.getScale() != null) {
            if (section.getScale().getScaleType().equals(ScaleType.DUR)) {
                sectionColor = Color.getHSBColor((float) 0.1, (float) 1,
                        (float) (1 - 0.03 * section.getScale().getScaleOrder()));
            } else {
                sectionColor = Color.getHSBColor((float) 0.6, (float) 1,
                        (float) (1 - 0.03 * section.getScale().getScaleOrder()));
            }
        }
        g2d.setColor(sectionColor);
        g2d.fillRect(x+1,y+5+1,length-1,measureHeight-1);

        //harmonic function

        g2d.setColor(Color.BLACK);
        if(section.getHarmonicFunction()!=null) {
            switch (section.getHarmonicFunction()) {
                case T:
                    g2d.setStroke(new BasicStroke(10));
                    g2d.drawLine(x + 5, y + 5 + measureHeight / 2, x + length - 4, y + 5 + measureHeight / 2);
                    break;
                case S:
                    g2d.setStroke(new BasicStroke(5));
                    g2d.drawLine(x+3, y + 7, x + length-3, y + 5 + measureHeight -3);
                    break;
                case D:
                    g2d.setStroke(new BasicStroke(5));
                    g2d.drawLine(x+3, y + 7, x + length-3, y + 5 + measureHeight-3);
                    g2d.drawLine(x+3, y + 7 + measureHeight -3, x + length-3, y + 7);
                    break;
                default:
                    g2d.setFont(new Font("Arial", Font.BOLD, 17));
                    g2d.drawString(section.getHarmonicFunction().name(), x +2, y + measureHeight/2 + 15);
                    break;
            }
        }
    }

    private void drawMeasure(int x, int y, ArrayList<Section> measure, int orderOfMeasure){
        g2d.setStroke(new BasicStroke(1));
        g2d.setColor(Color.RED);
        g2d.drawRect(x,y+5,measureWidth,measureHeight);


        double maxMeasure = measure.get(measure.size()-1).getEndOfSection();
        int lengthSum=0;
        for(Section section: measure){
            int length = (int)Math.round((section.getEndOfSection()/maxMeasure)* measureWidth) - lengthSum;
            drawSection(x + lengthSum,y,length,section);
            lengthSum+=length;
        }

    }

    public void paint(Graphics g){
        g2d = (Graphics2D) g;

        int x = 17;
        int y = 20;

        int i = measures.firstKey();
        while(i<=measures.lastKey()){
            drawMeasure(x,y,measures.get(i),i);
            x+=measureWidth+17;
            if(x > panelWidth - measureWidth -5){
                x = 17;
                y += measureHeight +20;
            }
            i++;
        }
    }
}
