import java.util.Objects;

public class Note {
    private final Natural natural;
    private final Accidental accidental;

    public Note(Natural natural, Accidental accidental){
        this.natural = natural;
        this.accidental = accidental;
    }

    @Override
    public String toString() {

        String result = natural.name();
        if(accidental == Accidental.SHARP){
            result+="#";
        } else if (accidental == Accidental.FLAT) {
            result+="b";
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Note note = (Note) o;
        return natural == note.natural && accidental == note.accidental;
    }

    @Override
    public int hashCode() {
        return Objects.hash(natural, accidental);
    }
}
