import java.util.Objects;

public class Scale {
    private final Note note;
    private final ScaleType scaleType;
    private int scaleOrder = 15;

    public Scale(Note note, ScaleType scaleType){
        this.note = note;
        this.scaleType = scaleType;
        if(scaleType.equals(ScaleType.DUR)){
            if(note.equals(new Note(Natural.C,Accidental.NONE))){
                scaleOrder = 0;
            }else if(note.equals(new Note(Natural.G,Accidental.NONE))){
                scaleOrder = 1;
            }else if(note.equals(new Note(Natural.D,Accidental.NONE))){
                scaleOrder = 2;
            }else if(note.equals(new Note(Natural.A,Accidental.NONE))){
                scaleOrder = 3;
            }else if(note.equals(new Note(Natural.E,Accidental.NONE))){
                scaleOrder = 4;
            }else if(note.equals(new Note(Natural.B,Accidental.NONE))){
                scaleOrder = 5;
            }else if(note.equals(new Note(Natural.F,Accidental.SHARP))){
                scaleOrder = 6;
            }else if(note.equals(new Note(Natural.C,Accidental.SHARP))){
                scaleOrder = 7;
            }else if(note.equals(new Note(Natural.F,Accidental.NONE))){
                scaleOrder = 8;
            }else if(note.equals(new Note(Natural.B,Accidental.FLAT))){
                scaleOrder = 9;
            }else if(note.equals(new Note(Natural.E,Accidental.FLAT))){
                scaleOrder = 10;
            }else if(note.equals(new Note(Natural.A,Accidental.FLAT))){
                scaleOrder = 11;
            }else if(note.equals(new Note(Natural.D,Accidental.FLAT))){
                scaleOrder = 12;
            }else if(note.equals(new Note(Natural.G,Accidental.FLAT))){
                scaleOrder = 13;
            }else if(note.equals(new Note(Natural.C,Accidental.FLAT))){
                scaleOrder = 14;
            }

        }else{
            if(note.equals(new Note(Natural.A,Accidental.NONE))){
                scaleOrder = 0;
            }else if(note.equals(new Note(Natural.E,Accidental.NONE))){
                scaleOrder = 1;
            }else if(note.equals(new Note(Natural.B,Accidental.NONE))){
                scaleOrder = 2;
            }else if(note.equals(new Note(Natural.F,Accidental.SHARP))){
                scaleOrder = 3;
            }else if(note.equals(new Note(Natural.C,Accidental.SHARP))){
                scaleOrder = 4;
            }else if(note.equals(new Note(Natural.G,Accidental.SHARP))){
                scaleOrder = 5;
            }else if(note.equals(new Note(Natural.D,Accidental.SHARP))) {
                scaleOrder = 6;
            }else if(note.equals(new Note(Natural.A,Accidental.SHARP))){
                scaleOrder = 7;
            }else if(note.equals(new Note(Natural.D,Accidental.NONE))){
                scaleOrder = 8;
            }else if(note.equals(new Note(Natural.G,Accidental.NONE))){
                scaleOrder = 9;
            }else if(note.equals(new Note(Natural.C,Accidental.NONE))){
                scaleOrder = 10;
            }else if(note.equals(new Note(Natural.F,Accidental.NONE))){
                scaleOrder = 11;
            }else if(note.equals(new Note(Natural.B,Accidental.FLAT))){
                scaleOrder = 12;
            }else if(note.equals(new Note(Natural.E,Accidental.FLAT))){
                scaleOrder = 13;
            }else if(note.equals(new Note(Natural.A,Accidental.FLAT))){
                scaleOrder = 14;
            }
        }
    }

    public Note getNote() {
        return note;
    }

    public ScaleType getScaleType() {
        return scaleType;
    }

    public int getScaleOrder() {
        return scaleOrder;
    }

    @Override
    public String toString() {
        return note.toString() + " " + scaleType.name();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Scale scale = (Scale) o;
        return Objects.equals(note, scale.note) && scaleType == scale.scaleType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(note, scaleType);
    }
}
