import java.util.Objects;

public class Section {
    private int orderOfMeasure;
    private double endOfSection;
    private Chord chord;
    private Scale scale;
    private HarmonicFunction harmonicFunction;
    private String fileName;

    public Section(int orderOfMeasure, double endOfSection, Chord chord, Scale scale, HarmonicFunction harmonicFunction,
                   String fileName){
        this.orderOfMeasure = orderOfMeasure;
        this.endOfSection = endOfSection;
        this.chord = chord;
        this.scale = scale;
        this.harmonicFunction = harmonicFunction;
        this.fileName = fileName;
    }

    public int getOrderOfMeasure(){
        return orderOfMeasure;
    }

    public double getEndOfSection() {
        return endOfSection;
    }

    public Chord getChord() {
        return chord;
    }

    public Scale getScale() {
        return scale;
    }

    public HarmonicFunction getHarmonicFunction() {
        return harmonicFunction;
    }

    public String getFileName() {
        return fileName;
    }

    public boolean sectionEquals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Section section = (Section) o;
        return Objects.equals(chord, section.chord)
                && Objects.equals(scale, section.scale)
                && Objects.equals(harmonicFunction, section.harmonicFunction);
    }

    @Override
    public String toString() {

        String chStr;
        String scStr;
        String haStr;

        if(chord == null){
            chStr = "null";
        }else{
            chStr = chord.toString();
        }
        if(scale == null){
            scStr = "null";
        }else{
            scStr = scale.toString();
        }
        if(harmonicFunction == null){
            haStr = "null";
        }else{
            haStr = harmonicFunction.name();
        }

        return orderOfMeasure+":"+endOfSection+":"+chStr+":"+scStr+":"+haStr+":"+fileName;

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Section section = (Section) o;
        return orderOfMeasure == section.orderOfMeasure
                && Double.compare(section.endOfSection, endOfSection) == 0
                && Objects.equals(chord, section.chord) && Objects.equals(scale, section.scale)
                && Objects.equals(harmonicFunction, section.harmonicFunction)
                && Objects.equals(fileName, section.fileName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderOfMeasure, endOfSection, chord, scale, harmonicFunction, fileName);
    }
}
