public class SectionFactoryImpl implements SectionFactory{

    public Note createNote(String noteStr){
        String[] noteArr = noteStr.split("");

        if(noteArr.length == 1){
            return new Note(Natural.valueOf(noteArr[0]),Accidental.NONE);
        }

        if(noteArr[1].equals("b")){
            return new Note(Natural.valueOf(noteArr[0]),Accidental.FLAT);
        }

        if(noteArr[1].equals("#")){
            return new Note(Natural.valueOf(noteArr[0]),Accidental.SHARP);
        }

        return new Note(Natural.valueOf(noteArr[0]),Accidental.NONE);
    }

    public Chord createChord(String chordStr){
        if(chordStr.equals("null")){
            return null;
        }

        String[] chordArr = chordStr.split(" ");
        return new Chord(createNote(chordArr[0]),ChordType.valueOf(chordArr[1]));
    }

    public Scale createScale(String scaleStr){
        if(scaleStr.equals("null")){
            return null;
        }

        String[] scaleArr = scaleStr.split(" ");
        return new Scale(createNote(scaleArr[0]),ScaleType.valueOf(scaleArr[1]));
    }

    public HarmonicFunction createHarmonicFunction(String harmonicFunStr){
        if(harmonicFunStr.equals("null")){
            return null;
        }
        String[] harmonicFunctionArr = harmonicFunStr.split(" ");
        return HarmonicFunction.valueOf(harmonicFunctionArr[0]);
    }

    @Override
    public Section createSection(String line) {
        String[] data = line.split(":");
        int orderOfMeasure = Integer.parseInt(data[0]);
        double endOfSection = Double.parseDouble(data[1]);
        Chord chord = createChord(data[2].substring(1));
        Scale scale = createScale(data[4]);
        HarmonicFunction harmonicFunction = createHarmonicFunction(data[5]);
        String fileName = data[7];

        return new Section(orderOfMeasure,endOfSection,chord,scale,harmonicFunction,fileName);
    }
}
