import java.io.*;
import java.util.ArrayList;
import java.util.TreeMap;

public class TextOutputProcessorImpl implements TextOutputProcessor{

    private final SectionFactory sectionFactory;

    public TextOutputProcessorImpl(SectionFactory sectionFactory){
        this.sectionFactory = sectionFactory;
    }

    @Override
    public TreeMap<Integer,ArrayList<Section>> processFile(File file) throws IOException {

        TreeMap<Integer,ArrayList<Section>> measures = new TreeMap<>();

        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line;

        Section section;
        while((line = bufferedReader.readLine()) != null){
            section = sectionFactory.createSection(line);
            int orderOfMeasure = section.getOrderOfMeasure();
            if(!measures.containsKey(orderOfMeasure)){
                measures.put(orderOfMeasure,new ArrayList<>());
            }
            measures.get(orderOfMeasure).add(section);
        }
        return measures;
    }
}
