
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 *
 * @author vacha
 */
public class AnalyzaDB {

    static String USERNAME = "root";
    static String PASSWORD = "bcanalyzadb";
    //static String CONN_STRING = "jdbc:mysql://localhost:3306/sources";
    static String CONN_STRING = "jdbc:mysql://localhost:3306/sources?useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC";
    static String BAK_PRACA_PATH = "C:\\Users\\vacha\\Documents\\MATFYZ\\Bakalárska práca\\";
    static Connection CON = null;
    
    public static void main(String[] args) throws SQLException, IOException, ParserConfigurationException, SAXException {
        //PRIPOJENIE DO DB:
        Connection con = null;
        try {
            con = DriverManager.getConnection(CONN_STRING, USERNAME, PASSWORD);
            CON = con;
        } catch (SQLException e) {
            System.err.println(e);
            System.out.println("CHYBA");
        }
        
        clearErrorTypes(CON);
        clearResults();
        clearPrevFilesForCppcheck();
        cppcheckAnalysis(CON, 1000);
        File folder_xmls = new File("C:\\Users\\vacha\\Documents\\MATFYZ\\Bakalárska práca\\CppDepend Projects\\CppDependOut1\\Incremental\\C8631FCE0C43129E23C74A2BFF0CAEBF8D9FFC6A\\CppCheck");
        //cppdependAnalysis(CON, folder_xmls);
        // !!! treba znova nagenerovat subory do incremental podla novo nazvanych vo folderi rieseni a podla novych nazvov upravit split naspodu
        // !!! aby som vedel aj z cppdependu zistit who, examId a when
        
        
        
        //SPUSTANIE CPPCHECK-U V KONZOLE:
        //nad priecinkom folder_rieseni spusti cppcheck, vysledok naformatuje do xml a automaticky ulozi do definovaneho output file-u
        /*Process process = Runtime.getRuntime().exec("cppcheck folder_rieseni --xml "
                + "--output-file=\"C:\\Users\\vacha\\Documents\\MATFYZ\\Bakalárska práca\\folder_rieseni\\vystup.xml\"", 
                null, new File(BAK_PRACA_PATH)); //tu v riadku vyssie musi byt path v uvodzovkach, preto nie je v premennej kt. je bez nich
        printResults(process);
        
        //XML PARSER:
        File file = new File(BAK_PRACA_PATH+"folder_rieseni\\vystup.xml");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        NodeList errory = document.getElementsByTagName("error");  //errory je list vsetkych tagov error
        for (int i = 0; i < errory.getLength(); i++) {
            Node error = errory.item(i);  //error je jeden konkretny tag error
            NamedNodeMap atts = error.getAttributes();  //atts su vsetky atributy jedneho erroru
            for (int j = 0; j < atts.getLength(); j++) {
                System.out.println(atts.item(j).getNodeName()+" = "+atts.item(j).getNodeValue());
                //teraz som sa dostal k nazvu atributu (to je to getNodeName())
                
            }
        }*/
    }
    
    public static void cppcheckAnalysis(Connection con, int numOfFiles) throws SQLException, ParserConfigurationException, SAXException {
        //SQL KOD:
        //String sql = "SELECT * FROM sources LIMIT 250;";
        String sql = "SELECT * FROM sources.sources ORDER BY 'when' DESC";//LIMIT "+String.valueOf(numOfFiles);
        //WHERE 'failed' = 0
        PreparedStatement preparedStatement = con.prepareStatement(sql);
        ResultSet res = preparedStatement.executeQuery();
        
        //PRIDAVANIE NOVYCH SUBOROV DO PRIECINKA:
        int num = 0;
        while (res.next()) {
            try {
                File newFile = new File(BAK_PRACA_PATH+"folder_rieseni\\"+res.getString("who")+"_"+res.getString("examId")+"_"+res.getString("when")+".cpp");
                if (newFile.createNewFile()) {
                    FileWriter writer = new FileWriter(BAK_PRACA_PATH+"folder_rieseni\\"+res.getString("who")+"_"+res.getString("examId")+"_"+res.getString("when")+".cpp");
                    writer.write(res.getString("data"));
                    writer.close();
                } else {
                    System.out.println("Uz existuje");
                }
                Process process = Runtime.getRuntime().exec("cppcheck "+res.getString("who")+"_"+res.getString("examId")+"_"+res.getString("when")+".cpp "
                        + "--xml --output-file=\"C:\\Users\\vacha\\Documents\\MATFYZ\\Bakalárska práca\\folder_rieseni\\vystup.xml\"",
                        null, new File(BAK_PRACA_PATH+"folder_rieseni"));
                printResults(process);
                
                File file = new File(BAK_PRACA_PATH+"folder_rieseni\\vystup.xml");
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory
                        .newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                NodeList errory = document.getElementsByTagName("error");  //errory je list vsetkych tagov error
                for (int i = 0; i < errory.getLength(); i++) {
                    Node error = errory.item(i);  //error je jeden konkretny tag error
                    NamedNodeMap atts = error.getAttributes();  //atts su vsetky atributy jedneho erroru
                    for (int j = 0; j < atts.getLength(); j++) {
                        System.out.println(atts.item(j).getNodeName()+" = "+atts.item(j).getNodeValue());
                        //teraz som sa dostal k nazvu atributu (to je to getNodeName())
                        //teraz je po novom idea: ak najde AKUKOLVEK chybu, pozrie sa do tabulky error_types a ak tam ta chyba uz je, 
                        //normalne na nu nareferencuje konkretne riesenie, inak vytvori do tabulky error_types novy riadok s touto chybou
                        //a referenciu spravi nasledne nanho
                        //CHECK IF ERROR ALREADY EXISTS IN OUR LIST:
                        if (atts.item(j).getNodeName().equals("id")) {
                            String sqlErr = "SELECT count(*) as count FROM error_types WHERE name = \""+atts.item(j).getNodeValue()+"\"";
                            PreparedStatement psErr = con.prepareStatement(sqlErr);
                            ResultSet resErr = psErr.executeQuery();
                            if (resErr.next() && resErr.getInt("count")==0) {
                                //viem, ze neexistuje, treba ju pridat
                                String sqlErrInsert = "INSERT INTO error_types VALUES (null, ?, ?)";
                                PreparedStatement psErrorInsert = con.prepareStatement(sqlErrInsert);
                                psErrorInsert.setString(1, atts.item(j).getNodeValue());
                                psErrorInsert.setString(2, "cppcheck");
                                psErrorInsert.executeUpdate();
                            }
                            //pridam referenciu
                            String sql2 = "INSERT INTO results VALUES (?, ?, ?, ?, ?, ?, ?, ?);";
                            PreparedStatement ps = con.prepareStatement(sql2);
                            ps.setInt(1, res.getInt("who"));
                            ps.setInt(2, res.getInt("examId"));
                            ps.setInt(3, res.getInt("when"));
                            ps.setString(8, "cppcheck");
                            String sql3 = "SELECT * FROM error_types WHERE name = \""+atts.item(j).getNodeValue()+"\"";
                            PreparedStatement ps3 = con.prepareStatement(sql3);
                            ResultSet res3 = ps3.executeQuery();
                            res3.next();
                            ps.setInt(4, res3.getInt("id"));
                            ps.setString(5, atts.getNamedItem("msg").getNodeValue());
                            for (int a = 0; a < error.getChildNodes().getLength(); a++) {
                                if (error.getChildNodes().item(a).getNodeName().equals("location")) {
                                    NamedNodeMap attsins = error.getChildNodes().item(a).getAttributes();
                                    for (int b = 0; b < attsins.getLength(); b++) {
                                        if (attsins.item(b).getNodeName().equals("line")) {
                                            ps.setInt(6, Integer.parseInt(attsins.item(b).getNodeValue()));
                                        }
                                        if (attsins.item(b).getNodeName().equals("column")) {
                                            ps.setInt(7, Integer.parseInt(attsins.item(b).getNodeValue()));
                                        }
                                    }
                                }
                            }
                            ps.executeUpdate();
                        }
                    }
                }
                
            } catch (IOException e) {
                System.out.println("CHYBA");
                e.printStackTrace();
            }
            num++;
        }
    }
    
    public static void cppdependAnalysis(Connection con, File folder) throws SAXException, IOException, ParserConfigurationException, SQLException {
        for (File xmlFile : folder.listFiles()) {
            //KAZDY XML FILE ZANALYZOVAT:
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlFile);
            NodeList errory = document.getElementsByTagName("error");
            for (int i = 0; i < errory.getLength(); i++) {
                Node error = errory.item(i);  //error je jeden konkretny tag error
                NamedNodeMap atts = error.getAttributes();  //atts su vsetky atributy jedneho erroru
                for (int j = 0; j < atts.getLength(); j++) {
                    System.out.print(atts.item(j).getNodeName()+" = "+atts.item(j).getNodeValue()+", ");
                    System.out.println("^ "+xmlFile.getName());
                    if (atts.item(j).getNodeName().equals("id") && !atts.item(j).getNodeValue().equals("unmatchedSuppression")
                            && !atts.item(j).getNodeValue().equals("missingInclude") && !atts.item(j).getNodeValue().equals("missingIncludeSystem")) {
                        String sqlErr = "SELECT count(*) as count FROM error_types WHERE name = \""+atts.item(j).getNodeValue()+"\"";
                        PreparedStatement psErr = con.prepareStatement(sqlErr);
                        ResultSet resErr = psErr.executeQuery();
                        if (resErr.next() && resErr.getInt("count")==0) {
                            //viem, ze neexistuje, treba ju pridat
                            String sqlErrInsert = "INSERT INTO error_types VALUES (null, ?, ?)";
                            PreparedStatement psErrorInsert = con.prepareStatement(sqlErrInsert);
                            psErrorInsert.setString(1, atts.item(j).getNodeValue());
                            psErrorInsert.setString(2, "cppdepend");
                            psErrorInsert.executeUpdate();
                        }
                        //pridam referenciu
                        String sql2 = "INSERT INTO results VALUES (?, ?, ?, ?, ?, ?, null, ?);";
                        PreparedStatement ps = con.prepareStatement(sql2);
                        //ps.setInt(1, Integer.parseInt(atts.getNamedItem("location").getAttributes().getNamedItem("file0").getNodeValue().split("_")[1].split(".")[0]));
                        //ps.setInt(2, res.getInt("examId"));
                        //ps.setInt(3, res.getInt("when"));
                        String sql3 = "SELECT * FROM error_types WHERE name = \""+atts.item(j).getNodeValue()+"\"";
                        PreparedStatement ps3 = con.prepareStatement(sql3);
                        ResultSet res3 = ps3.executeQuery();
                        res3.next();
                        //ps.setInt(2, -1);
                        //ps.setInt(3, -1);
                        ps.setInt(4, res3.getInt("id"));
                        ps.setString(7, "cppdepend");
                        ps.setString(5, atts.getNamedItem("msg").getNodeValue());
                        for (int a = 0; a < error.getChildNodes().getLength(); a++) {
                            if (error.getChildNodes().item(a).getNodeName().equals("location")) {
                                NamedNodeMap attsins = error.getChildNodes().item(a).getAttributes();
                                for (int b = 0; b < attsins.getLength(); b++) {
                                    if (attsins.item(b).getNodeName().equals("line")) {
                                        ps.setInt(6, Integer.parseInt(attsins.item(b).getNodeValue()));
                                    }
                                    if (attsins.item(b).getNodeName().equals("file0") || attsins.item(b).getNodeName().equals("file")) {
                                        //System.out.println("A"+attsins.item(b).getNodeValue().split("_")[1].substring(0, attsins.item(b).getNodeValue().split("_")[1].length()-4));
                                        ps.setInt(1, Integer.parseInt(attsins.item(b).getNodeValue().split("\\\\")[attsins.item(b).getNodeValue().split("\\\\").length-1].split("\\.")[0].split("\\_")[0]));
                                        ps.setInt(2, Integer.parseInt(attsins.item(b).getNodeValue().split("\\\\")[attsins.item(b).getNodeValue().split("\\\\").length-1].split("\\.")[0].split("\\_")[1]));
                                        ps.setInt(3, Integer.parseInt(attsins.item(b).getNodeValue().split("\\\\")[attsins.item(b).getNodeValue().split("\\\\").length-1].split("\\.")[0].split("\\_")[2]));

                                    }
                                }
                            }
                        }
                        ps.executeUpdate();
                    }
                }
                System.out.println("");
            }
        }
    }
    
    public static void deleteAllFilesInFolder(final File folder) {
    for (final File fileEntry : folder.listFiles()) {
        if (fileEntry.isDirectory()) {
            deleteAllFilesInFolder(fileEntry);
        } else {
            fileEntry.delete();
            System.out.println("DELETED: "+fileEntry.getName());
        }
    }
    }
    
    public static void printResults(Process process) throws IOException {
    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
    String line = "";
    while ((line = reader.readLine()) != null) {
        System.out.println(line);
    }
}
    public static void clearResults() throws SQLException {
        String sql = "DELETE FROM results;";
        PreparedStatement ps = CON.prepareStatement(sql);
        ps.executeUpdate();
    }
    
    public static void clearErrorTypes(Connection con) throws SQLException {
        //PRECISTI TABULKU typov chyb:
        String sqlDel = "DELETE FROM error_types;";
        PreparedStatement psDel = con.prepareStatement(sqlDel);
        psDel.executeUpdate();
    }
    
    public static void clearPrevFilesForCppcheck() throws SQLException {
        File folder = new File(BAK_PRACA_PATH+"folder_rieseni");
        deleteAllFilesInFolder(folder);
    }
    
}
