function parseData(data) {
    console.log("...PARSING DATA...");
    console.log(data);
    graph1Draw(data);
}
function semesterFrequency() {
    var selected = document.getElementById("contents");
    var selectedOption = selected.options[selected.selectedIndex].value;
    var selectedYear = document.getElementById('year');
    var selectedOptionYear = selectedYear.options[selectedYear.selectedIndex].value;
    var c = document.getElementById("graph1");
    var ctx = c.getContext("2d");
    ctx.clearRect(0, 0, c.width, c.height);
    if (selectedOption === "1") {
        $.post('ajaxRequests/semesterFrequency.php', {year:selectedOptionYear}, function (data) {
            console.log(JSON.parse(data));
            console.log("TYPE: " + typeof JSON.parse(data));
            data = JSON.parse(data);
            if (typeof data === 'object') {
                console.log("length: " + data.length);
                graph1Draw(data);
            }
        });
    } else if (selectedOption === "2") {
        $.post('ajaxRequests/allFivePerWeeks.php', {year:selectedOptionYear}, function (data) {
            console.log("YEAR"+selectedOptionYear);
            data = JSON.parse(data);
            if (typeof data === 'object') {
                graph2Draw(data);
            }
        })
    } else if (selectedOption === "3") {
        $.post('ajaxRequests/withoutPenalization.php', {year:selectedOptionYear}, function (data) {
            data = JSON.parse(data);
            if (typeof data === 'object') {
                graph3Draw(data);
            }
        })
    }
}

function graph1Draw(data) {
    let y = document.getElementById("graph1").getAttribute("height").valueOf()-50;
    let daysSem1 = Math.floor(45440011/86400);
    console.log(daysSem1);
    var c = document.getElementById("graph1");
    var ctx = c.getContext("2d");
    ctx.lineWidth = 1;
    ctx.beginPath();
    ctx.moveTo(0, y);
    ctx.lineTo(132*5, y);
    ctx.strokeStyle = 'black';
    ctx.stroke();
    for (let x = 0; x <= 132*5; x+=5) {
        ctx.beginPath();
        ctx.moveTo(x, y);
        ctx.lineTo(x, y-data[x/5][0]);
        ctx.font = "8px Arial";
        ctx.fillText(data[x/5][2], x, y+10);
        console.log(x/5);
        if (data[x/5][2] == 7) {
            ctx.fillText(data[x/5][1].substring(5), x, y+20);
            ctx.strokeStyle = 'blue';
        } else {
            ctx.strokeStyle = 'black';
        }
        ctx.stroke();
    }
    ctx.font = "20px Arial";
    var selected = document.getElementById("contents");
    var selectedOptionText = selected.options[selected.selectedIndex].text;
    ctx.fillText(selectedOptionText, 132*5/2/2, y+40);
    ctx.stroke();

}

function graph2Draw(data) {
    console.log(data);
    let y = document.getElementById("graph1").getAttribute("height").valueOf()-50;
    var c = document.getElementById("graph1");
    var ctx = c.getContext("2d");
    var columnWidth = 40;
    var spaceWidth = 5;
    ctx.lineWidth = 1;
    ctx.beginPath();
    ctx.moveTo(0, y);
    ctx.lineTo((columnWidth+spaceWidth)*13, y);  //40 lebo 30 je hrubka stlpca a 10 je medzera za nim
    ctx.strokeStyle = 'black';
    ctx.stroke();
    var tyzden = 0;
    var index = 0;
    var completed = false;
    while (!completed) {
        tyzden++;
        ctx.beginPath();
        ctx.strokeStyle = '#a6033c';
        ctx.lineWidth = columnWidth;
        if (parseInt(data[index][1]) === tyzden) {
            ctx.moveTo((tyzden-1)*(columnWidth+spaceWidth)+columnWidth/2, y); //45 je hrubka stlpca (40) plus medzera (5)
            ctx.lineTo((tyzden-1)*(columnWidth+spaceWidth)+columnWidth/2, y-10*data[index][0]);
            console.log("INDEX: "+index);
            if (index + 1 < data.length) {
                index++;
            }
        }
        ctx.stroke();
        ctx.beginPath();
        ctx.strokeStyle = 'black';
        ctx.font = "12px Arial";
        ctx.fillText(tyzden, (tyzden-1)*(columnWidth+spaceWidth)+columnWidth/2-6, y+15);
        ctx.stroke();
        if (tyzden === 13) {
            completed = true;
        }
    }
    ctx.font = "20px Arial";
    var selected = document.getElementById("contents");
    var selectedOptionText = selected.options[selected.selectedIndex].text;
    ctx.fillText(selectedOptionText, 20, y+40);
    ctx.stroke();
}

function graph3Draw(data) {
    console.log(data);
    let y = document.getElementById("graph1").getAttribute("height").valueOf()-50;
    var c = document.getElementById("graph1");
    var ctx = c.getContext("2d");
    var columnWidth = 40;
    var spaceWidth = 5;
    ctx.lineWidth = 1;
    ctx.beginPath();
    ctx.moveTo(0, y);
    ctx.lineTo((columnWidth+spaceWidth)*13, y);  //40 lebo 30 je hrubka stlpca a 10 je medzera za nim
    ctx.strokeStyle = 'black';
    ctx.stroke();
    var tyzden = 0;
    var index = 0;
    var completed = false;
    while (!completed) {
        tyzden++;
        ctx.beginPath();
        ctx.strokeStyle = '#cc3300';
        ctx.lineWidth = columnWidth;
        if (parseInt(data[index][1]) === tyzden) {
            ctx.moveTo((tyzden-1)*(columnWidth+spaceWidth)+columnWidth/2, y); //45 je hrubka stlpca (40) plus medzera (5)
            ctx.lineTo((tyzden-1)*(columnWidth+spaceWidth)+columnWidth/2, y-data[index][0]);
            console.log("INDEX: "+index);
            if (index + 1 < data.length) {
                index++;
            }
        }
        ctx.stroke();
        ctx.beginPath();
        ctx.strokeStyle = 'black';
        ctx.font = "12px Arial";
        ctx.fillText(tyzden, (tyzden-1)*(columnWidth+spaceWidth)+columnWidth/2-6, y+15);
        ctx.stroke();
        if (tyzden === 13) {
            completed = true;
        }
    }
    ctx.font = "20px Arial";
    var selected = document.getElementById("contents");
    var selectedOptionText = selected.options[selected.selectedIndex].text;
    ctx.fillText(selectedOptionText, 20, y+40);
    ctx.stroke();
}