/*
 * Decompiled with CFR 0.152.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import rdg.BaseFinder;
import rdg.Bookmakers;

public class NajdiBookmaker
extends BaseFinder<Bookmakers> {
    private static final NajdiBookmaker INSTANCE = new NajdiBookmaker();

    public static NajdiBookmaker getInstance() {
        return INSTANCE;
    }

    private NajdiBookmaker() {
    }

    public Bookmakers findById(int id) throws SQLException {
        return (Bookmakers)this.findByInt("SELECT * FROM bookmaker WHERE id = ?", id);
    }

    public List<Bookmakers> findNaj() throws SQLException {
        return this.findAll("SELECT * FROM bookmaker ORDER BY zetony ASC LIMIT 3");
    }

    public Bookmakers findByLogin(String login) throws SQLException {
        return (Bookmakers)this.findByString("SELECT * FROM bookmaker WHERE login = ?", login);
    }

    public boolean findByLoginBool(String login) {
        try {
            return !((Bookmakers)this.findByString("SELECT * FROM bookmaker WHERE login = ?", login)).equals(null);
        }
        catch (NullPointerException | SQLException ex) {
            return false;
        }
    }

    public List<Bookmakers> findAll() throws SQLException {
        return this.findAll("SELECT * FROM bookmaker");
    }

    @Override
    protected Bookmakers load(ResultSet r) throws SQLException {
        Bookmakers c = new Bookmakers();
        c.setId(r.getInt("id"));
        c.setMeno(r.getString("meno"));
        c.setLogin(r.getString("login"));
        c.setHeslo(r.getString("heslo"));
        c.setPriezvisko(r.getString("priezvisko"));
        c.setZetony(r.getInt("zetony"));
        return c;
    }
}

