/*
 * Decompiled with CFR 0.152.
 */
package rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import rdg.BaseFinder;
import rdg.Udalosti;

public class NajdiUdalost
extends BaseFinder<Udalosti> {
    private static final NajdiUdalost INSTANCE = new NajdiUdalost();

    public static NajdiUdalost getInstance() {
        return INSTANCE;
    }

    private NajdiUdalost() {
    }

    public Udalosti findById(int id) throws SQLException {
        return (Udalosti)this.findByInt("SELECT * FROM udalost WHERE id = ?", id);
    }

    public Udalosti findByIdUdalosti(int id) throws SQLException {
        return (Udalosti)this.findByInt("SELECT * FROM udalost WHERE id_udalost = ?", id);
    }

    public List<Udalosti> findNaj() {
        try {
            return this.findAll("SELECT * FROM udalost WHERE koniec_stavkovania>=NOW() ORDER BY pocetpodani ASC LIMIT 3");
        }
        catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
            return null;
        }
    }

    public List<Udalosti> findAktualne() {
        try {
            return this.findAll("SELECT * FROM udalost WHERE koniec_stavkovania>=NOW()");
        }
        catch (SQLException ex) {
            System.out.println("Nenasla sa ziadna udalost");
            return null;
        }
    }

    public List<Udalosti> findAll() throws SQLException {
        return this.findAll("SELECT * FROM udalost ");
    }

    @Override
    protected Udalosti load(ResultSet r) throws SQLException {
        Udalosti c = new Udalosti();
        c.setId(r.getInt("id"));
        c.setIdBookmaker(r.getInt("id_bookmaker"));
        c.setDatumKonania(r.getTimestamp("datum_konania"));
        c.setKoniecStavkovania(r.getTimestamp("koniec_stavkovania"));
        c.setPocetPodani(r.getInt("pocetpodani"));
        return c;
    }
}

